/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class DurableIdGenerator {
    private static final long CHUNK_SIZE = 0x100000L;
    private final @NonNull IStore store;
    private final @NonNull String keyName;
    private long nextId = 0L;
    private long maxReservedId = -1L;

    DurableIdGenerator(@NonNull IStore store, @NonNull String keyName) {
        this.store = store;
        this.keyName = keyName;
    }

    public synchronized long getNextId() throws StorageException {
        if (this.nextId > this.maxReservedId) {
            this.reserveMoreIds();
        }
        return this.nextId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveMoreIds() throws StorageException {
        Lock lock = this.store.obtainLock(this.keyName);
        lock.lock();
        try {
            long currentMaxId = 0L;
            byte[] rawValue = this.store.get(StringUtils.stringToBytes((String)this.keyName));
            if (rawValue != null) {
                currentMaxId = ByteArrayUtils.byteArrayToLong((byte[])rawValue);
            }
            this.nextId = currentMaxId + 1L;
            this.maxReservedId = currentMaxId + 0x100000L;
            this.store.put(StringUtils.stringToBytes((String)this.keyName), ByteArrayUtils.longToByteArray((long)this.maxReservedId));
        }
        finally {
            lock.unlock();
        }
    }
}

