/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.mem;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StorageSystemBase;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class InMemoryStorageSystem
extends StorageSystemBase {
    private Map<String, InMemoryStore> stores = new HashMap<String, InMemoryStore>();
    private Map<String, InMemoryStore> snapshot;

    public InMemoryStorageSystem() {
        this(0);
    }

    public InMemoryStorageSystem(int storageSystemId) {
        super(storageSystemId);
    }

    InMemoryStorageSystem(InMemoryStorageSystem other) {
        super(other.getStorageSystemId());
        this.snapshot = null;
        for (Map.Entry<String, InMemoryStore> entry : other.stores.entrySet()) {
            this.stores.put(entry.getKey(), new InMemoryStore(entry.getValue()));
        }
    }

    @Override
    public synchronized IStore openStore(String name) throws StorageException {
        InMemoryStore store = this.stores.get(name);
        if (store == null) {
            store = new InMemoryStore();
            this.stores.put(name, store);
        }
        return store;
    }

    @Override
    public synchronized void removeStore(String storeName) {
        this.stores.remove(storeName);
    }

    public synchronized void clear() {
        this.snapshot = null;
        for (InMemoryStore store : this.stores.values()) {
            store.clear();
        }
    }

    public synchronized String getUsageStatistics(boolean detailed) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, InMemoryStore> entry : this.stores.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue().getUsageStatistics(detailed)).append(StringUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public synchronized void createSnapshot() {
        this.snapshot = new HashMap<String, InMemoryStore>(this.stores);
        for (InMemoryStore store : this.snapshot.values()) {
            store.createSnapshot();
        }
    }

    public synchronized void restoreFromSnapshot() {
        CCSMAssert.isTrue((boolean)this.hasSnapshot(), (String)"Must create a snapshot before restoring!");
        this.stores = new HashMap<String, InMemoryStore>(this.snapshot);
        for (InMemoryStore store : this.stores.values()) {
            store.restoreFromSnapshot();
        }
    }

    public synchronized boolean hasSnapshot() {
        return this.snapshot != null;
    }

    void dumpSnapshotBackup(String storageSystemName, ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
        for (Map.Entry<String, InMemoryStore> entry : this.stores.entrySet()) {
            snapshotConsumer.startStore(storageSystemName, entry.getKey());
            entry.getValue().dumpSnapshotBackup(snapshotConsumer);
            snapshotConsumer.endStore();
        }
    }
}

