/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NonNull;

@Unmodifiable
public final class StorageAbbreviationList
implements List<StorageAbbreviation> {
    private final UnmodifiableList<StorageAbbreviation> abbreviations;

    StorageAbbreviationList(List<StorageAbbreviation> abbreviations) {
        this.abbreviations = UnmodifiableList.of(abbreviations);
    }

    public static StorageAbbreviationList of(StorageAbbreviation ... abbreviations) {
        return StorageAbbreviationList.of(Arrays.asList(abbreviations));
    }

    public static StorageAbbreviationList of(Collection<StorageAbbreviation> abbreviations) {
        return new StorageAbbreviationList(new ArrayList<StorageAbbreviation>(abbreviations));
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.abbreviations.size() * 4];
        int offset = 0;
        for (StorageAbbreviation abbreviation : this.abbreviations) {
            offset += abbreviation.writeTo(result, offset);
        }
        return result;
    }

    public List<byte[]> toByteArrays() {
        ArrayList<byte[]> result = new ArrayList<byte[]>(this.abbreviations.size());
        for (StorageAbbreviation abbreviation : this.abbreviations) {
            result.add(abbreviation.toByteArray());
        }
        return result;
    }

    public static StorageAbbreviationList of(byte[] value) {
        return StorageAbbreviationList.readFrom(value, 0);
    }

    public static StorageAbbreviationList readFrom(byte[] value, int offset) {
        return StorageAbbreviationList.readFrom(value, offset, value.length - offset);
    }

    public static StorageAbbreviationList readFrom(byte[] value, int offset, int length) {
        if (value.length - offset < length) {
            throw new IllegalArgumentException("Provided value of length %d does not have %d bytes to read starting at offset %d".formatted(value.length, length, offset));
        }
        if (length % 4 != 0) {
            throw new IllegalArgumentException("The length of %d is not a multiple of %d".formatted(value.length, 4));
        }
        int count = length / 4;
        ArrayList<StorageAbbreviation> abbreviations = new ArrayList<StorageAbbreviation>(count);
        for (int i = 0; i < count; ++i) {
            abbreviations.add(StorageAbbreviation.readFrom(value, offset + i * 4));
        }
        return new StorageAbbreviationList(abbreviations);
    }

    public static ISerializer<StorageAbbreviationList, byte[]> serializer() {
        return ISerializer.of(StorageAbbreviationList::toByteArray, StorageAbbreviationList::of);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StorageAbbreviationList) {
            StorageAbbreviationList that = (StorageAbbreviationList)o;
            return this.abbreviations.equals(that.abbreviations);
        }
        return this.abbreviations.equals(o);
    }

    @Override
    public int hashCode() {
        return this.abbreviations.hashCode();
    }

    public String toString() {
        return this.abbreviations.toString();
    }

    @Override
    public StorageAbbreviationList reversed() {
        return new StorageAbbreviationList((List<StorageAbbreviation>)this.abbreviations.reversed());
    }

    public @NonNull StorageAbbreviationList subList(int fromIndex, int toIndex) {
        return new StorageAbbreviationList((List<StorageAbbreviation>)this.abbreviations.subList(fromIndex, toIndex));
    }

    @Override
    public @NonNull UnmodifiableListIterator<StorageAbbreviation> listIterator() {
        return this.abbreviations.listIterator();
    }

    @Override
    public @NonNull UnmodifiableListIterator<StorageAbbreviation> listIterator(int index) {
        return this.abbreviations.listIterator(index);
    }

    @Override
    @Deprecated
    public boolean add(StorageAbbreviation storageAbbreviation) {
        return this.abbreviations.add((Object)storageAbbreviation);
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        return this.abbreviations.remove(o);
    }

    @Override
    @Deprecated
    public boolean addAll(@NonNull Collection<? extends StorageAbbreviation> c) {
        return this.abbreviations.addAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(int index, @NonNull Collection<? extends StorageAbbreviation> c) {
        return this.abbreviations.addAll(index, c);
    }

    @Override
    @Deprecated
    public boolean removeAll(@NonNull Collection<?> c) {
        return this.abbreviations.removeAll(c);
    }

    @Override
    @Deprecated
    public boolean retainAll(@NonNull Collection<?> c) {
        return this.abbreviations.retainAll(c);
    }

    @Override
    @Deprecated
    public void replaceAll(@NonNull UnaryOperator<StorageAbbreviation> operator) {
        this.abbreviations.replaceAll(operator);
    }

    @Override
    @Deprecated
    public void sort(Comparator<? super StorageAbbreviation> c) {
        this.abbreviations.sort(c);
    }

    @Override
    @Deprecated
    public void clear() {
        this.abbreviations.clear();
    }

    @Override
    @Deprecated
    public StorageAbbreviation set(int index, StorageAbbreviation element) {
        return (StorageAbbreviation)this.abbreviations.set(index, (Object)element);
    }

    @Override
    @Deprecated
    public void add(int index, StorageAbbreviation element) {
        this.abbreviations.add(index, (Object)element);
    }

    @Override
    @Deprecated
    public StorageAbbreviation remove(int index) {
        return (StorageAbbreviation)this.abbreviations.remove(index);
    }

    @Override
    @Deprecated
    public void addFirst(StorageAbbreviation storageAbbreviation) {
        this.abbreviations.addFirst((Object)storageAbbreviation);
    }

    @Override
    @Deprecated
    public void addLast(StorageAbbreviation storageAbbreviation) {
        this.abbreviations.addLast((Object)storageAbbreviation);
    }

    @Override
    @Deprecated
    public StorageAbbreviation removeFirst() {
        return (StorageAbbreviation)this.abbreviations.removeFirst();
    }

    @Override
    @Deprecated
    public StorageAbbreviation removeLast() {
        return (StorageAbbreviation)this.abbreviations.removeLast();
    }

    @Override
    @Deprecated
    public boolean removeIf(@NonNull Predicate<? super StorageAbbreviation> filter) {
        return this.abbreviations.removeIf(filter);
    }

    @Override
    public int size() {
        return this.abbreviations.size();
    }

    @Override
    public boolean isEmpty() {
        return this.abbreviations.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.abbreviations.contains(o);
    }

    @Override
    public @NonNull UnmodifiableIterator<StorageAbbreviation> iterator() {
        return this.abbreviations.iterator();
    }

    @Override
    public @NonNull Object @NonNull [] toArray() {
        return this.abbreviations.toArray();
    }

    @Override
    public <T> @NonNull T @NonNull [] toArray(@NonNull T @NonNull [] a) {
        return this.abbreviations.toArray((Object[])a);
    }

    @Override
    public <T> T[] toArray(@NonNull IntFunction<T[]> generator) {
        return this.abbreviations.toArray(generator);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.abbreviations.containsAll(c);
    }

    @Override
    public StorageAbbreviation get(int index) {
        return (StorageAbbreviation)this.abbreviations.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.abbreviations.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.abbreviations.lastIndexOf(o);
    }

    @Override
    public @NonNull Spliterator<StorageAbbreviation> spliterator() {
        return this.abbreviations.spliterator();
    }

    @Override
    public StorageAbbreviation getFirst() {
        return (StorageAbbreviation)this.abbreviations.getFirst();
    }

    @Override
    public StorageAbbreviation getLast() {
        return (StorageAbbreviation)this.abbreviations.getLast();
    }

    @Override
    public @NonNull Stream<StorageAbbreviation> stream() {
        return this.abbreviations.stream();
    }

    @Override
    public @NonNull Stream<StorageAbbreviation> parallelStream() {
        return this.abbreviations.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super StorageAbbreviation> action) {
        this.abbreviations.forEach(action);
    }
}

