/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class KeyValueInstanceComparisonValueBase<V>
implements IInstanceComparisonValue {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final @NonNull String key;
    protected final @NonNull V value;
    protected final @Nullable IDetailedInstanceComparisonContribution detail;
    private final String acceptedDeviationKeyOverride;
    protected final Predicate<Pair<@Nullable V, @Nullable V>> onlyImprovementDecider;

    protected KeyValueInstanceComparisonValueBase(@NonNull String key, @NonNull V value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable V, @Nullable V>> onlyImprovementDecider, @Nullable String acceptedDeviationKeyOverride) {
        CCSMAssert.isNotNull((Object)key, () -> String.format("Expected \"%s\" to be not null", "key"));
        CCSMAssert.isNotNull(value, () -> String.format("Expected \"%s\" to be not null", "value"));
        CCSMAssert.isNotNull(onlyImprovementDecider, () -> String.format("Expected \"%s\" to be not null", "onlyImprovementsDecider"));
        this.key = key;
        this.value = value;
        this.detail = detail;
        this.onlyImprovementDecider = onlyImprovementDecider;
        this.acceptedDeviationKeyOverride = acceptedDeviationKeyOverride;
    }

    @Override
    public Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(@Nullable IInstanceComparisonValue other, boolean selfIsLocal, InstanceComparisonContributionBase.ComparisonContext context) {
        IInstanceComparisonValue remote;
        IInstanceComparisonValue local;
        if (other != null && !other.getClass().isAssignableFrom(this.getClass())) {
            LOGGER.warn("Received unsupported other instance ({}: {}) for key {}, that cannot be compared with this instance.", other.getClass(), (Object)other, (Object)this.key);
            return Optional.empty();
        }
        if (selfIsLocal) {
            local = this;
            remote = other;
        } else {
            local = other;
            remote = this;
        }
        return this.computeDifference(context, (KeyValueInstanceComparisonValueBase<V>)local, (KeyValueInstanceComparisonValueBase)remote);
    }

    protected abstract Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(InstanceComparisonContributionBase.ComparisonContext var1, @Nullable KeyValueInstanceComparisonValueBase<V> var2, @Nullable KeyValueInstanceComparisonValueBase<V> var3);

    @Override
    public @Nullable IDetailedInstanceComparisonContribution getDetails() {
        return this.detail;
    }

    @Override
    public String getValueHumanReadable() {
        return String.valueOf(this.getValue());
    }

    @VisibleForTesting
    public @NonNull V getValue() {
        return this.value;
    }

    protected String getAcceptedDeviationKey() {
        return this.acceptedDeviationKeyOverride != null ? this.acceptedDeviationKeyOverride : this.key;
    }

    public static <T> Predicate<Pair<T, T>> noImprovement() {
        return ignored -> false;
    }
}

