/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.analysis.redundantliterals;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.audit.analysis.redundantliterals.RedundantLiteralIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;

public class RedundantLiteralIndexUpdater
extends ChangeProcessorAnalysisStep {
    private static final String[] EXCLUDE_PATTERNS = new String[]{"\"all\"", "\"allDeprecation\"", "\"allJavadoc\"", "\"assertIdentifier\"", "\"boxing\"", "\"cast\"", "\"charConcat\"", "\"conditionAssign\"", "\"constructorName\"", "\"dep\"", "\"deprecation\"", "\"discouraged\"", "\"divzero\"", "\"empty\"", "\"emptyBlock\"", "\"enumSwitch\"", "\"fallthrough\"", "\"fieldHiding\"", "\"finalBound\"", "\"finally\"", "\"forbidden\"", "\"hiding\"", "\"incomplete\"", "\"indirectStatic\"", "\"intfAnnotation\"", "\"intfNonInherited\"", "\"javadoc\"", "\"localHiding\"", "\"maskedCatchBlocks\"", "\"nls\"", "\"noEffectAssign\"", "\"none\"", "\"null\"", "\"nullDereference\"", "\"over\"", "\"overrides\"", "\"paramAssign\"", "\"path\"", "\"pkgDefaultMethod\"", "\"raw\"", "\"rawtypes\"", "\"restriction\"", "\"semicolon\"", "\"serial\"", "\"specialParamHiding\"", "\"static\"", "\"staticReceiver\"", "\"super\"", "\"suppress\"", "\"synthetic\"", "\"syntheticAccess\"", "\"tasks\"", "\"typeHiding\"", "\"unchecked\"", "\"unnecessaryElse\"", "\"unqualified\"", "\"unused\"", "\"unusedArgument\"", "\"unusedImport\"", "\"unusedLabel\"", "\"unusedLocal\"", "\"unusedPrivate\"", "\"unusedThrown\"", "\"uselessTypeCheck\"", "\"varargsCast\"", "\"warningToken\"", "[\"']?\\d{1,2}[\"']?", "0.*", "\"\\s*\""};
    private static final PatternList COMPILED_EXCLUDE_PATTERNS = new PatternList();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RedundantLiteralIndex redundantLiteralIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="content")
    private TokenElementIndex previousContentIndex;

    public void execute() throws StorageException {
        this.processFiles(this.contentIndex.getTokenElements(this.contentDelta.getAddedOrChangedKeysAsStrings(), true), RedundantLiteralIndexUpdater::overwriteFirstWithSecond);
        this.processFiles(this.previousContentIndex.getTokenElements(this.contentDelta.getDeletedKeysAsStrings(), true), CounterSet::removeSecondFromFirst);
    }

    private static CounterSet<String> overwriteFirstWithSecond(CounterSet<String> first, CounterSet<String> second) {
        CounterSet merged = new CounterSet();
        merged.add(second);
        first.removeAll((Collection)second.getKeys());
        merged.add(first);
        return merged;
    }

    private void processFiles(List<TokenElementInfo> tokenElementInfos, BinaryOperator<CounterSet<String>> mergeFunction) throws StorageException {
        PairList literals = new PairList();
        for (TokenElementInfo tokenElementInfo : tokenElementInfos) {
            literals.addAll(new PairList(RedundantLiteralIndexUpdater.extractLiterals(tokenElementInfo)));
        }
        this.redundantLiteralIndex.addRedundantLiterals((PairList<String, CounterSet<String>>)new PairList(literals), mergeFunction);
    }

    private static Map<String, CounterSet<String>> extractLiterals(TokenElementInfo tokenElementInfo) {
        Map<String, Long> counts = tokenElementInfo.getTokens().stream().filter(RedundantLiteralIndexUpdater::isIncluded).collect(Collectors.groupingBy(IToken::getText, Collectors.counting()));
        HashMap<String, CounterSet<String>> literals = new HashMap<String, CounterSet<String>>();
        for (Map.Entry<String, Long> count : counts.entrySet()) {
            literals.put(count.getKey(), (CounterSet<String>)new CounterSet((Object)tokenElementInfo.getUniformPath(), Math.toIntExact(count.getValue())));
        }
        return literals;
    }

    private static boolean isIncluded(IToken token) {
        return token.getType().getTokenClass() == ETokenType.ETokenClass.LITERAL && !RedundantLiteralIndexUpdater.isExcluded(token);
    }

    private static boolean isExcluded(IToken token) {
        if (token.getType() == ETokenType.NULL_LITERAL) {
            return true;
        }
        if (token.getType() == ETokenType.BOOLEAN_LITERAL) {
            return true;
        }
        if (token.getType() == ETokenType.CLASS_LITERAL) {
            return true;
        }
        return COMPILED_EXCLUDE_PATTERNS.matchesAny(token.getText());
    }

    static {
        for (String regex : EXCLUDE_PATTERNS) {
            COMPILED_EXCLUDE_PATTERNS.add((Object)Pattern.compile(regex));
        }
    }
}

