/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.division_by_zero;

import com.teamscale.index.dataflow.ArithmeticExpressionTokenUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AdvancedIntVariableWriteHeuristic {
    private static final Predicate<String> IS_CHAR = Pattern.compile("-?'.'").asMatchPredicate();
    private static final Predicate<String> IS_HEX = Pattern.compile("-?0x.[\\da-fA-F]+[uU]?").asMatchPredicate();
    private static final Predicate<String> IS_OCTAL = Pattern.compile("-?0[0-7]*[uU]?").asMatchPredicate();
    private static final Predicate<String> IS_BINARY = Pattern.compile("-?(0b|0B)[0-1]+[uU]?").asMatchPredicate();
    private static final Predicate<String> IS_INTEGER = Pattern.compile("-?[1-9]+\\d*[uU]?").asMatchPredicate();
    public static final Set<ETokenType> ASSIGNMENT_OPERATORS = EnumSet.of(ETokenType.MINUSEQ, new ETokenType[]{ETokenType.PLUSEQ, ETokenType.DIVEQ, ETokenType.MULTEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ});
    private static final ETokenType[] BOOLEAN_COMPARISONS = new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.EQEQEQ, ETokenType.NOTEQEQ, ETokenType.GT, ETokenType.LT, ETokenType.GTEQ, ETokenType.LTEQ};
    private static final Set<ETokenType> SUPPORTED_ARITHMETIC_OPERATORS = EnumSet.of(ETokenType.PLUS, new ETokenType[]{ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV, ETokenType.MOD, ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT, ETokenType.AND, ETokenType.OR, ETokenType.XOR});

    public static boolean isArithmeticExpression(List<IToken> tokens) {
        return AdvancedIntVariableWriteHeuristic.isPureIntegerExpression(tokens) && AdvancedIntVariableWriteHeuristic.containsArithmeticOperator(tokens) && !AdvancedIntVariableWriteHeuristic.containsMethodCalls(tokens) && !AdvancedIntVariableWriteHeuristic.isIncrementOrDecrement(tokens) && !AdvancedIntVariableWriteHeuristic.containsArrayAssignment(tokens) && !AdvancedIntVariableWriteHeuristic.isBooleanExpression(tokens) && !AdvancedIntVariableWriteHeuristic.isSwitchStatement(tokens);
    }

    private static boolean containsArithmeticOperator(List<IToken> tokens) {
        List filteredTokens = tokens.stream().filter(token -> token.getType() != ETokenType.EQ).collect(Collectors.toList());
        return TokenStreamUtils.containsAny(filteredTokens, (Set)ETokenType.getTokenTypesByClass((ETokenType.ETokenClass)ETokenType.ETokenClass.OPERATOR)) && !AdvancedIntVariableWriteHeuristic.containsNonArithmeticOperators(tokens);
    }

    private static boolean containsNonArithmeticOperators(List<IToken> tokens) {
        return tokens.stream().map(IToken::getType).filter(ETokenType::isOperator).allMatch(SUPPORTED_ARITHMETIC_OPERATORS::contains);
    }

    public static boolean containsMethodCalls(List<IToken> tokens) {
        return TokenStreamUtils.containsSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}) || TokenStreamUtils.containsSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.SIZEOF, ETokenType.LPAREN});
    }

    private static boolean containsArrayAssignment(List<IToken> tokens) {
        return TokenStreamUtils.containsSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.LBRACE}) || TokenStreamUtils.containsSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.RBRACK, ETokenType.EQ});
    }

    public static boolean containsPointerOrAddressOperator(List<IToken> tokens) {
        return !ArithmeticExpressionTokenUtils.getUnaryOperatorLocations(tokens, ETokenType.MULT).isEmpty() || !ArithmeticExpressionTokenUtils.getUnaryOperatorLocations(tokens, ETokenType.AND).isEmpty();
    }

    private static boolean isBooleanExpression(List<IToken> tokens) {
        return TokenStreamUtils.containsAny(tokens, (ETokenType[])BOOLEAN_COMPARISONS);
    }

    private static boolean isIncrementOrDecrement(List<IToken> tokens) {
        return tokens.size() <= 3 && TokenStreamUtils.containsAny(tokens, EnumSet.of(ETokenType.PLUSPLUS, ETokenType.MINUSMINUS)) && TokenStreamUtils.contains(tokens, (ETokenType.ETokenClass)ETokenType.ETokenClass.IDENTIFIER);
    }

    public static boolean isPureIntegerExpression(List<IToken> tokens) {
        return AdvancedIntVariableWriteHeuristic.containsNoPointers(ArithmeticExpressionTokenUtils.filterTokens(tokens)) && AdvancedIntVariableWriteHeuristic.containsOnlyIntegerLiteral(tokens);
    }

    private static boolean isSwitchStatement(List<IToken> tokens) {
        return TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.SWITCH);
    }

    private static boolean containsNoPointers(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return true;
        }
        return AdvancedIntVariableWriteHeuristic.doesNotContainPointerOperator(tokens, ETokenType.MULT) && AdvancedIntVariableWriteHeuristic.doesNotContainPointerOperator(tokens, ETokenType.AND);
    }

    private static boolean doesNotContainPointerOperator(List<IToken> tokens, ETokenType operator) {
        List possiblePointers = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{operator, ETokenType.IDENTIFIER});
        possiblePointers.addAll(TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{operator, ETokenType.PLUSPLUS, ETokenType.IDENTIFIER}));
        possiblePointers.addAll(TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{operator, ETokenType.MINUSMINUS, ETokenType.IDENTIFIER}));
        boolean containsNoPointers = possiblePointers.stream().noneMatch(i -> i - 1 < 0 || ((IToken)tokens.get(i - 1)).getType().isOperator() || ((IToken)tokens.get(i - 1)).getType().isKeyword() || ((IToken)tokens.get(i - 1)).getType() == ETokenType.LPAREN);
        containsNoPointers &= !TokenStreamUtils.containsSequence(tokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.IDENTIFIER, operator, ETokenType.IDENTIFIER, ETokenType.EQ});
        containsNoPointers &= tokens.get(0).getType() != operator;
        return containsNoPointers &= !TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.POINTERTO);
    }

    private static boolean containsOnlyIntegerLiteral(List<IToken> tokens) {
        return !TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.NULLPTR) && tokens.stream().filter(token -> token.getType() != ETokenType.INTEGER_LITERAL && token.getType() != ETokenType.CHARACTER_LITERAL).noneMatch(token -> token.getType().isLiteral());
    }

    public static boolean canGetIntegerFromString(String text) {
        if (text.length() > 1 && (text.endsWith("u") || text.endsWith("U"))) {
            text = text.substring(0, text.length() - 1);
        }
        if (IS_BINARY.test(text)) {
            if (text.charAt(0) == '-') {
                return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("0b10000000000000000000000000000000", text.substring(1));
            }
            return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("0b1111111111111111111111111111111", text);
        }
        if (IS_OCTAL.test(text)) {
            if (text.charAt(0) == '-') {
                return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("020000000000", text.substring(1));
            }
            return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("017777777777", text);
        }
        if (IS_INTEGER.test(text)) {
            if (text.charAt(0) == '-') {
                return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("2147483648", text.substring(1));
            }
            return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("2147483647", text);
        }
        if (IS_HEX.test(text)) {
            if (text.charAt(0) == '-') {
                return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("0x80000000", text.substring(1));
            }
            return AdvancedIntVariableWriteHeuristic.isBiggerOrEqual("0x7fffffff", text);
        }
        return IS_CHAR.test(text);
    }

    private static boolean isBiggerOrEqual(String number1, String number2) {
        if (number1.length() != number2.length()) {
            return number1.length() > number2.length();
        }
        number2 = number2.toLowerCase(Locale.ROOT);
        for (int i = 0; i < number1.length(); ++i) {
            if (number1.charAt(i) > number2.charAt(i)) {
                return true;
            }
            if (number1.charAt(i) >= number2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int getIntegerFromString(String text) {
        if (text.charAt(text.length() - 1) == 'u' || text.charAt(text.length() - 1) == 'U') {
            text = text.substring(0, text.length() - 1);
        }
        String addition = "";
        if (text.charAt(0) == '-') {
            addition = "-";
            text = text.substring(1);
        }
        if (IS_CHAR.test(text)) {
            if (!addition.isEmpty()) {
                return -text.charAt(1);
            }
            return text.charAt(1);
        }
        if (IS_HEX.test(text)) {
            return Integer.parseInt(addition + text.substring(2), 16);
        }
        if (IS_OCTAL.test(text)) {
            return Integer.parseInt(addition + text, 8);
        }
        if (IS_BINARY.test(text)) {
            return Integer.parseInt(addition + text.substring(2), 2);
        }
        return Integer.parseInt(addition + text);
    }
}

