/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.BidirectionalListIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Index(name="method-calls", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class MethodCallIndex
extends IndexBase
implements IProjectIndex {
    private final BidirectionalListIndex<String, String> delegate;
    public static final String METHOD_CALL_INDEX_NAME = "method-calls";

    public MethodCallIndex(IStore store) {
        super(store);
        this.delegate = new BidirectionalListIndex((IStore)new DelegatingPartitionStore(store, "d"));
    }

    @VisibleForTesting
    public List<ArrayList<String>> getCallersOfMethods(List<String> methods) throws StorageException {
        ArrayList<ArrayList<String>> callers = new ArrayList<ArrayList<String>>(methods.size());
        for (ArrayList methodCallers : this.delegate.getKeysForValues(methods)) {
            if (methodCallers != null) {
                callers.add(methodCallers);
                continue;
            }
            callers.add(new ArrayList());
        }
        return callers;
    }

    public Set<String> getUnionOfCallersOfMethods(List<String> methods) throws StorageException {
        HashSet<String> callers = new HashSet<String>();
        for (ArrayList methodCallers : this.delegate.getKeysForValues(methods)) {
            if (methodCallers == null) continue;
            callers.addAll(methodCallers);
        }
        return callers;
    }

    public void updateMethodCalls(Map<String, ArrayList<String>> updatedValues, List<String> deletedMethodSignatures) throws StorageException {
        ArrayList<String> keysWithEmptyValues = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : updatedValues.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            keysWithEmptyValues.add(entry.getKey());
        }
        deletedMethodSignatures.addAll(keysWithEmptyValues);
        CollectionUtils.removeAll(updatedValues.keySet(), keysWithEmptyValues);
        this.delegate.updateValues(updatedValues, deletedMethodSignatures);
    }

    public Map<String, ArrayList<String>> getAllMethodCallReferences() throws StorageException {
        return this.delegate.getAllForwardEntries();
    }

    public Map<String, ArrayList<String>> getAllMethodCalledByReferences() throws StorageException {
        return this.delegate.getAllBackwardEntries();
    }

    @VisibleForTesting
    public @Nullable ArrayList<String> getMethodsCalledBy(String method) throws StorageException {
        return (ArrayList)this.delegate.getValuesForKeys(List.of(method)).get(0);
    }
}

