/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="methods", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={String.class})
public class MethodIndex
extends IndexBase
implements IProjectIndex {
    private static final char TYPE_METHOD_SEPARATOR = '.';
    public static final String INDEX_NAME = "methods";
    private static final String FILE_PREFIX = "file:";
    private static final String METHOD_PREFIX = "method:";

    public MethodIndex(IStore store) {
        super(store);
    }

    public void setValues(PairList<String, Collection<String>> uniformPathToMethod) throws StorageException {
        List uniformPaths = uniformPathToMethod.extractFirstList();
        this.removeInverseMappings(uniformPaths);
        PairList keysValues = new PairList();
        for (int i = 0; i < uniformPathToMethod.size(); ++i) {
            ArrayList<String> methodIdentifiers = new ArrayList<String>(((Collection)uniformPathToMethod.getSecond(i)).size());
            for (String classAndMethodName : (Collection)uniformPathToMethod.getSecond(i)) {
                methodIdentifiers.add(TaintAnalysisUtils.buildMethodIdentifier((String)uniformPathToMethod.getFirst(i), classAndMethodName));
            }
            keysValues.add((Object)MethodIndex.makeFileKey((String)uniformPathToMethod.getFirst(i)), (Object)StorageUtils.serialize(new ArrayList(methodIdentifiers)));
            for (String method : methodIdentifiers) {
                keysValues.add((Object)MethodIndex.makeMethodKey(method), (Object)StringUtils.stringToBytes((String)((String)uniformPathToMethod.getFirst(i))));
            }
        }
        this.store.putWithStrings(keysValues);
    }

    private void removeInverseMappings(Collection<String> uniformPaths) throws StorageException {
        HashSet<String> oldMethods = new HashSet<String>();
        for (byte[] value : this.store.getWithStrings(MethodIndex.makeFileKeys(uniformPaths))) {
            if (value == null) continue;
            oldMethods.addAll(StorageUtils.deserializeStringList((byte[])value));
        }
        this.store.removeWithStrings(MethodIndex.makeMethodKeys(oldMethods));
    }

    public void removeFiles(Collection<String> uniformPaths) throws StorageException {
        this.removeInverseMappings(uniformPaths);
        this.store.removeWithStrings(MethodIndex.makeFileKeys(uniformPaths));
    }

    public List<String> getMethodsForFile(String uniformPath) throws StorageException {
        return StorageUtils.deserializeStringList((byte[])this.store.getWithString(MethodIndex.makeFileKey(uniformPath)));
    }

    public List<String> getFilesForMethods(List<String> methods) throws StorageException {
        List values = this.store.getWithStrings(MethodIndex.makeMethodKeys(methods));
        ArrayList<String> result = new ArrayList<String>();
        for (byte[] value : values) {
            result.add(StringUtils.bytesToString((byte[])value));
        }
        return result;
    }

    private static List<String> makeFileKeys(Collection<String> uniformPaths) {
        return StringUtils.prefixAll(uniformPaths, (String)FILE_PREFIX);
    }

    private static String makeFileKey(String uniformPath) {
        return FILE_PREFIX + uniformPath;
    }

    private static List<String> makeMethodKeys(Collection<String> methods) {
        return StringUtils.prefixAll(methods, (String)METHOD_PREFIX);
    }

    private static String makeMethodKey(String method) {
        return METHOD_PREFIX + method;
    }

    public static List<String> getMethodKeysFromDelta(List<String> deltaKeys) {
        ArrayList<String> result = new ArrayList<String>();
        for (String deltaKey : deltaKeys) {
            if (!deltaKey.startsWith(METHOD_PREFIX)) continue;
            result.add(StringUtils.stripPrefix((String)deltaKey, (String)METHOD_PREFIX));
        }
        return result;
    }

    public List<String> getAllMethods() throws StorageException {
        ArrayList<String> result = new ArrayList<String>();
        this.store.scan(METHOD_PREFIX, (key, value) -> {
            List list = result;
            synchronized (list) {
                result.add(StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)METHOD_PREFIX));
            }
        });
        return result;
    }

    public static String getMethodName(String methodSignature) {
        return StringUtils.getLastPart((String)methodSignature, (char)'.');
    }
}

