/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public abstract class DependencyIndexBase
extends ProjectIndexWithDynamicNameBase {
    private final ValueIndex<ArrayList<String>> delegate;

    protected DependencyIndexBase(IStore store) {
        super(store);
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public static void updateInverseDependencyIndex(DependencyIndexBase inverseIndex, PairList<String, ArrayList<String>> updatedValues, @Nullable List<String> allValidInverseIndexKeys) throws StorageException {
        PairList values = new PairList();
        Map<String, ArrayList<String>> inverseDependencies = DependencyIndexBase.invertDependencies(updatedValues.extractFirstList(), updatedValues.extractSecondList(), allValidInverseIndexKeys);
        ArrayList<String> keys = new ArrayList<String>(inverseDependencies.keySet());
        List<ArrayList<String>> oldValues = inverseIndex.getDependencies(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            ArrayList<String> dependencyDelta = inverseDependencies.get(key);
            if (oldValues.get(i) != null) {
                HashSet<String> newValues = new HashSet<String>((Collection)oldValues.get(i));
                if (!newValues.addAll(dependencyDelta)) continue;
                values.add((Object)key, new ArrayList(CollectionUtils.sort(newValues)));
                continue;
            }
            Collections.sort(dependencyDelta);
            values.add((Object)key, dependencyDelta);
        }
        inverseIndex.setDependencies((PairList<String, ArrayList<String>>)values);
    }

    private static Map<String, ArrayList<String>> invertDependencies(List<String> dependencySources, List<ArrayList<String>> dependencies, @Nullable List<String> allValidInverseIndexKeys) {
        HashSet<String> allValidInverseIndexKeysSet = null;
        if (allValidInverseIndexKeys != null) {
            allValidInverseIndexKeysSet = new HashSet<String>(allValidInverseIndexKeys);
        }
        ArrayList<ArrayList<String>> prunedDependencies = new ArrayList<ArrayList<String>>(dependencySources.size());
        for (ArrayList<String> dependees : dependencies) {
            if (dependees != null) {
                prunedDependencies.add(DependencyIndexBase.pruneThirdPartyDependencies(dependees, allValidInverseIndexKeysSet));
                continue;
            }
            prunedDependencies.add(null);
        }
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        HashSet<String> dependencySourceDelta = new HashSet<String>(dependencySources);
        for (ArrayList arrayList : prunedDependencies) {
            if (arrayList == null) continue;
            dependencySourceDelta.addAll(arrayList);
        }
        for (String string : dependencySourceDelta) {
            result.put(string, new ArrayList());
        }
        for (int i = 0; i < prunedDependencies.size(); ++i) {
            String string = dependencySources.get(i);
            ArrayList dependees = (ArrayList)prunedDependencies.get(i);
            if (dependees == null) continue;
            for (String dependee : dependees) {
                ((ArrayList)result.get(dependee)).add(string);
            }
        }
        return result;
    }

    private static ArrayList<String> pruneThirdPartyDependencies(ArrayList<String> dependees, @Nullable Set<String> allValidInverseIndexKeys) {
        if (allValidInverseIndexKeys == null) {
            return dependees;
        }
        return new ArrayList<String>(CollectionUtils.intersectionSet(dependees, (Collection[])new Collection[]{allValidInverseIndexKeys}));
    }

    public static void removeInverseDependencies(DependencyIndexBase dependencyIndex, DependencyIndexBase inverseDependencyIndex, List<String> keys) throws StorageException {
        PairList values = new PairList();
        Map<String, ArrayList<String>> toRemove = DependencyIndexBase.invertDependencies(keys, dependencyIndex.getDependencies(keys), dependencyIndex.getAllUniformPaths());
        ArrayList<String> toRemoveKeys = new ArrayList<String>(toRemove.keySet());
        List<ArrayList<String>> inverseValues = inverseDependencyIndex.getDependencies(toRemoveKeys);
        for (int i = 0; i < toRemoveKeys.size(); ++i) {
            if (inverseValues.get(i) == null) continue;
            String key = (String)toRemoveKeys.get(i);
            HashSet oldValues = new HashSet(inverseValues.get(i));
            CollectionUtils.removeAll(oldValues, (List)toRemove.get(key));
            if (oldValues.size() == inverseValues.get(i).size()) continue;
            values.add((Object)key, new ArrayList(CollectionUtils.sort(oldValues)));
        }
        inverseDependencyIndex.setDependencies((PairList<String, ArrayList<String>>)values);
    }

    public void removeDependencies(List<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void setDependencies(PairList<String, ArrayList<String>> uniformPathAndDependencies) throws StorageException {
        this.delegate.setValues(uniformPathAndDependencies);
    }

    public void setDependencies(String uniformPath, ArrayList<String> dependencies) throws StorageException {
        this.delegate.setValue(uniformPath, dependencies);
    }

    public PairList<String, ArrayList<String>> getAllDependencies() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public List<@Nullable ArrayList<String>> getDependencies(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public List<String> getAllUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public List<String> getDependencies(String uniformPath) throws StorageException {
        return (List)this.delegate.getValue(uniformPath);
    }
}

