/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolver;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.index.configuration.CoreConfiguration;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.ExternalProcessStepInfo;
import com.teamscale.index.external.ExternalUploadReportArchiveOption;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.FindingLocationAdjuster;
import com.teamscale.index.external.input.ImportInfoPath;
import com.teamscale.index.external.input.PathCorrector;
import com.teamscale.index.external.input.ReportIntegrator;
import com.teamscale.index.external.input.SessionBasedExternalAnalysisResultsTriggerBase;
import com.teamscale.index.external.input.TestWiseToLineCoverageIntegrator;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoExecutionUnit;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMetricSchemaChange;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMultiFileRangeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProcessStepInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoTestExecution;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.info.ExternalAnalysisReportParsingResult;
import com.teamscale.index.external.input.info.IContentAdjustable;
import com.teamscale.index.external.input.info.ILineAdjustable;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.tools.ExternalUploadIndexModifier;
import com.teamscale.index.external.update.ExternalAnalysisResultsChangeRetriever;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IStoreDecorator;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.sourcecode.coverage.TestArtifactUtils;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class IntegrateImportedAnalysisResultsTrigger
extends SessionBasedExternalAnalysisResultsTriggerBase {
    private static final int UPLOAD_TO_OTHER_UPLOAD_OFFSET = 1;
    private static final int MAX_BATCH_SIZE = 200;
    private static final int REPORT_BLOW_UP = 100;
    private ExternalAnalysisImportSessionIndex sessionIndex;
    private TokenElementIndexCache contentIndexCache;
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private MetricDirectoryIndex metricsDirectoryIndex;
    private PathCorrector pathCorrector;
    private ExternalAnalysisResultIndex resultIndex;
    private RecordingStore resultRecorder;
    private final List<String> messages = new ArrayList<String>();
    private final Set<EExternalAnalysisResultType> types = EnumSet.noneOf(EExternalAnalysisResultType.class);
    private ReportIntegrator reportIntegrator;
    private TestWiseToLineCoverageIntegrator testWiseCoverageIntegrator;
    private static final Logger LOGGER = LogManager.getLogger();
    private FindingLocationAdjuster findingLocationAdjuster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws StorageException {
        ProjectStorageSystem projectStorageSystem = this.indexLayer.openNonCommitResolvingProjectStorageSystem(this.jobDescriptor.getInternalProjectId());
        ExternalAnalysisStatusIndex statusIndex = (ExternalAnalysisStatusIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisReportArchiveIndex reportArchiveIndex = (ExternalAnalysisReportArchiveIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisReportArchiveIndex.class, null);
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        long maxReportArchiveIndexSize = ExternalUploadReportArchiveOption.getMaxReportArchiveIndexSize(serverOptionIndex);
        this.sessionIndex = (ExternalAnalysisImportSessionIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
        ExternalAnalysisSessionInfo session = IntegrateImportedAnalysisResultsTrigger.getSession(this.sessionIndex, this.jobDescriptor.getSchedulingCommit());
        CommitDescriptor plainWriteCommit = this.createUploadCommit(session, projectStorageSystem);
        LOGGER.info("Using write commit: {}", (Object)plainWriteCommit);
        try {
            boolean sessionHasNoParsingErrors;
            IStorageSystem rawProjectStorageSystem = this.indexLayer.openRawProjectStorageSystem(this.jobDescriptor.getInternalProjectId());
            ExternalUploadIndexModifier modifier = new ExternalUploadIndexModifier(rawProjectStorageSystem, this.indexLayer.getStorageCacheProvider().getCacheProvider(this.jobDescriptor.getInternalProjectId().toString()), (IFactory<IStore, StorageException>)((IFactory)InMemoryStore::new), "external-analysis-results", ExternalAnalysisResultIndex.class);
            ExternalUploadIndexModifier.AdditionInfo additionInfo = modifier.prepareForAddition(plainWriteCommit);
            GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
            CommitResolvingStorageSystem commitResolvingProjectStorageSystem = new CommitResolvingStorageSystem((IStorageSystem)modifier.getModificationStorageSystem(), this.indexLayer.getStorageSystemCacheProvider(this.jobDescriptor.getInternalProjectId().toString()), new CommitResolver(), StorageCacheConfiguration.NO_CACHING);
            this.createIndexes((ProjectStorageSystem)commitResolvingProjectStorageSystem, globalStorageSystem, plainWriteCommit, additionInfo.getArtificialWriteCommit());
            this.resultIndex.removePartition(session.getPartition());
            try {
                sessionHasNoParsingErrors = this.processSession(session, (CommitDescriptor)additionInfo.getArtificialWriteCommit(), plainWriteCommit, reportArchiveIndex, maxReportArchiveIndexSize);
            }
            finally {
                this.sessionIndex.deleteSession(session.getSessionId());
            }
            modifier.completeAddition(additionInfo);
            if (!modifier.scheduleRollbackIfNeeded(this.jobDescriptor.getInternalProjectId(), this.indexLayer)) {
                this.scheduleExternalAnalysisResultsChangeRetriever();
            }
            this.storeProcessingStatus(sessionHasNoParsingErrors, session, plainWriteCommit, statusIndex, this.types);
        }
        catch (Throwable t) {
            this.messages.add("Fatal: " + t.getMessage());
            this.storeProcessingStatus(false, session, plainWriteCommit, statusIndex, this.types);
            throw t;
        }
    }

    private CommitDescriptor createUploadCommit(ExternalAnalysisSessionInfo session, ProjectStorageSystem projectStorageSystem) throws StorageException {
        CommitDescriptor result;
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        CommitDescriptor uploadCommit = this.jobDescriptor.getSchedulingCommit();
        long timeOffset = 0L;
        if (session.shouldMoveUploadToLastCommit()) {
            uploadCommit = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(uploadCommit, 0L).orElse(uploadCommit);
            timeOffset = 20L;
        }
        if (IntegrateImportedAnalysisResultsTrigger.hasUploadAtCommit(projectStorageSystem, uploadCommit)) {
            timeOffset = 1L;
        }
        do {
            result = new CommitDescriptor(uploadCommit.getBranchName(), uploadCommit.getTimestamp() + timeOffset);
            ++timeOffset;
        } while (IntegrateImportedAnalysisResultsTrigger.hasUploadAtCommit(projectStorageSystem, result));
        return result;
    }

    private static boolean hasUploadAtCommit(ProjectStorageSystem projectStorageSystem, CommitDescriptor uploadCommit) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)uploadCommit.getBranchName(), (long)uploadCommit.getTimestamp());
        ExternalAnalysisResultIndex externalAnalysisIndex = (ExternalAnalysisResultIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisResultIndex.class, historyAccess);
        ExternalAnalysisCommitInfo commitInfo = (ExternalAnalysisCommitInfo)((Object)externalAnalysisIndex.getCommitInfo());
        return commitInfo != null && uploadCommit.getTimestamp() == commitInfo.getTimestamp();
    }

    private boolean processSession(ExternalAnalysisSessionInfo session, CommitDescriptor artificialWriteCommit, CommitDescriptor plainWriteCommit, ExternalAnalysisReportArchiveIndex reportArchiveIndex, long maxReportArchiveIndexSize) throws StorageException {
        boolean sessionHasNoParsingErrors = true;
        Set<String> reportPaths = this.sessionIndex.getUniformPathsInSession(session);
        for (List pathChunk : Iterables.partition(reportPaths, (int)IntegrateImportedAnalysisResultsTrigger.getBatchSizeForSession(session))) {
            sessionHasNoParsingErrors &= this.importForPaths(session, pathChunk, plainWriteCommit, reportArchiveIndex, maxReportArchiveIndexSize);
        }
        Set<ImportInfoPath> paths = this.testWiseCoverageIntegrator.persistState(session);
        this.createAndStoreExternalAnalysisResultsForPaths(session, paths);
        this.resultIndex.setCommitInfo(this.createCommitInfo(session, artificialWriteCommit, reportPaths));
        return sessionHasNoParsingErrors;
    }

    private ExternalAnalysisCommitInfo createCommitInfo(ExternalAnalysisSessionInfo session, CommitDescriptor artificialWriteCommit, Collection<String> reportPaths) {
        KeyDelta keyDelta = "code-review-findings".equals(session.getPartition()) ? KeyDelta.fromStrings(reportPaths, Collections.emptyList()) : this.resultRecorder.obtainDelta();
        return new ExternalAnalysisCommitInfo(artificialWriteCommit, session, IntegrateImportedAnalysisResultsTrigger.stripPartitionPrefix(keyDelta, session.getPartition()), this.types);
    }

    private static int getBatchSizeForSession(ExternalAnalysisSessionInfo session) {
        long neededMemory = session.getMaxReportSize() / 0x100000L * 100L;
        if (neededMemory <= 0L) {
            return 200;
        }
        int batchSize = (int)(2048L / neededMemory);
        return Math.min(200, Math.max(batchSize, 1));
    }

    private void scheduleExternalAnalysisResultsChangeRetriever() throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.indexLayer, this.jobDescriptor.getInternalProjectId(), ExternalAnalysisResultsChangeRetriever.class);
    }

    public static KeyDelta stripPartitionPrefix(KeyDelta delta, String partition) {
        String prefix = ExternalAnalysisResultIndex.makePathKey(partition, "");
        return new KeyDelta(IntegrateImportedAnalysisResultsTrigger.stripPrefix(delta.getAddedOrChangedKeysAsStrings(), prefix), IntegrateImportedAnalysisResultsTrigger.stripPrefix(delta.getDeletedKeysAsStrings(), prefix));
    }

    private static Collection<StorageKey> stripPrefix(List<String> keys, String prefix) {
        return CollectionUtils.map(keys, key -> new StorageKey(StringUtils.stripPrefix((String)key, (String)prefix)));
    }

    private void createIndexes(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, CommitDescriptor plainWriteCommit, ParentedCommitDescriptor artificialWriteCommit) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)plainWriteCommit.getBranchName(), (long)plainWriteCommit.getTimestamp());
        TokenElementIndex contentIndex = (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", historyAccess);
        this.contentIndexCache = new TokenElementIndexCache(contentIndex, Collections.emptyList());
        this.tokenElementLineInfoIndex = (TokenElementLineInfoIndex)projectStorageSystem.openProjectIndex(TokenElementLineInfoIndex.class, historyAccess);
        SimulinkModelInfoIndex simulinkModelInfoIndex = (SimulinkModelInfoIndex)projectStorageSystem.openProjectIndex(SimulinkModelInfoIndex.class, historyAccess);
        this.findingLocationAdjuster = new FindingLocationAdjuster(simulinkModelInfoIndex);
        this.metricsDirectoryIndex = (MetricDirectoryIndex)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyAccess);
        IMatchingPathsLookup matchingPathsLookup = ((PathLookupIndex)projectStorageSystem.openProjectIndex(PathLookupIndex.class, historyAccess)).createLoggingPreloadedLookup();
        this.pathCorrector = new PathCorrector(matchingPathsLookup, contentIndex.getAllUniformPaths());
        this.reportIntegrator = this.createReportIntegrator(projectStorageSystem, globalStorageSystem, historyAccess, matchingPathsLookup, CoreConfiguration.hasDisabledImplausibleLinesCheck(projectStorageSystem));
        this.testWiseCoverageIntegrator = new TestWiseToLineCoverageIntegrator(this.sessionIndex, this.pathCorrector);
        this.createResultIndex(projectStorageSystem, artificialWriteCommit);
    }

    private ReportIntegrator createReportIntegrator(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, HistoryAccessOption historyAccess, IMatchingPathsLookup matchingPathsLookup, boolean disablePlausibilityCheckForPathMapping) throws StorageException {
        BasicTokenElementIndex basicTokenElementIndex = (BasicTokenElementIndex)projectStorageSystem.openProjectIndex(BasicTokenElementIndex.class, historyAccess);
        BinaryElementIndex binaryElementIndex = (BinaryElementIndex)projectStorageSystem.openProjectIndex(BinaryElementIndex.class, historyAccess);
        TypeIndex typeIndex = (TypeIndex)projectStorageSystem.openProjectIndex(TypeIndex.class, historyAccess);
        ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex = (ExternalFindingsGroupDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        return new ReportIntegrator(this.sessionIndex, matchingPathsLookup, typeIndex, externalFindingsGroupDescriptionIndex, basicTokenElementIndex, this.contentIndexCache, this.tokenElementLineInfoIndex, binaryElementIndex, this.pathCorrector, (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null), disablePlausibilityCheckForPathMapping, (x$0, x$1, x$2) -> this.executeInParallelBatches(x$0, x$1, x$2));
    }

    private void createResultIndex(ProjectStorageSystem projectStorageSystem, ParentedCommitDescriptor artificialWriteCommit) throws StorageException {
        IStoreDecorator decorator = store -> {
            this.resultRecorder = new RecordingStore(store);
            return this.resultRecorder;
        };
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)artificialWriteCommit.getBranchName(), (long)artificialWriteCommit.getTimestamp());
        CommitDescriptor parentCommit = artificialWriteCommit.getFirstParentCommit();
        if (parentCommit != null) {
            historyAccess.setExplicitParentCommit(parentCommit.getBranchName(), parentCommit.getTimestamp());
        }
        this.resultIndex = (ExternalAnalysisResultIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisResultIndex.class, historyAccess, decorator);
    }

    @Override
    public boolean canCauseSchedulingConflicts() {
        return false;
    }

    public Set<String> getCrossCommitBlockingWriteStores() {
        return CollectionUtils.asHashSet((Object[])new String[]{"external-analysis-results"});
    }

    private boolean importForPaths(ExternalAnalysisSessionInfo session, List<String> uniformPaths, CommitDescriptor writeCommit, ExternalAnalysisReportArchiveIndex reportArchiveIndex, long maxReportArchiveIndexSize) throws StorageException {
        Set<ImportInfoPath> paths = this.pathCorrector.correctPaths(uniformPaths);
        ExternalAnalysisReportParsingResult reportsParsingResult = this.reportIntegrator.processReports(paths, session, writeCommit, reportArchiveIndex, maxReportArchiveIndexSize);
        this.testWiseCoverageIntegrator.convertTestWiseCoverageToLineCoverage(reportsParsingResult.importInfos());
        this.createAndStoreExternalAnalysisResultsForPaths(session, paths);
        return reportsParsingResult.isSuccessful();
    }

    private void createAndStoreExternalAnalysisResultsForPaths(ExternalAnalysisSessionInfo session, Set<ImportInfoPath> paths) throws StorageException {
        Map<String, ExternalAnalysisImportInfos> importInfosByOriginalPath = this.sessionIndex.getImportInfos(session, CollectionUtils.map(paths, ImportInfoPath::getOriginalPath));
        List contentAdjustablePaths = CollectionUtils.filterAndMap(paths, path -> ((ExternalAnalysisImportInfos)importInfosByOriginalPath.get(path.getOriginalPath())).containsInstancesOf(IContentAdjustable.class), ImportInfoPath::getCorrectedPath);
        List lineAdjustablePaths = CollectionUtils.filterAndMap(paths, path -> ((ExternalAnalysisImportInfos)importInfosByOriginalPath.get(path.getOriginalPath())).containsInstancesOf(ILineAdjustable.class), ImportInfoPath::getCorrectedPath);
        Map<String, TokenElementInfo> contentElements = this.contentIndexCache.getValuesByKeys(contentAdjustablePaths);
        Map<String, TokenElementLineInfo> lineInfoElements = this.tokenElementLineInfoIndex.getLineInfosByPaths(lineAdjustablePaths);
        PairList resultValues = new PairList();
        for (ImportInfoPath path2 : paths) {
            ExternalAnalysisImportInfos importInfos = importInfosByOriginalPath.get(path2.getOriginalPath());
            CCSMAssert.isNotNull((Object)importInfos, (String)("No import info found for " + path2.getCorrectedPath()));
            ExternalAnalysisResults results = this.createExternalAnalysisResult(path2.getCorrectedPath(), importInfos, contentElements.get(path2.getCorrectedPath()), lineInfoElements.get(path2.getCorrectedPath()));
            if (results.isEmpty()) continue;
            resultValues.add((Object)path2.getCorrectedPath(), (Object)results);
        }
        this.resultIndex.setAnalysisResults(session.getPartition(), (PairList<String, ExternalAnalysisResults>)resultValues);
    }

    private ExternalAnalysisResults createExternalAnalysisResult(String uniformPath, ExternalAnalysisImportInfos importInfos, TokenElementInfo contentElement, TokenElementLineInfo lineInfo) throws StorageException {
        ExternalAnalysisResults results = new ExternalAnalysisResults();
        for (ExternalAnalysisImportInfo<?> importInfo : importInfos) {
            this.createExternalAnalysisResult(uniformPath, importInfo, contentElement, lineInfo).ifPresent(result -> {
                this.types.add(EExternalAnalysisResultType.forResultClass(result.getClass()));
                results.addResult((ExternalAnalysisResult<?>)result);
            });
        }
        results.mergeResultsOfType(ExternalAnalysisResultLineCoverage.class, ExternalAnalysisResultLineCoverage::mergeCoverage);
        return results;
    }

    private Optional<ExternalAnalysisResult<?>> createExternalAnalysisResult(String uniformPath, ExternalAnalysisImportInfo<?> importInfo, TokenElementInfo contentElement, TokenElementLineInfo lineInfo) throws StorageException {
        if (importInfo instanceof ExternalAnalysisImportInfoMetricSchemaChange || importInfo instanceof ExternalAnalysisImportInfoTestExecution || importInfo instanceof ExternalAnalysisImportInfoExecutionUnit || importInfo instanceof ExternalAnalysisImportInfoMultiFileRangeCoverage || ExternalProcessStepInfo.isProcessArtifactPath(uniformPath) || TestArtifactUtils.isTestExecutionArtifact((String)uniformPath)) {
            return Optional.of(importInfo.createAnalysisResult());
        }
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath(uniformPath)) {
            if (this.metricsDirectoryIndex.getMetricDirectoryEntry(uniformPath) == null) {
                LOGGER.error("Cannot add metrics to a path that does not exist: {}", (Object)uniformPath);
                return Optional.empty();
            }
            return Optional.of(importInfo.createAnalysisResult());
        }
        return this.createFileResult(uniformPath, contentElement, lineInfo, importInfo);
    }

    private Optional<ExternalAnalysisResult<?>> createFileResult(String uniformPath, TokenElementInfo contentInfo, TokenElementLineInfo lineInfo, ExternalAnalysisImportInfo<?> importInfo) throws StorageException {
        if (!ExternalAnalysisImportInfo.hasRequiredDataForAdjustment(contentInfo, lineInfo, importInfo)) {
            LOGGER.warn("Obtained external results for a file that is not in the index: {}", (Object)uniformPath);
            return Optional.empty();
        }
        if (importInfo instanceof ExternalAnalysisImportInfoProcessStepInfo) {
            LOGGER.error("Non-process path {} contained process metrics!", (Object)uniformPath);
        }
        CodeScopeName codeScopeName = contentInfo != null ? CodeScopeDetail.getCodeScopeNameFromTokenElement(contentInfo) : CodeScopeName.DEFAULT;
        try {
            return Optional.of(importInfo.createAdjustedAnalysisResult(contentInfo, lineInfo, uniformPath, codeScopeName, this.findingLocationAdjuster::createFindingsAdjuster, IntegrateImportedAnalysisResultsTrigger::createDependencyAdjuster));
        }
        catch (ConQATException e) {
            throw (StorageException)((Object)e);
        }
    }

    private static void fillInMissingOffsets(String content, ExternalDependencyInfo dependencyInfo) {
        LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(content);
        List<ExternalDependencyInfo.Dependency> dependencies = dependencyInfo.getDependencies();
        for (ExternalDependencyInfo.Dependency dependency : dependencies) {
            ArrayList<TextRegionLocation> locations = new ArrayList<TextRegionLocation>(dependency.getLocations());
            dependency.getLocations().clear();
            for (TextRegionLocation location : locations) {
                dependency.getLocations().add(IndexFindingUtils.fillInMissingOffsets((TextRegionLocation)location, (LineOffsetConverter)lineOffsetConverter, (String)content));
            }
        }
    }

    public static ExternalAnalysisImportInfo.IDependencyAdjuster createDependencyAdjuster(String importedContent) {
        return dependencyInfo -> {
            IntegrateImportedAnalysisResultsTrigger.fillInMissingOffsets(importedContent, dependencyInfo);
            return dependencyInfo;
        };
    }

    public Set<String> getReadOnlyPreviousStores() {
        return CollectionUtils.unionSet((Collection)super.getReadOnlyPreviousStores(), (Collection[])new Collection[]{Arrays.asList("content", "binary-content", "simulink-model-info", "path-lookup", "types", "metrics-dir")});
    }

    public Set<String> getWriteStores() {
        return CollectionUtils.unionSet((Collection)super.getWriteStores(), (Collection[])new Collection[]{Arrays.asList("external-analysis-results", "external-analysis-session")});
    }
}

