/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.abaplint;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.findings.LintFindingsSynchronizerBase;
import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFile;
import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFileUtils;
import com.teamscale.index.findings.abaplint.ABAPLintReportReader;
import com.teamscale.index.gitbridge.abap.metadata.AbapGitMetaDataWriterFactory;
import com.teamscale.index.gitbridge.abap.metadata.IAbapGitMetaDataWriter;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.repository.sap.abapsystem.SapVersionIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.abap.AbapIncludeIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ITypeTracker;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypeTrackerFactory;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileOnlyFilter;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ABAPLintFindingsSynchronizer
extends LintFindingsSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ABAPLINT_GENERIC_ERROR_CODE = 2;
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = CollectionUtils.asHashSet((Object[])new String[]{"abap", "xml", "json", "abap_cds", "abap_ddlx"});
    private static final String BUNDLED_ABAPLINT_PATH = "@abaplint/cli/abaplint";
    private static final String NODE_EXECUTABLE = "node";
    public static final String ABAPLINT_CONFIGURATION_FILENAME = "abaplint.json";
    private static final String FINDINGS_RESULT_FILENAME = "abaplint_findings.json";
    private static final int ABAP_LINT_DEFAULT_BATCH_SIZE = 500;
    private static final Optional<Integer> ABAPLINT_BATCH_SIZE = TeamscaleSystemProperties.ABAPLINT_FILE_BATCH_SIZE.getValue();
    private static final Optional<Integer> ABAPLINT_NODE_MAX_OLD_SPACE_SIZE = TeamscaleSystemProperties.ABAPLINT_NODE_MAX_OLD_SPACE_SIZE.getValue();
    public static final String FINDING_PARTITION = "abaplint-internal";
    public static final String DEFAULT_LANGUAGE_PARAMETER = "default-language";
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    public static final String CHECK_OPTION_TYPES_PARAMETER = "check-option-types";
    public static final String CHECK_OPTION_VALUES_PARAMETER = "check-option-values";
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SapVersionIndex sapVersionIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementMetadataIndex tokenElementMetadataIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private AbapIncludeIndex includeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="dependencies")
    private DependencyListIndex dependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="inverse-dependencies")
    private DependencyListIndex inverseDependencyIndex;
    @DeltaSource(value=TokenElementMetadataIndex.class, indexName="token-elements-metadata")
    protected KeyDelta metadataDelta;
    @StepParameter(value="checks")
    private final List<String> selectedChecks = new ArrayList<String>();
    @StepParameter(value="default-language", optional=true)
    private final String defaultLanguage;
    @StepParameter(value="check-options", optional=true)
    private final List<String> selectedOptions = new ArrayList<String>();
    @StepParameter(value="check-option-types", optional=true)
    private final List<String> checkOptionTypes = new ArrayList<String>();
    @StepParameter(value="check-option-values", optional=true)
    private final List<String> checkOptionValues = new ArrayList<String>();

    public ABAPLintFindingsSynchronizer() {
        super(FINDING_PARTITION, SUPPORTED_FILE_EXTENSIONS);
        this.defaultLanguage = null;
    }

    @Override
    protected Set<BasicTokenElementInfo> determineElementsToAnalyze() throws StorageException {
        HashSet elementsToAnalyze = super.determineElementsToAnalyze();
        try {
            ArrayList<String> pathsWithAddedOrChangedMetadata = new ArrayList<String>(this.getPathsWithAddedOrChangedMetadata());
            if (!pathsWithAddedOrChangedMetadata.isEmpty()) {
                elementsToAnalyze = CollectionUtils.unionSet(elementsToAnalyze, (Collection[])new Collection[]{CollectionUtils.filterWithException(this.basicTokenElementIndex.getTokenElements(pathsWithAddedOrChangedMetadata), (FunctionWithException)this.tokenElementFilter)});
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Could not read paths of ABAP files where the metadata has changed. This can cause ABAPLint to run on fewer files than expected leading to incomplete results.\n", (Throwable)e);
        }
        return elementsToAnalyze;
    }

    private Set<String> getPathsWithAddedOrChangedMetadata() throws StorageException {
        return this.tokenElementMetadataIndex.getMetadataForKeys((List<StorageKey>)this.metadataDelta.getAddedOrChangedKeys()).getKeys();
    }

    @Override
    protected ListMap<String, IndexFinding> lintFiles(Collection<BasicTokenElementInfo> elementsInCodeScope, CodeScopeName codeScopeName) {
        ListMap findings = new ListMap();
        int abapLintBatchSize = ABAPLINT_BATCH_SIZE.orElse(500);
        try {
            ReentrantLock lock = new ReentrantLock();
            this.executeInParallelBatches(new ArrayList<BasicTokenElementInfo>(elementsInCodeScope), elementsBatch -> {
                ListMap<String, IndexFinding> batchFindings = super.lintFiles((Collection<BasicTokenElementInfo>)elementsBatch, codeScopeName);
                batchFindings = this.filterFindings(batchFindings, (List<BasicTokenElementInfo>)elementsBatch);
                try {
                    lock.lock();
                    findings.addAll(batchFindings);
                }
                finally {
                    lock.unlock();
                }
            }, abapLintBatchSize);
        }
        catch (ExecutionException e) {
            LOGGER.error("Could not perform parallel execution", (Throwable)e);
        }
        return findings;
    }

    private ListMap<String, IndexFinding> filterFindings(ListMap<String, IndexFinding> unfilteredFindings, List<BasicTokenElementInfo> lintedElements) throws StorageException {
        Set<String> relevantPaths = lintedElements.stream().map(BasicTokenElementInfo::getUniformPath).collect(Collectors.toSet());
        ListMap<String, IndexFinding> filteredFindings = ABAPLintFindingsSynchronizer.filterDuplicates(unfilteredFindings);
        filteredFindings = ABAPLintFindingsSynchronizer.filterFindingsForNonRelevantPaths(filteredFindings, relevantPaths);
        filteredFindings = ABAPLintFindingsSynchronizer.filterFindingsRepresentingAbapLintExecutionIssues(filteredFindings);
        filteredFindings = this.filterFalsePositives(filteredFindings, lintedElements);
        return filteredFindings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<String> executeLint(Collection<BasicTokenElementInfo> tokenElements, CodeScopeName codeScopeName) throws ConQATException {
        try (TemporaryDirectory tmpDir = ABAPLintFindingsSynchronizer.getTempDirectory((String)"abaplintexecutor");){
            CanonicalFile tempSrcDirectory = new CanonicalFile(tmpDir.getPath().toFile());
            CanonicalFile tempDepDirectory = new CanonicalFile((File)tempSrcDirectory, "deps");
            FileSystemUtils.ensureDirectoryExists((Path)tempDepDirectory.toPath());
            List<String> temporaryFiles = this.createTemporaryFiles(tempSrcDirectory, tempDepDirectory, codeScopeName, tokenElements);
            if (temporaryFiles.isEmpty()) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            File abapLintDir = NativeLibUtil.getNativeLib((String)"abaplint");
            FileSystemUtils.copyFiles((File)new File(abapLintDir, "deps/src"), (File)tempDepDirectory, (FileFilter)new FileOnlyFilter());
            this.generateAbapLintConfigFileAndStoreToTemp(tempSrcDirectory, tempDepDirectory);
            String result = this.execute((File)tempSrcDirectory, abapLintDir);
            result = ABAPLintFindingsSynchronizer.postProcessFindingResults(result, tempSrcDirectory, tokenElements, temporaryFiles);
            Optional<String> optional = Optional.of(result);
            return optional;
        }
        catch (IOException | SecurityException e) {
            throw new ConQATException(e.getMessage(), (Throwable)e);
        }
    }

    private void generateAbapLintConfigFileAndStoreToTemp(CanonicalFile tempSrcDirectory, CanonicalFile tempDepDirectory) throws JsonSerializationException, IOException {
        String jsonContent = Resource.of(((Object)((Object)this)).getClass(), (String)ABAPLINT_CONFIGURATION_FILENAME).getContent();
        ABAPLintConfigurationFile baseConfig = (ABAPLintConfigurationFile)JsonUtils.deserializeFromJson((String)jsonContent, ABAPLintConfigurationFile.class);
        this.selectedChecks.forEach(baseConfig::addRuleWithDefaultOptions);
        for (int i = 0; i < this.selectedOptions.size(); ++i) {
            String option = this.selectedOptions.get(i);
            baseConfig.addCheckOption(ABAPLintConfigurationFileUtils.extractCheckIdFromPrefixedCheckOption(option), ABAPLintConfigurationFileUtils.extractOptionIdFromPrefixedCheckOption(option), this.checkOptionTypes.get(i), this.checkOptionValues.get(i));
        }
        baseConfig.setLanguageVersion(this.getLanguageVersion());
        baseConfig.addDependencyFolder(tempDepDirectory.getName());
        String configJsonContent = JsonUtils.serializeToJSON((Object)baseConfig);
        File configFile = new File((File)tempSrcDirectory, ABAPLINT_CONFIGURATION_FILENAME);
        FileSystemUtils.writeFileUTF8((Path)configFile.toPath(), (String)configJsonContent);
    }

    private String execute(File tempDirectory, File abapLintDirectory) throws IOException, ConQATException, SecurityException {
        File resultFile;
        List<String> command = ABAPLintFindingsSynchronizer.getAbapLintCommand(abapLintDirectory);
        String commandToLog = StringUtils.concat(command);
        LOGGER.info("Command: {}", (Object)commandToLog);
        ProcessBuilder builder = new ProcessBuilder(command).directory(tempDirectory);
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)builder);
        String stdOut = result.getStdout();
        String stdErr = result.getStderr();
        if (!StringUtils.isEmpty((String)stdErr)) {
            LOGGER.info(stdErr);
        }
        if (result.getReturnCode() == 2 || result.terminatedByTimeoutOrInterruption()) {
            this.throwProcessFailure(commandToLog, stdOut, stdErr, result.getReturnCode());
        }
        if (!(resultFile = new File(tempDirectory, FINDINGS_RESULT_FILENAME)).exists()) {
            this.throwProcessFailure("AbapLint result file " + resultFile.getPath() + " was not created.\n" + commandToLog, stdOut, stdErr, result.getReturnCode());
        }
        return FileSystemUtils.readFileUTF8((Path)resultFile.toPath());
    }

    private void throwProcessFailure(String commandToLog, String stdOut, String stdErr, int exitValue) throws ConQATException {
        throw new ConQATException("Executing " + commandToLog + StringUtils.LINE_SEPARATOR + "Process failed with exit value " + exitValue + StringUtils.LINE_SEPARATOR + "Used Language Version: " + this.getLanguageVersion() + StringUtils.LINE_SEPARATOR + "Standard Error:" + StringUtils.LINE_SEPARATOR + stdErr + StringUtils.LINE_SEPARATOR + "Standard Out:" + StringUtils.LINE_SEPARATOR + stdOut);
    }

    private static String postProcessFindingResults(String result, CanonicalFile rootDirectory, Collection<BasicTokenElementInfo> tokenElementInfos, List<String> relativeFilePaths) {
        HashMap<Object, String> replacements = new HashMap<Object, String>();
        boolean tokensUseExporterFormat = tokenElementInfos.stream().map(BasicTokenElementInfo::getUniformPath).anyMatch(ParsedAbapElementPath::isExporterPathFormat);
        if (tokensUseExporterFormat) {
            for (String filePath : relativeFilePaths) {
                String normalizedPath = UniformPathUtils.normalizeAllSeparators((String)filePath);
                if (normalizedPath.endsWith(".xml") || normalizedPath.endsWith(".json")) continue;
                try {
                    replacements.put(normalizedPath, new ParsedAbapElementPath(normalizedPath).convertToTeamscaleExporterFormat());
                }
                catch (ConQATException e) {
                    LOGGER.warn("Could not convert file ({}) to Teamscale exporter format. AbapLint findings for it will not be available: {}\n", (Object)normalizedPath, (Object)e.getMessage(), (Object)e);
                }
            }
        }
        replacements.put(UniformPathUtils.normalizeAllSeparators((String)rootDirectory.getCanonicalPath()) + "/", "");
        replacements.put("\\\"", "`");
        return StringUtils.replaceFromMap((String)result, replacements);
    }

    @Override
    protected ListMap<String, IndexFinding> parseReport(String reportContent) throws ConQATException {
        ABAPLintReportReader reportReader = new ABAPLintReportReader(this.pathLookupIndex.createLoggingPreloadedLookup());
        return reportReader.parseReport(reportContent, this.getContentIndexCache());
    }

    private static ListMap<String, IndexFinding> filterDuplicates(ListMap<String, IndexFinding> unfilteredFindings) {
        ListMap filteredFindings = new ListMap();
        for (String file : unfilteredFindings.getKeys()) {
            List findings = (List)unfilteredFindings.getCollection((Object)file);
            if (findings == null) continue;
            TreeSet distinctFindings = new TreeSet(IndexFinding.STABLE_INDEX_FINDING_COMPARATOR);
            distinctFindings.addAll(findings);
            filteredFindings.addAll((Object)file, new ArrayList(distinctFindings));
        }
        return filteredFindings;
    }

    private ListMap<String, IndexFinding> filterFalsePositives(ListMap<String, IndexFinding> unfilteredFindings, List<BasicTokenElementInfo> tokenElementInfos) throws StorageException {
        HashMap<String, BasicTokenElementInfo> tokenElementInfoMap = new HashMap<String, BasicTokenElementInfo>();
        for (BasicTokenElementInfo tokenElementInfo : tokenElementInfos) {
            tokenElementInfoMap.put(tokenElementInfo.getUniformPath(), tokenElementInfo);
        }
        ListMap filteredFindings = new ListMap();
        for (Map.Entry findingsForFile : unfilteredFindings.entrySet()) {
            String file = (String)findingsForFile.getKey();
            List findings = (List)findingsForFile.getValue();
            BasicTokenElementInfo tokenElementInfo = (BasicTokenElementInfo)tokenElementInfoMap.get(file);
            for (IndexFinding finding : findings) {
                if (this.shouldFilterOut(finding, tokenElementInfo)) continue;
                filteredFindings.add((Object)file, (Object)finding);
            }
        }
        return filteredFindings;
    }

    private boolean shouldFilterOut(IndexFinding finding, BasicTokenElementInfo tokenElementInfo) throws StorageException {
        if (finding.getMessage().startsWith("Omit 'me->'")) {
            return this.isMeReferenceRequired(finding, tokenElementInfo);
        }
        return false;
    }

    private boolean isMeReferenceRequired(IndexFinding finding, BasicTokenElementInfo basicTokenElementInfo) throws StorageException {
        TextRegionLocation location = (TextRegionLocation)finding.getLocation();
        TokenElementInfo tokenElementInfo = this.getContentIndexCache().getValue(basicTokenElementInfo.getUniformPath());
        Optional findingEntity = ShallowEntityTraversalUtils.findEntityForLine((int)location.getRawStartLine(), tokenElementInfo.getShallowEntitiesWithPreprocessorTokens());
        if (findingEntity.isEmpty()) {
            return false;
        }
        UnmodifiableList statementTokens = ((ShallowEntity)findingEntity.get()).includedTokens();
        List findingTokens = TokenStreamUtils.getTokensBetween((List)statementTokens, (int)location.getRawStartOffset(), (int)(location.getRawEndOffset() + 1));
        String identifierAccessedWithMe = ((IToken)findingTokens.get(2)).getText();
        ITypeTracker typeTracker = TypeTrackerFactory.createTypeTracker((ELanguage)ELanguage.ABAP);
        ITypeResolution typeResolution = typeTracker.createTypeResolution(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens());
        if (findingTokens.size() < 3 || ((IToken)findingTokens.get(2)).getType() != ETokenType.IDENTIFIER || !AbapCheckUtils.isVariable((String)identifierAccessedWithMe, (ShallowEntity)((ShallowEntity)findingEntity.get()), (ITypeResolution)typeResolution)) {
            return false;
        }
        ScopedTypeLookup scopedTypeLookup = typeResolution.getTypeLookup((ShallowEntity)findingEntity.get());
        List attributeDefinitions = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens(), Set.of(EShallowEntityType.ATTRIBUTE), Set.of("data"));
        for (ShallowEntity attributeDefinition : attributeDefinitions) {
            if (!scopedTypeLookup.isShadowingVariable(identifierAccessedWithMe, attributeDefinition)) continue;
            return true;
        }
        return false;
    }

    private static ListMap<String, IndexFinding> filterFindingsForNonRelevantPaths(ListMap<String, IndexFinding> unfilteredFindings, Set<String> relevantPaths) {
        ListMap filteredFindings = new ListMap();
        for (String relevantPath : relevantPaths) {
            if (!unfilteredFindings.containsCollection((Object)relevantPath)) continue;
            filteredFindings.addAll((Object)relevantPath, unfilteredFindings.getCollection((Object)relevantPath));
        }
        return filteredFindings;
    }

    private static ListMap<String, IndexFinding> filterFindingsRepresentingAbapLintExecutionIssues(ListMap<String, IndexFinding> unfilteredFindings) {
        ListMap filteredFindings = new ListMap();
        for (Map.Entry findingsForFile : unfilteredFindings.entrySet()) {
            String file = (String)findingsForFile.getKey();
            List findings = (List)findingsForFile.getValue();
            for (IndexFinding finding : findings) {
                if (finding.getMessage().endsWith("not found")) {
                    LOGGER.debug("Skipping finding representing execution issue: '{}'", (Object)finding);
                    continue;
                }
                filteredFindings.add((Object)file, (Object)finding);
            }
        }
        return filteredFindings;
    }

    private static List<String> getAbapLintCommand(File abapLintDirectory) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(NODE_EXECUTABLE);
        ABAPLINT_NODE_MAX_OLD_SPACE_SIZE.ifPresent(nodeMaxOldSpace -> command.add("--max-old-space-size=" + nodeMaxOldSpace));
        command.add(new File(abapLintDirectory, BUNDLED_ABAPLINT_PATH).getAbsolutePath());
        command.add("--outformat");
        command.add("json");
        command.add("--outfile");
        command.add(FINDINGS_RESULT_FILENAME);
        return command;
    }

    private List<String> createTemporaryFiles(CanonicalFile tempSrcDirectory, CanonicalFile tempDepDirectory, CodeScopeName codeScope, Collection<BasicTokenElementInfo> tokenElementInfos) throws ConQATException, IOException {
        Set<String> dependencies = this.getDependencies(tokenElementInfos);
        Set<BasicTokenElementInfo> dependenciesTokenElementInfos = this.getContentIndexCache().getValues(dependencies).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        dependenciesTokenElementInfos = ABAPLintFindingsSynchronizer.filterForElementsInSameScope(dependenciesTokenElementInfos, codeScope, (UnmodifiableSet<BasicTokenElementInfo>)UnmodifiableSet.of(new HashSet<BasicTokenElementInfo>(tokenElementInfos)));
        HashMap<String, ParsedAbapElementPath> parsedPaths = new HashMap<String, ParsedAbapElementPath>();
        parsedPaths.putAll(ABAPLintFindingsSynchronizer.createParsedPaths(tokenElementInfos));
        parsedPaths.putAll(ABAPLintFindingsSynchronizer.createParsedPaths(dependenciesTokenElementInfos));
        ArrayList<String> temporaryFiles = new ArrayList<String>();
        temporaryFiles.addAll(this.createMetadataFiles(tempSrcDirectory, tokenElementInfos, parsedPaths));
        temporaryFiles.addAll(this.createMetadataFiles(tempDepDirectory, dependenciesTokenElementInfos, parsedPaths));
        temporaryFiles.addAll(ABAPLintFindingsSynchronizer.createTemporaryFiles(tempSrcDirectory, tokenElementInfos, ABAPLintFindingsSynchronizer.converterToAbapGit(parsedPaths)));
        temporaryFiles.addAll(ABAPLintFindingsSynchronizer.createTemporaryFiles(tempDepDirectory, dependenciesTokenElementInfos, ABAPLintFindingsSynchronizer.converterToAbapGit(parsedPaths)));
        return temporaryFiles;
    }

    private Set<String> getDependencies(Collection<BasicTokenElementInfo> tokenElementInfos) throws StorageException {
        List<String> paths = tokenElementInfos.stream().map(BasicTokenElementInfo::getUniformPath).toList();
        HashSet<String> dependencies = new HashSet<String>();
        List<String> transitiveIncludingFiles = ((Set)this.includeIndex.getInboundsTransitive(paths).getValues()).stream().filter(Objects::nonNull).toList();
        dependencies.addAll(transitiveIncludingFiles);
        ((Set)this.includeIndex.getOutboundsTransitive(transitiveIncludingFiles).getValues()).stream().filter(Objects::nonNull).forEach(dependencies::add);
        this.includeIndex.getOutbounds(paths).stream().filter(Objects::nonNull).forEach(dependencies::addAll);
        this.dependencyIndex.getDependencies(paths).stream().filter(Objects::nonNull).forEach(dependencies::addAll);
        this.inverseDependencyIndex.getDependencies(paths).stream().filter(Objects::nonNull).forEach(dependencies::addAll);
        paths.forEach(dependencies::remove);
        return dependencies;
    }

    private static Map<String, ParsedAbapElementPath> createParsedPaths(Collection<BasicTokenElementInfo> infos) {
        HashMap<String, ParsedAbapElementPath> parsedPaths = new HashMap<String, ParsedAbapElementPath>();
        for (BasicTokenElementInfo info : infos) {
            String path = info.getUniformPath();
            ABAPLintFindingsSynchronizer.createParsedPath(path).ifPresent(parsedPath -> parsedPaths.put(path, (ParsedAbapElementPath)parsedPath));
        }
        return parsedPaths;
    }

    private static Optional<ParsedAbapElementPath> createParsedPath(String path) {
        try {
            return Optional.of(new ParsedAbapElementPath(path));
        }
        catch (ConQATException e) {
            LOGGER.warn((Object)e);
            return Optional.empty();
        }
    }

    private static FunctionWithException<String, String, ConQATException> converterToAbapGit(Map<String, ParsedAbapElementPath> parsedPaths) {
        return path -> {
            ParsedAbapElementPath parsedPath = (ParsedAbapElementPath)parsedPaths.get(path);
            if (parsedPath == null) {
                return path;
            }
            return parsedPath.convertToAbapGitFormat();
        };
    }

    private List<String> createMetadataFiles(CanonicalFile tempDirectory, Collection<BasicTokenElementInfo> tokenElementInfos, Map<String, ParsedAbapElementPath> parsedPaths) {
        List<AbapFileMetadata> metadataForFiles;
        List uniformPaths = CollectionUtils.map(tokenElementInfos, BasicTokenElementInfo::getUniformPath);
        try {
            metadataForFiles = this.tokenElementMetadataIndex.getMetadataOfTypeForFiles(uniformPaths, AbapFileMetadata.class);
        }
        catch (StorageException e) {
            LOGGER.error((Object)e);
            return List.of();
        }
        ArrayList<String> addedFiles = new ArrayList<String>();
        for (int i = 0; i < tokenElementInfos.size(); ++i) {
            String uniformPath = (String)uniformPaths.get(i);
            ParsedAbapElementPath path = parsedPaths.get(uniformPath);
            Optional<IAbapGitMetaDataWriter> writer = AbapGitMetaDataWriterFactory.createWriter(path.getType());
            if (writer.isEmpty()) {
                LOGGER.debug("No writer known for {}", (Object)path.getType());
                continue;
            }
            AbapFileMetadata abapMetadata = metadataForFiles.get(i);
            if (abapMetadata == null) {
                LOGGER.debug("No abap metadata known for {}", (Object)uniformPath);
                continue;
            }
            String metaDataPath = StringUtils.removeLastPart((String)path.convertToAbapGitFormat(), (char)'.') + ".xml";
            if (!ABAPLintFindingsSynchronizer.writeMetadataFile(tempDirectory, metaDataPath, writer.get(), abapMetadata)) continue;
            addedFiles.add(metaDataPath);
        }
        return addedFiles;
    }

    private static boolean writeMetadataFile(CanonicalFile tempDirectory, String metaDataFilePath, IAbapGitMetaDataWriter writer, AbapFileMetadata abapMetadata) {
        try {
            Path tempDirectoryPath = tempDirectory.toPath();
            Path metaDataPath = tempDirectoryPath.resolve(metaDataFilePath);
            Files.createDirectories(metaDataPath.getParent(), new FileAttribute[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(metaDataPath.toFile());){
                writer.write(abapMetadata, fileOutputStream);
            }
            return true;
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String getLanguageVersion() {
        if (!StringUtils.isEmpty((String)this.defaultLanguage)) {
            LOGGER.trace("Using default language: {}", (Object)this.defaultLanguage);
            return this.defaultLanguage;
        }
        try {
            Set<String> sapConfigurationIds = AbapProjectUtils.resolveSapConfigurationIdsForProject(this.externalCredentialsIndex, this.metaIndex);
            String version = AbapProjectUtils.getAbapVersionFromIndex(this.sapVersionIndex, sapConfigurationIds);
            LOGGER.trace("Using version from index: {}", (Object)version);
            return version;
        }
        catch (StorageException e) {
            LOGGER.warn("Could not determine the used ABAP version automatically. Defaulting to abaplint syntax version {}.", (Object)"v740sp08", (Object)e);
            return "v740sp08";
        }
    }
}

