/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="clang-tidy-outsourced-analysis-sessions", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class ClangTidyOutsourcedAnalysisSessionsIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "clang-tidy-outsourced-analysis-sessions";
    private final ValueIndex<CodeScopeName> delegateIndex;

    public ClangTidyOutsourcedAnalysisSessionsIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public void storeSessions(CodeScopeAware<String> sessionKeysPerCodeScope) throws StorageException {
        PairList values = new PairList();
        for (CodeScopeName codeScopeName : sessionKeysPerCodeScope.getCodeScopeNames()) {
            String sessionKey = (String)sessionKeysPerCodeScope.getValue(codeScopeName);
            values.add((Object)sessionKey, (Object)codeScopeName);
        }
        this.delegateIndex.setValues(values);
    }

    public Map<String, CodeScopeName> getCodeScopesBySession(List<String> sessionKeys) throws StorageException {
        return this.delegateIndex.getValuesByKeys(sessionKeys);
    }

    public Set<String> readAllSessions() throws StorageException {
        return new HashSet<String>(this.delegateIndex.getAllKeys());
    }
}

