/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.eslint;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.ECheckstyleReportAttributes;
import com.teamscale.index.findings.ECheckstyleReportElements;
import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public class ESLintReportReader
extends FindingReportAnalyzerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public ESLintReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    public ListMap<String, IndexFinding> parseReport(String content) throws ConQATException {
        return new CheckstyleReportReader(content).load();
    }

    private static String getCategory() {
        return "ESLint";
    }

    private static String getCheckID(String message) {
        int typeBegin = message.lastIndexOf(40) + 1;
        int typeEnd = message.indexOf(41, typeBegin);
        if (typeEnd < 0) {
            return message;
        }
        return message.substring(typeBegin, typeEnd);
    }

    private static String getMessageForFinding(String message) {
        int parenthesisStart = message.lastIndexOf(40);
        if (parenthesisStart < 0) {
            return message;
        }
        return message.substring(0, parenthesisStart);
    }

    private final class CheckstyleReportReader
    extends XMLReaderBase<ECheckstyleReportElements, ECheckstyleReportAttributes, ConQATException> {
        private final ListMap<String, IndexFinding> findings;

        private CheckstyleReportReader(String content) {
            super(content, ECheckstyleReportAttributes.class);
            this.findings = new ListMap();
        }

        public ListMap<String, IndexFinding> load() throws ConQATException {
            this.parseAndWrapExceptions();
            this.processChildElements(new FileInstanceProcessor());
            return this.findings;
        }

        protected String getLocation() {
            return "report";
        }

        private final class FileInstanceProcessor
        implements IXMLElementProcessor<ECheckstyleReportElements, ConQATException> {
            private FileInstanceProcessor() {
            }

            public ECheckstyleReportElements getTargetElement() {
                return ECheckstyleReportElements.file;
            }

            public void process() throws ConQATException {
                String fileName = CheckstyleReportReader.this.getStringAttribute(ECheckstyleReportAttributes.name);
                CheckstyleReportReader.this.processChildElements(new ErrorInstanceProcessor(fileName));
            }
        }

        private final class ErrorInstanceProcessor
        implements IXMLElementProcessor<ECheckstyleReportElements, ConQATException> {
            private final String fileName;

            public ErrorInstanceProcessor(String fileName) {
                this.fileName = fileName;
            }

            public ECheckstyleReportElements getTargetElement() {
                return ECheckstyleReportElements.error;
            }

            public void process() {
                Optional<String> uniformPath;
                String message = CheckstyleReportReader.this.getStringAttribute(ECheckstyleReportAttributes.message);
                String lineStr = CheckstyleReportReader.this.getStringAttribute(ECheckstyleReportAttributes.line);
                if ("undefined".equals(lineStr)) {
                    return;
                }
                int line = CheckstyleReportReader.this.getIntAttribute(ECheckstyleReportAttributes.line);
                if (line == 0) {
                    LOGGER.error(message);
                    return;
                }
                Path workingDir = FileSystemUtils.getJvmWorkingDirOrTempForDevMode().toPath();
                Path reportPath = Paths.get(this.fileName, new String[0]);
                if (reportPath.startsWith(workingDir)) {
                    reportPath = workingDir.relativize(reportPath);
                }
                if ((uniformPath = ESLintReportReader.this.matchingPathsLookup.lookupBestPath(reportPath.toString(), PathLookupOptions.defaults())).isEmpty()) {
                    return;
                }
                String checkID = ESLintReportReader.getCheckID(message);
                IndexFinding finding = new IndexFinding(checkID, ESLintReportReader.getCategory(), ESLintReportReader.getMessageForFinding(message), (ElementLocation)new TextRegionLocation(uniformPath.get(), -1, -1, line, line));
                IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)checkID, (Set)EAnalysisTool.ESLINT.getSupportedLanguages());
                CheckstyleReportReader.this.findings.add((Object)uniformPath.get(), (Object)finding);
            }
        }
    }
}

