/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.ZipToGitImporter;
import com.teamscale.index.gitbridge.ZipToGitImporterUtils;
import com.teamscale.index.gitbridge.abap.AbapFileMetadataManager;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import com.teamscale.index.gitbridge.abap.AbapWorkTreeManager;
import com.teamscale.index.gitbridge.abap.ChangedPackagePathsReader;
import com.teamscale.index.gitbridge.abap.CommitCluster;
import com.teamscale.index.gitbridge.abap.CommitInfo;
import com.teamscale.index.gitbridge.abap.DeletedElementsReader;
import com.teamscale.index.gitbridge.abap.ElementMove;
import com.teamscale.index.gitbridge.abap.ExportMetaData;
import com.teamscale.index.gitbridge.abap.InconsistentAbapRepositoryException;
import com.teamscale.index.gitbridge.abap.MovedElementsReader;
import com.teamscale.index.gitbridge.abap.ObjectMetaData;
import com.teamscale.index.gitbridge.abap.ScovCollectionReader;
import com.teamscale.index.gitbridge.abap.ThirdPartyPathsReader;
import com.teamscale.index.gitbridge.abap.UpdateResult;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitImporter;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitUtils;
import com.teamscale.index.repository.sap.abapsystem.SapVersion;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.testgap.abap.AbapTableDumpXmlHandler;
import com.teamscale.index.testgap.abap.BwPathTransformation;
import com.teamscale.index.testgap.abap.ScovIdFeature;
import com.teamscale.index.testgap.abap.structure.EBwDtpFields;
import com.teamscale.index.testgap.abap.structure.EBwQueryFields;
import com.teamscale.index.testgap.abap.structure.EBwTransformationFields;
import com.teamscale.index.testgap.abap.traces.AbapTraceUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.SAXException;

public class AbapGitImporter
implements AutoCloseable {
    public static final Pattern DIFFERENT_SOURCE_SYSTEM_PATTERN = Pattern.compile(".* \\(transport from [a-zA-Z0-9]{3}\\).*", 32);
    private static final String BW_QUERIES_XML = "bw_queries.xml";
    private static final String BW_DTPS_XML = "bw_dtps.xml";
    private static final String BW_TRANSFORMATIONS_XML = "bw_transformations.xml";
    private static final String SCOV_COLLECTION_XML = "scov_collection.xml";
    private static final String COMMIT_MESSAGE_DELETIONS_MOVES = "Deletions/moves";
    private static final String COMMIT_MESSAGE_COVERAGE = "Coverage";
    private static final String COMMIT_MESSAGE_INITIAL_IMPORT = "Start of incremental analysis of ABAP code";
    private static final String COMMIT_MESSAGE_SYNCHRONIZATION = "Synchronization after full ABAP export";
    private static final Pattern EXPORT_FINISHED_DATE_PATTERN = Pattern.compile(".*Export finished: (\\d\\d/\\d\\d/\\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d).*");
    private static final Pattern COVERAGE_FILE_NAME_PATTERN = Pattern.compile("procedure_covs_([^/]*).xml");
    private static final String COVERAGE_DEFAULT_PARTITION = "default";
    private static final String COVERAGE_FOLDER_NAME = "coverage";
    private static final String COVERAGE_EXTENSION = "scov";
    public static final String COVERAGE_FILE_COUNT_SEPARATOR = "->";
    public static final String COVERAGE_FILE_OPTION_PREFIX = "#";
    public static final String COVERAGE_FILE_ALL_DELTA_OPTION = "#all-delta=";
    private static final String CODE_INSPECTOR_VARIANT_PREFIX = "INFO : Code Inspector variant:";
    private static final String TEAMSCALE_CONNECTOR_VERSION_PREFIX = "INFO : Teamscale Connec";
    private static final String SAP_SYSTEM_VERSION_PREFIX = "INFO : SAP ABAP Software Component";
    private static final Pattern EXPORTER_LOG_PATTERN = Pattern.compile("^(INFO|WARN|ERROR) : (.*)$");
    private static final Pattern OBJECT_PATHS_FILENAME_PATTERN = Pattern.compile("all_object_paths_([^/_]*)(_\\d+)?.xml");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String GENERIC_USER_NAME = "ABAP Importer";
    private static final Pattern OBJECT_META_DATA_FILE_PATTERN = Pattern.compile("object_meta_data(_\\d+)?.xml");
    private final String emailDomain;
    private final ZipToGitImporter zipImporter;
    private ZipFile zipFile;
    private AbapWorkTreeManager workTreeManager;
    private ExportMetaData exportMetaData;
    private boolean zipContainsSources;
    private ObjectMetaData objectMetaData;
    private final int maxCommitGapSeconds;
    private final boolean isAllDelta;
    private final AbapFileMetadataManager abapFileMetadataManager;
    private CodeInspectorGitImporter codeInspectorImporter;
    private String connectorVersion;
    private String systemVersion;

    public AbapGitImporter(CanonicalFile gitRepositoryLocation, String emailDomain, int maxCommitGapSeconds, boolean isAllDelta) throws GitBridgeException {
        this.zipImporter = new ZipToGitImporter(gitRepositoryLocation);
        this.abapFileMetadataManager = new AbapFileMetadataManager(this.zipImporter);
        this.emailDomain = emailDomain;
        this.maxCommitGapSeconds = maxCommitGapSeconds;
        this.isAllDelta = isAllDelta;
    }

    public UpdateResult updateRepository(String sapSystemId, CanonicalFile file, BiConsumer<ProjectConnectorStatus.EConnectorStatus, String> updateProcessStatusReporter) throws GitBridgeException {
        UpdateResult updateResult;
        ZipFile zip = new ZipFile((File)file, AbapUtils.ABAP_ZIP_ENCODING);
        try {
            LOGGER.info(sapSystemId + ": processing file " + String.valueOf(file));
            this.zipFile = zip;
            List exporterLogMessages = StringUtils.splitLinesAsList((String)AbapGitImporterUtils.readTextContent(this.zipFile, "export_log.txt"));
            List<SAPExportLog> sapExportLogs = AbapGitImporter.collectSAPExportLogs(exporterLogMessages);
            SAPExportLog recentErrorLog = null;
            for (SAPExportLog workerLog : sapExportLogs) {
                AbapGitImporter.logAbapExportMessage(workerLog.severity, workerLog.detailedMessages);
                if (recentErrorLog != null || !workerLog.hasErrorSeverity()) continue;
                recentErrorLog = workerLog;
            }
            this.prepareToImport(file);
            this.logInfosAndExtractVersions(exporterLogMessages);
            updateResult = this.performImportAndCommitResults(sapSystemId, file, exporterLogMessages, updateProcessStatusReporter, recentErrorLog);
        }
        catch (Throwable exporterLogMessages) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable) {
                    exporterLogMessages.addSuppressed(throwable);
                }
                throw exporterLogMessages;
            }
            catch (GitBridgeException e) {
                this.zipImporter.resetGit();
                String message = sapSystemId + ": Error during update of repository when importing " + String.valueOf(file) + ". Repository reset: " + e.getMessage();
                updateProcessStatusReporter.accept(ProjectConnectorStatus.EConnectorStatus.ERROR, message);
                throw new GitBridgeException(message, e);
            }
            catch (IOException e) {
                String message = sapSystemId + ": Can't read zip file " + String.valueOf(file) + ": " + e.getMessage();
                updateProcessStatusReporter.accept(ProjectConnectorStatus.EConnectorStatus.ERROR, message);
                throw new GitBridgeException(message, e);
            }
        }
        zip.close();
        return updateResult;
    }

    private UpdateResult performImportAndCommitResults(String sapSystemId, CanonicalFile file, List<String> exporterLogMessages, BiConsumer<ProjectConnectorStatus.EConnectorStatus, String> updateProcessStatusReporter, SAPExportLog recentErrorLog) throws GitBridgeException {
        UpdateResult result = this.zipImporter.isInitialRepository() ? this.performInitialImport(sapSystemId, exporterLogMessages) : (this.exportMetaData.isFullExport() ? this.performSynchronisationCommit(updateProcessStatusReporter, exporterLogMessages) : this.performIncrementalCommits());
        this.zipImporter.checkCleanWorkTree(file.getName());
        if (result.isAnyCommitPerformed()) {
            LOGGER.info(sapSystemId + ": " + String.valueOf(file) + " successfully committed to " + this.zipImporter.getWorkTree().getAbsolutePath());
            AbapGitImporter.reportUpdateProcessStatus(updateProcessStatusReporter, "", recentErrorLog);
        } else {
            String message = sapSystemId + ": No export was committed to local ABAP-Git repository because there was no change in code and coverage files. The export zip was archived.";
            AbapGitImporter.reportUpdateProcessStatus(updateProcessStatusReporter, message, recentErrorLog);
        }
        return result.withSapVersion(new SapVersion(this.systemVersion, this.connectorVersion));
    }

    private static void reportUpdateProcessStatus(BiConsumer<ProjectConnectorStatus.EConnectorStatus, String> updateProcessStatusReporter, String commitStatusMessage, SAPExportLog recentErrorLog) {
        if (recentErrorLog == null) {
            updateProcessStatusReporter.accept(ProjectConnectorStatus.EConnectorStatus.HEALTHY, commitStatusMessage);
        } else {
            updateProcessStatusReporter.accept(ProjectConnectorStatus.EConnectorStatus.ERROR, StringUtils.truncate((String)recentErrorLog.detailedMessages, (int)200) + "...");
        }
    }

    private void logInfosAndExtractVersions(List<String> exporterLogMessages) {
        int foundMessageCount = 0;
        for (String message : exporterLogMessages) {
            if (message.startsWith(TEAMSCALE_CONNECTOR_VERSION_PREFIX)) {
                ++foundMessageCount;
                AbapGitImporter.logWithoutLogLevel(message);
                int netweaverEndIndex = message.indexOf("Netweaver") + 9;
                int parenthesisIndex = message.indexOf(40, netweaverEndIndex);
                if (netweaverEndIndex < 0 || parenthesisIndex < 0 || parenthesisIndex > message.length()) {
                    this.connectorVersion = "unknown teamscale connector version";
                    LOGGER.error("Could not parse teamscale connector version from message " + message);
                } else {
                    this.connectorVersion = message.substring(netweaverEndIndex, parenthesisIndex).trim();
                }
            } else if (message.startsWith(SAP_SYSTEM_VERSION_PREFIX)) {
                ++foundMessageCount;
                AbapGitImporter.logWithoutLogLevel(message);
                this.systemVersion = StringUtils.stripPrefix((String)message, (String)SAP_SYSTEM_VERSION_PREFIX).trim();
            } else if (message.startsWith(CODE_INSPECTOR_VARIANT_PREFIX)) {
                ++foundMessageCount;
                AbapGitImporter.logWithoutLogLevel(message);
            }
            if (foundMessageCount != 3) continue;
            break;
        }
    }

    private static void logWithoutLogLevel(String message) {
        String messageWithoutLogLevelPrefix = message.split(" : ", 2)[1];
        LOGGER.info(messageWithoutLogLevelPrefix);
    }

    private void prepareToImport(CanonicalFile file) throws GitBridgeException {
        this.exportMetaData = new ExportMetaData(this.zipFile, (File)file);
        this.workTreeManager = new AbapWorkTreeManager(this.zipImporter, !this.exportMetaData.isFullExport());
        this.zipContainsSources = AbapGitImporterUtils.isZipFileContainingAbapSources(this.zipFile);
        Instant lastCommitTime = Instant.EPOCH;
        if (!this.zipImporter.isInitialRepository()) {
            lastCommitTime = this.zipImporter.getLastCommitTime();
        }
        if (this.zipContainsSources) {
            Set<String> metadataFiles = ZipToGitImporterUtils.findMatchingFilesInExport(OBJECT_META_DATA_FILE_PATTERN, this.zipFile);
            this.objectMetaData = new ObjectMetaData(GENERIC_USER_NAME, this.exportMetaData.getToTime(), lastCommitTime, this.exportMetaData.getTimeZone(), this.maxCommitGapSeconds);
            ZipToGitImporterUtils.feedEachXmlFileToProcessor(this.zipFile, metadataFiles, new ZipToGitImporterUtils.IXmlTableProcessor(){

                @Override
                public void processXml(String content) throws GitBridgeException {
                    AbapGitImporter.this.objectMetaData.readRecords(content);
                }
            }, "object metadata file");
        }
        this.zipImporter.setPathTransformation(this.createBwPathTransformation());
        this.zipImporter.useHeadAsResetRevision();
        this.codeInspectorImporter = new CodeInspectorGitImporter(this.zipImporter, this.zipFile);
    }

    private UpdateResult commitFilesAndCoverage(String message, List<String> exporterLogMessages) throws GitBridgeException {
        boolean thirdPartyPathsUpdated;
        Instant exportFinishedTime = this.readExportFinishedTime(exporterLogMessages);
        boolean codeCommitPerformed = this.commit(GENERIC_USER_NAME, exportFinishedTime, message);
        boolean coverageCommitPerformed = this.containsCoverage() && this.commitCoverageData(exportFinishedTime);
        boolean isCoverageOutdated = this.containsCoverageMetaData() && this.isCoverageOutdatedOrMissing(this.exportMetaData.getToTime());
        boolean bl = thirdPartyPathsUpdated = this.exportMetaData.containsObjectPaths() && this.commitObjectPathsUpdate(exportFinishedTime);
        if (codeCommitPerformed || coverageCommitPerformed || thirdPartyPathsUpdated) {
            return UpdateResult.create(isCoverageOutdated, exportFinishedTime);
        }
        return UpdateResult.create(isCoverageOutdated);
    }

    private static List<SAPExportLog> collectSAPExportLogs(List<String> exporterLogMessages) {
        ArrayList<SAPExportLog> sapExportLogs = new ArrayList<SAPExportLog>();
        String lastSeverity = null;
        StringBuilder collectedMessages = new StringBuilder();
        for (String logMessage : exporterLogMessages) {
            Matcher m = EXPORTER_LOG_PATTERN.matcher(logMessage);
            if (!m.matches()) continue;
            String currentSeverity = m.group(1);
            String currentMessage = m.group(2);
            if (!currentSeverity.equals(lastSeverity)) {
                sapExportLogs.add(new SAPExportLog(lastSeverity, collectedMessages.toString()));
                lastSeverity = currentSeverity;
                collectedMessages = new StringBuilder();
            }
            collectedMessages.append("\n").append(currentMessage);
        }
        sapExportLogs.add(new SAPExportLog(lastSeverity, collectedMessages.toString()));
        return sapExportLogs;
    }

    private static void logAbapExportMessage(String severity, String exporterMessage) {
        if (StringUtils.isEmpty((String)exporterMessage)) {
            return;
        }
        String message = " occurred during ABAP export in SAP system" + exporterMessage;
        switch (severity) {
            case "ERROR": {
                LOGGER.error("Error " + message);
                break;
            }
            case "WARN": {
                LOGGER.warn("Warning " + message);
                break;
            }
        }
    }

    private UpdateResult performIncrementalCommits() throws GitBridgeException {
        boolean isCoverageOutdated;
        SortedSet<CommitCluster> commitClusters = this.zipContainsSources ? this.objectMetaData.buildCommitClusters() : Collections.emptySortedSet();
        boolean codeCommitPerformed = this.updateDeletionsAndMoves(this.getFirstOrLastCommitTime(commitClusters, true));
        this.extractZip();
        boolean clusteredCodeCommitPerformed = this.addAndCommitByCommitClusters(commitClusters);
        Instant commitTime = this.getFirstOrLastCommitTime(commitClusters, false);
        boolean containsCoverage = this.containsCoverage();
        boolean coverageCommitPerformed = containsCoverage && this.commitCoverageData(commitTime);
        boolean bl = isCoverageOutdated = containsCoverage && this.isCoverageOutdatedOrMissing(this.exportMetaData.getToTime());
        if (codeCommitPerformed || clusteredCodeCommitPerformed || coverageCommitPerformed) {
            return UpdateResult.create(isCoverageOutdated, commitTime);
        }
        return UpdateResult.create(isCoverageOutdated);
    }

    private UpdateResult performSynchronisationCommit(BiConsumer<ProjectConnectorStatus.EConnectorStatus, String> updateProcessStatusReporter, List<String> exporterLogMessages) throws GitBridgeException {
        if (!this.zipContainsSources) {
            String message = "Full synchronisation could not proceed because no ABAP source files in " + String.valueOf(this.zipFile) + ". Aborting.";
            LOGGER.error(message);
            updateProcessStatusReporter.accept(ProjectConnectorStatus.EConnectorStatus.ERROR, message);
            return UpdateResult.nothingUpdated();
        }
        LOGGER.info("Synchronizing repository with full export.");
        Set<String> filesToKeep = this.identifyFilesToKeep();
        this.zipImporter.deleteWorkTreeContent(Arrays.asList(COVERAGE_FOLDER_NAME, "objectPaths/"));
        return this.extractArchiveAndPerformCommit(exporterLogMessages, filesToKeep);
    }

    private UpdateResult extractArchiveAndPerformCommit(List<String> exporterLogMessages, Set<String> filesToKeep) throws GitBridgeException {
        List<String> filesInZip = this.extractZip();
        this.zipImporter.replaceWithHead(new ArrayList<String>(filesToKeep));
        this.addFilesFromFullSynchronizationToGit(filesInZip, filesToKeep);
        this.abapFileMetadataManager.createAndAddMetadataFilesToGit(filesInZip, this.objectMetaData);
        try {
            this.workTreeManager.reset();
        }
        catch (InconsistentAbapRepositoryException e) {
            throw new GitBridgeException("Inconsistent ABAP repository detected after refreshing work tree with full synchronisation from " + this.zipFile.getName(), e);
        }
        this.alignCodeInspectorFilesWithAbapFiles(filesToKeep);
        this.zipImporter.update();
        UpdateResult gitOperationResult = this.commitFilesAndCoverage(COMMIT_MESSAGE_SYNCHRONIZATION, exporterLogMessages);
        this.zipImporter.runAutoGarbageCollection();
        return gitOperationResult;
    }

    private Set<String> identifyFilesToKeep() throws GitBridgeException {
        Set<String> filesToKeep = this.zipImporter.getChangedFilesSince(this.exportMetaData.getToTime());
        Set<Object> sciFiles = this.codeInspectorImporter.containsCodeInspectorResults() ? filesToKeep.stream().filter(AbapUtils::isAbapRepositoryObjectFile).map(CodeInspectorGitUtils::buildCodeInspectorFileName).filter(sciFile -> new File(this.zipImporter.getWorkTree(), (String)sciFile).isFile()).collect(Collectors.toSet()) : CollectionUtils.asHashSet((Object[])this.zipImporter.findPathsInWorkTree("**.sci"));
        filesToKeep.addAll(sciFiles);
        return filesToKeep;
    }

    private void addFilesFromFullSynchronizationToGit(List<String> filesInZip, Set<String> filesToKeep) throws GitBridgeException {
        Map keepFilesToAbapElementMap = filesToKeep.stream().filter(AbapUtils::isAbapRepositoryObjectFile).collect(Collectors.toMap(AbapUtils::createElementNameFromPath, Function.identity()));
        ArrayList<String> filesToAdd = new ArrayList<String>();
        for (String fileInZip : filesInZip) {
            String fileToKeep = (String)keepFilesToAbapElementMap.get(AbapUtils.createElementNameFromPath((String)fileInZip));
            if (fileToKeep == null) {
                filesToAdd.add(fileInZip);
                continue;
            }
            if (fileToKeep.equals(fileInZip)) continue;
            try {
                FileSystemUtils.deleteFile((File)new File(this.zipImporter.getWorkTree(), fileInZip));
            }
            catch (IOException e) {
                throw new GitBridgeException("Unable to delete file " + fileInZip + " form work tree. The file is included in full update from " + this.zipFile.getName() + " but was meanwhile moved to " + fileToKeep, e);
            }
        }
        this.add(filesToAdd);
    }

    private void alignCodeInspectorFilesWithAbapFiles(Set<String> sciFiles) throws GitBridgeException {
        for (String sciFile : sciFiles) {
            String actualAbapPath;
            String expectedAbapPath;
            if (!sciFile.endsWith(".sci") || (expectedAbapPath = CodeInspectorGitUtils.buildAbapFileName(sciFile)).equals(actualAbapPath = this.workTreeManager.getWorkTreePathOfAbapFile(expectedAbapPath))) continue;
            if (actualAbapPath == null) {
                this.zipImporter.delete(Collections.singletonList(sciFile), false);
                continue;
            }
            String newSciFile = CodeInspectorGitUtils.buildCodeInspectorFileName(actualAbapPath);
            this.zipImporter.move(sciFile, newSciFile, false);
        }
    }

    private Instant readExportFinishedTime(List<String> exporterLogMessages) {
        if (this.exportMetaData.getExportFinishedTime() != null) {
            return this.exportMetaData.getExportFinishedTime();
        }
        String lastLogLine = exporterLogMessages.getLast();
        Matcher m = EXPORT_FINISHED_DATE_PATTERN.matcher(lastLogLine);
        if (m.matches()) {
            return AbapGitImporterUtils.buildExportLogDate(m.group(1), this.exportMetaData.getTimeZone()).toInstant();
        }
        LOGGER.warn("Unable to retrieve finish time for export, using export date to instead.");
        return this.exportMetaData.getToTime();
    }

    private boolean add(List<String> elementPaths) throws GitBridgeException {
        boolean sourceFilesChanged = this.zipImporter.add(elementPaths);
        if (this.exportMetaData.isFullExport()) {
            boolean sciFilesChanged = this.codeInspectorImporter.updateCodeInspectorResultsFiles(elementPaths);
            return sourceFilesChanged || sciFilesChanged;
        }
        if (sourceFilesChanged) {
            this.codeInspectorImporter.updateCodeInspectorResultsFiles(elementPaths);
        }
        return sourceFilesChanged;
    }

    private UpdateResult performInitialImport(String sapSystemId, List<String> exporterLogMessages) throws GitBridgeException {
        if (!this.exportMetaData.isFullExport()) {
            LOGGER.warn(sapSystemId + ": Initial commit to Git repository does not seem to be a full export.");
        }
        LOGGER.info(sapSystemId + ": Created new git repository at " + this.zipImporter.getWorkTree().getAbsolutePath());
        List<String> elementPaths = this.extractZip();
        this.add(elementPaths);
        this.abapFileMetadataManager.updateMetadataFilesInGitRepo(new ZipToGitImporter.IntroducedGitChanges(elementPaths.stream().toList(), List.of(), Map.of(), false), this.objectMetaData);
        return this.commitFilesAndCoverage(COMMIT_MESSAGE_INITIAL_IMPORT, exporterLogMessages);
    }

    private List<String> extractZip() throws GitBridgeException {
        if (!this.zipContainsSources) {
            return Collections.emptyList();
        }
        return this.workTreeManager.extractZipAndUpdateWorkTreeMap(this.zipFile);
    }

    private BwPathTransformation createBwPathTransformation() throws GitBridgeException {
        List<Map<EBwTransformationFields, String>> transformationRecords = this.parseTableDumpXml(BW_TRANSFORMATIONS_XML, EBwTransformationFields.class, EBwTransformationFields.RSTRAN.name());
        List<Map<EBwDtpFields, String>> dtpRecords = this.parseTableDumpXml(BW_DTPS_XML, EBwDtpFields.class, EBwDtpFields.RSBKDTP.name());
        List<Map<EBwQueryFields, String>> queryRecords = this.parseTableDumpXml(BW_QUERIES_XML, EBwQueryFields.class, EBwQueryFields.RSRREPDIR.name());
        return new BwPathTransformation(transformationRecords, dtpRecords, queryRecords);
    }

    private <E extends Enum<E>> List<Map<E, String>> parseTableDumpXml(String xmlFileName, Class<E> enumClass, String recordTag) throws GitBridgeException {
        if (this.zipFile.getEntry(xmlFileName) == null) {
            return CollectionUtils.emptyList();
        }
        AbapTableDumpXmlHandler<E> handler = new AbapTableDumpXmlHandler<E>(enumClass, recordTag);
        String content = AbapGitImporterUtils.readXmlContent(this.zipFile, xmlFileName);
        try {
            XMLUtils.parseSAX((String)content, handler);
        }
        catch (IOException | SAXException e) {
            throw new GitBridgeException("Unable to parse " + xmlFileName, e);
        }
        return handler.getRecords();
    }

    private Instant getFirstOrLastCommitTime(SortedSet<CommitCluster> commitClusters, boolean first) throws GitBridgeException {
        if (commitClusters.isEmpty()) {
            if (this.zipImporter.getLastCommitTime().isAfter(this.exportMetaData.getToTime())) {
                return this.zipImporter.getLastCommitTime().plusMillis(1L);
            }
            return this.exportMetaData.getToTime();
        }
        if (first) {
            return commitClusters.first().getCommitTime();
        }
        return commitClusters.last().getCommitTime();
    }

    private boolean addAndCommitByCommitClusters(SortedSet<CommitCluster> commitClusters) throws GitBridgeException {
        boolean commitPerformed = false;
        for (CommitCluster commit : commitClusters) {
            List<String> paths = this.workTreeManager.getWorkTreePaths(commit.getElements());
            if (!this.add(paths)) continue;
            this.abapFileMetadataManager.createAndAddMetadataFilesToGit(paths, this.objectMetaData);
            commitPerformed |= this.commit(commit.getCommitInfo(), commit.getCommitTime());
        }
        return commitPerformed;
    }

    private boolean updateDeletionsAndMoves(Instant commitBefore) throws GitBridgeException {
        boolean filesRemoved = this.removeDeletedObjects();
        boolean packagesMoved = this.movePackagePaths();
        Map<String, String> movedElementsFromZipArchive = this.moveElements();
        if (filesRemoved || !movedElementsFromZipArchive.isEmpty() || packagesMoved) {
            ZipToGitImporter.IntroducedGitChanges gitChanges = this.zipImporter.getGitChangesFromSync();
            ZipToGitImporter.IntroducedGitChanges gitChangesWithMoves = new ZipToGitImporter.IntroducedGitChanges(gitChanges.addedAndChangedFiles(), gitChanges.deletedFiles(), movedElementsFromZipArchive, false);
            this.abapFileMetadataManager.updateMetadataFilesInGitRepo(gitChangesWithMoves, this.objectMetaData);
            return this.commit(GENERIC_USER_NAME, commitBefore.minusMillis(1L), COMMIT_MESSAGE_DELETIONS_MOVES);
        }
        return false;
    }

    private boolean containsCoverage() {
        return Collections.list(this.zipFile.getEntries()).stream().map(ZipArchiveEntry::getName).anyMatch(name -> COVERAGE_FILE_NAME_PATTERN.matcher((CharSequence)name).matches());
    }

    private boolean containsCoverageMetaData() {
        return this.zipFile.getEntry(SCOV_COLLECTION_XML) != null;
    }

    private boolean commitObjectPathsUpdate(Instant commitTime) throws GitBridgeException {
        UnmodifiableSet objectTypeNames;
        ListMap objectPathFileEntryNames = new ListMap();
        Enumeration zipFileEntries = this.zipFile.getEntries();
        while (zipFileEntries.hasMoreElements()) {
            String zipEntryName = ((ZipArchiveEntry)zipFileEntries.nextElement()).getName();
            Matcher matcher = OBJECT_PATHS_FILENAME_PATTERN.matcher(zipEntryName);
            if (!matcher.matches()) continue;
            objectPathFileEntryNames.add((Object)matcher.group(1), (Object)zipEntryName);
        }
        File targetDir = new File(this.zipImporter.getWorkTree(), "objectPaths/");
        if (targetDir.exists()) {
            List existingFiles = CollectionUtils.map((Object[])targetDir.listFiles(file -> file.getName().endsWith(".objectpaths")), file -> "objectPaths/" + file.getName());
            this.zipImporter.delete(existingFiles, true);
        }
        if ((objectTypeNames = objectPathFileEntryNames.getKeys()) != null) {
            for (String objectTypeName : objectPathFileEntryNames.getKeys()) {
                String targetFilename = this.concatAndPrepareThirdPartyPathFiles(Objects.requireNonNull((List)objectPathFileEntryNames.getCollection((Object)objectTypeName)), "objectPaths/" + objectTypeName + ".objectpaths");
                this.zipImporter.add(Collections.singletonList(targetFilename));
            }
        }
        return this.commit(GENERIC_USER_NAME, commitTime, "Third-party object paths");
    }

    private String concatAndPrepareThirdPartyPathFiles(List<String> filenames, String targetFilename) throws GitBridgeException {
        File targetFile = new File(this.zipImporter.getWorkTree(), targetFilename);
        try {
            FileSystemUtils.ensureParentDirectoryExists((File)targetFile);
            try (PrintWriter writer = new PrintWriter(targetFile, StandardCharsets.UTF_8);){
                writer.print("Teamscale object name to path format v1.\n");
                writer.print("OBJTYPE;OBJNAME;PATH\n");
                for (String filename : filenames) {
                    ThirdPartyPathsReader.readFromZipAndWriteCsv(filename, this.zipFile, writer);
                    writer.flush();
                }
            }
        }
        catch (IOException e) {
            AbapGitImporter.cleanUpAndThrowException(new GitBridgeException("Failed to write file " + String.valueOf(targetFile), e), targetFile.toPath());
        }
        return targetFilename;
    }

    private boolean commitCoverageData(Instant commitTime) throws GitBridgeException {
        ArrayList<String> coverageEntryNames = new ArrayList<String>();
        Enumeration zipFileEntries = this.zipFile.getEntries();
        while (zipFileEntries.hasMoreElements()) {
            String zipEntryName = ((ZipArchiveEntry)zipFileEntries.nextElement()).getName();
            if (!COVERAGE_FILE_NAME_PATTERN.matcher(zipEntryName).matches()) continue;
            coverageEntryNames.add(zipEntryName);
        }
        List<String> pathsToAdd = this.prepareCoverageFiles(coverageEntryNames);
        this.zipImporter.add(pathsToAdd);
        return this.commit(GENERIC_USER_NAME, commitTime, COMMIT_MESSAGE_COVERAGE);
    }

    private List<String> prepareCoverageFiles(List<String> coverageEntryNames) throws GitBridgeException {
        ArrayList<String> pathsToAdd = new ArrayList<String>();
        for (String coverageEntryName : coverageEntryNames) {
            String partitionName = AbapGitImporter.getPartitionName(coverageEntryName);
            String coverageContent = AbapGitImporterUtils.readXmlContent(this.zipFile, coverageEntryName);
            String path = "coverage/" + partitionName + ".scov";
            File targetFile = new File(this.zipImporter.getWorkTree(), path);
            try {
                FileSystemUtils.ensureParentDirectoryExists((File)targetFile);
                try (PrintWriter writer = new PrintWriter(targetFile, AbapUtils.ABAP_ENCODING);){
                    writer.println(COVERAGE_FILE_ALL_DELTA_OPTION + this.isAllDelta);
                    AbapTraceUtils.readExecutionCounts(coverageContent).entrySet().stream().sorted(Comparator.comparing(entry -> ((ScovIdFeature)entry.getKey()).getMethodKey())).forEach(entry -> writer.println(((ScovIdFeature)entry.getKey()).getMethodKey() + COVERAGE_FILE_COUNT_SEPARATOR + String.valueOf(entry.getValue())));
                    pathsToAdd.add(path);
                }
            }
            catch (IOException e) {
                AbapGitImporter.cleanUpAndThrowException(new GitBridgeException("Failed to write file " + String.valueOf(targetFile), e), targetFile.toPath());
            }
            catch (ConQATException e) {
                AbapGitImporter.cleanUpAndThrowException(new GitBridgeException("Failed to parse file " + coverageEntryName, e), targetFile.toPath());
            }
        }
        return pathsToAdd;
    }

    private static void cleanUpAndThrowException(GitBridgeException gitBridgeException, Path path) throws GitBridgeException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete file: " + String.valueOf(path));
        }
        throw gitBridgeException;
    }

    private static String getPartitionName(String coverageEntryName) {
        Matcher matcher = COVERAGE_FILE_NAME_PATTERN.matcher(coverageEntryName);
        CCSMAssert.isTrue((boolean)matcher.matches(), (String)"Filtered for matching entries before!");
        return StringUtils.isEmptyOrElse((String)matcher.group(1), (String)COVERAGE_DEFAULT_PARTITION);
    }

    private boolean isCoverageOutdatedOrMissing(Instant exportIntervalEndTime) throws GitBridgeException {
        if (!this.containsCoverageMetaData()) {
            LOGGER.warn("No file with coverage metadata was found, therefore it cannot be checked whether the coverage is outdated.");
            return false;
        }
        ZoneOffset timeZone = this.exportMetaData.getTimeZone();
        String scovCollectionMetadata = AbapGitImporterUtils.readXmlContent(this.zipFile, SCOV_COLLECTION_XML);
        ScovCollectionReader reader = new ScovCollectionReader(timeZone);
        reader.readRecords(scovCollectionMetadata);
        Optional<Instant> newestCollectionDate = AbapGitImporter.getLatest(reader.getCollectionDates().stream());
        if (newestCollectionDate.isEmpty() || newestCollectionDate.get().plus(DurationUtils.ONE_HOUR).isBefore(exportIntervalEndTime)) {
            LOGGER.error("Last SCOV collection happened more than one hour ago, SCOV likely became inactive.");
            return true;
        }
        return false;
    }

    private static Optional<Instant> getLatest(Stream<Instant> instants) {
        return instants.sorted().reduce((older, newer) -> newer);
    }

    private boolean commit(String userName, Instant commitTime, String comment) throws GitBridgeException {
        String zipFileName = StringUtils.getLastPart((String)this.zipFile.getName(), (char)File.separatorChar);
        String message = comment + StringUtils.LINE_SEPARATOR + "(" + this.exportMetaData.getSapSystemId().map(s -> "import from " + s + " ").orElse("") + "by " + zipFileName + ").";
        return this.zipImporter.commit(userName, ZipToGitImporterUtils.buildEmail(userName, this.emailDomain, "_"), commitTime, message, false);
    }

    private boolean commit(CommitInfo commitInfo, Instant commitTime) throws GitBridgeException {
        String message = commitInfo.getCommitMessage();
        String sourceSapSystemId = commitInfo.getSapSourceSystem().orElse(null);
        String targetSapSystemId = this.exportMetaData.getSapSystemId().orElse(null);
        if (sourceSapSystemId != null && targetSapSystemId != null && !Objects.equals(sourceSapSystemId, targetSapSystemId)) {
            message = String.format("%s (transport from %s)", message, sourceSapSystemId);
        }
        return this.commit(commitInfo.getUserName(), commitTime, message);
    }

    private boolean removeObjectFromWorkTree(UniqueAbapElementName element) throws GitBridgeException {
        ArrayList<UniqueAbapElementName> elementsToDelete = new ArrayList<UniqueAbapElementName>();
        Set<UniqueAbapElementName> functionGroupIncludesForElement = this.getIncludesForFunctionGroup(element);
        if (!functionGroupIncludesForElement.isEmpty()) {
            elementsToDelete.addAll(functionGroupIncludesForElement);
        } else {
            elementsToDelete.add(element);
        }
        if (element.getObjectType() == EAbapObjectType.CLAS || element.getObjectType() == EAbapObjectType.INTF) {
            elementsToDelete.addAll(this.getClassChildElements(element));
        }
        return this.workTreeManager.removeElementsFromWorkTree(elementsToDelete);
    }

    private Set<UniqueAbapElementName> getIncludesForFunctionGroup(UniqueAbapElementName functionGroup) throws GitBridgeException {
        if (!AbapGitImporter.isFunctionGroupName(functionGroup)) {
            return Collections.emptySet();
        }
        String functionGroupName = functionGroup.getObjectName();
        return this.workTreeManager.getElementsFromWorkTree((element, path) -> {
            if (element.getObjectType() != EAbapObjectType.FUGR) {
                return false;
            }
            ParsedAbapElementPath parsedPath = AbapGitImporterUtils.buildParsedAbapElementPath(path);
            return parsedPath.getFunctionGroup().equals(functionGroupName);
        });
    }

    private static boolean isFunctionGroupName(UniqueAbapElementName elementName) {
        if (elementName.getObjectType() != EAbapObjectType.FUGR) {
            return false;
        }
        String objectNameWithoutNamespace = StringUtils.getLastPart((String)elementName.getObjectName(), (char)'/');
        return !objectNameWithoutNamespace.startsWith("L") && !objectNameWithoutNamespace.startsWith("SAPL");
    }

    private boolean removeDeletedObjects() throws GitBridgeException {
        if (this.zipFile.getEntry("deleted.xml") == null) {
            return false;
        }
        String deletedXml = AbapGitImporterUtils.readXmlContent(this.zipFile, "deleted.xml");
        DeletedElementsReader reader = new DeletedElementsReader(deletedXml);
        List<UniqueAbapElementName> deletedObjects = reader.getDeletedObjects();
        boolean wereFilesDeleted = false;
        for (UniqueAbapElementName elementToDelete : deletedObjects) {
            wereFilesDeleted |= this.removeObjectFromWorkTree(elementToDelete);
        }
        return wereFilesDeleted;
    }

    private Map<String, String> moveElements() throws GitBridgeException {
        if (this.zipFile.getEntry("moved.xml") == null) {
            return Map.of();
        }
        String movedElementsXml = AbapGitImporterUtils.readXmlContent(this.zipFile, "moved.xml");
        HashMap<String, String> movedElements = new HashMap<String, String>();
        MovedElementsReader reader = new MovedElementsReader(movedElementsXml);
        for (ElementMove move : reader.getMoves()) {
            this.moveElement(movedElements, move);
        }
        return movedElements;
    }

    private void moveElement(Map<String, String> movedElements, ElementMove move) throws GitBridgeException {
        UniqueAbapElementName element = move.getElement();
        Set<UniqueAbapElementName> functionGroupIncludesForElement = this.getIncludesForFunctionGroup(element);
        if (!functionGroupIncludesForElement.isEmpty()) {
            for (UniqueAbapElementName includeElement : functionGroupIncludesForElement) {
                Pair<String, String> movedElement = this.workTreeManager.moveElement(move, includeElement);
                if (movedElement == null) continue;
                movedElements.put((String)movedElement.getFirst(), (String)movedElement.getSecond());
            }
        } else {
            Pair<String, String> movedElement = this.workTreeManager.moveElement(move, element);
            if (movedElement != null) {
                movedElements.put((String)movedElement.getFirst(), (String)movedElement.getSecond());
            }
            movedElements.putAll(this.moveClassAdditions(move, element));
        }
    }

    private Map<String, String> moveClassAdditions(ElementMove move, UniqueAbapElementName element) throws GitBridgeException {
        HashMap<String, String> movedElements = new HashMap<String, String>();
        if (element.getObjectType() == EAbapObjectType.CLAS || element.getObjectType() == EAbapObjectType.INTF) {
            for (UniqueAbapElementName classAddition : this.getClassChildElements(element)) {
                Pair<String, String> movedElement = this.workTreeManager.moveElement(move, classAddition);
                if (movedElement == null) continue;
                movedElements.put((String)movedElement.getFirst(), (String)movedElement.getSecond());
            }
        }
        return movedElements;
    }

    private boolean movePackagePaths() throws GitBridgeException {
        if (this.zipFile.getEntry("changed_packages.xml") == null) {
            return false;
        }
        String changedPackagesPathsXml = AbapGitImporterUtils.readXmlContent(this.zipFile, "changed_packages.xml");
        ChangedPackagePathsReader reader = new ChangedPackagePathsReader(changedPackagesPathsXml);
        for (Pair<String, String> fromTo : reader.getFromToPathsList()) {
            String sourcePath = (String)fromTo.getFirst();
            String destinationPath = (String)fromTo.getSecond();
            if (StringUtils.isEmpty((String)sourcePath) || StringUtils.isEmpty((String)destinationPath)) continue;
            this.workTreeManager.movePath(sourcePath, destinationPath);
        }
        return reader.hasChanges();
    }

    private Set<UniqueAbapElementName> getClassChildElements(UniqueAbapElementName classElement) throws GitBridgeException {
        return this.workTreeManager.getElementsFromWorkTree((element, path) -> {
            if (element.getObjectType() != EAbapObjectType.CLAS && element.getObjectType() != EAbapObjectType.INTF || element.equals((Object)classElement)) {
                return false;
            }
            ParsedAbapElementPath parsedPath = AbapGitImporterUtils.buildParsedAbapElementPath(path);
            return parsedPath.getClassName().equals(classElement.getObjectName());
        });
    }

    @Override
    public void close() {
        FileSystemUtils.close((ZipFile)this.zipFile);
        this.zipImporter.close();
    }

    private record SAPExportLog(String severity, String detailedMessages) {
        private static final String ERROR = "ERROR";
        private static final String WARNING = "WARN";

        private boolean hasErrorSeverity() {
            return ERROR.equals(this.severity);
        }
    }
}

