/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;

public class CommitInfo {
    private final String userName;
    private final String transportRequestId;
    private final String transportTaskId;
    private final String transportDescription;

    public CommitInfo(String userName, String transportRequestId, String transportDescription) throws IllegalArgumentException {
        this.userName = userName;
        this.transportRequestId = transportRequestId;
        this.transportTaskId = null;
        this.transportDescription = transportDescription;
    }

    public CommitInfo(String userName, String transportRequestId, String transportTaskId, String transportDescription) throws IllegalArgumentException {
        this.userName = userName;
        this.transportRequestId = transportRequestId;
        this.transportTaskId = transportTaskId;
        this.transportDescription = transportDescription;
    }

    public CommitInfo(String userName) throws IllegalArgumentException {
        this.userName = userName;
        this.transportRequestId = null;
        this.transportTaskId = null;
        this.transportDescription = null;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasTransport() {
        return this.transportRequestId != null;
    }

    public String getCommitMessage() {
        if (!this.hasTransport()) {
            return "Additions/modifications";
        }
        if (StringUtils.isEmpty((String)this.transportDescription)) {
            return this.transportRequestId;
        }
        StringBuilder commitMessageBuilder = new StringBuilder();
        if (this.transportRequestId != null) {
            commitMessageBuilder.append("Request ").append(this.transportRequestId);
        }
        if (this.transportTaskId != null) {
            if (this.transportRequestId != null) {
                commitMessageBuilder.append(" ");
            }
            commitMessageBuilder.append("Task ").append(this.transportTaskId);
        }
        commitMessageBuilder.append(": ");
        commitMessageBuilder.append(this.transportDescription);
        return commitMessageBuilder.toString();
    }

    public Optional<String> getSapSourceSystem() {
        if (this.transportRequestId != null) {
            return Optional.of(StringUtils.getFirstCharacters((String)this.transportRequestId, (int)3));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.transportRequestId + " " + this.transportTaskId + "[" + this.userName + "]";
    }

    public int hashCode() {
        return Objects.hash(this.transportRequestId, this.transportTaskId, this.userName, this.transportDescription);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CommitInfo other = (CommitInfo)obj;
        return Objects.equals(this.userName, other.userName) && Objects.equals(this.transportRequestId, other.transportRequestId) && Objects.equals(this.transportTaskId, other.transportTaskId) && Objects.equals(this.transportDescription, other.transportDescription);
    }
}

