/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.index.resource.issue_reference.IssueReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Index(name="issue-references", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class IssueReferenceIndex
implements IProjectIndex {
    private final ValueIndex<ArrayList<IssueReference>> delegate;
    public static final String INDEX_NAME = "issue-references";

    public IssueReferenceIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable List<IssueReference> getIssueReferences(String uniformPath) throws StorageException {
        return (List)this.delegate.getValue(uniformPath);
    }

    public Map<String, ArrayList<IssueReference>> getIssueReferencesByPaths(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValuesByKeys(uniformPaths);
    }

    public List<@Nullable ArrayList<IssueReference>> getIssueReferences(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public void setOrMergeIssueReferences(PairList<String, ArrayList<IssueReference>> uniformPathsWithIssueReferences, BinaryOperator<ArrayList<IssueReference>> mergeFunction) throws StorageException {
        this.delegate.setOrMergeValues(uniformPathsWithIssueReferences, mergeFunction);
    }

    public void removeIssueReferences(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void setIssueReferences(PairList<String, ArrayList<IssueReference>> issueReferences) throws StorageException {
        this.delegate.setValues(issueReferences);
    }

    public void setIssueReferences(String uniformPath, ArrayList<IssueReference> issueReferences) throws StorageException {
        this.delegate.setValue(uniformPath, issueReferences);
    }

    public List<String> getAllUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }
}

