/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.teamscale;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryCommitMappingIndexBase;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

public class CommitMessageIssueSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    public static final String SUBJECT_PATTERN_PARAMETER = "subject-pattern";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryCommitIssueMappingIndex repositoryCommitIssueMappingIndex;
    @DeltaSource(value=RepositoryCommitIssueMappingIndex.class)
    private KeyDelta repositoryCommitIssueMappingDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueIndex issueIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueHistoryIndex issueHistoryIndex;
    @StepParameter(value="connector-id")
    private String connectorId;
    @StepParameter(value="subject-pattern")
    private String subjectPattern;
    private Pattern compiledSubjectPattern;

    public void execute() throws StorageException {
        List deltaKeys = this.repositoryCommitIssueMappingDelta.getAddedOrChangedKeysAsStrings();
        if (!deltaKeys.isEmpty()) {
            if (!StringUtils.isEmpty((String)this.subjectPattern)) {
                this.compiledSubjectPattern = Pattern.compile(this.subjectPattern, 2);
            }
            this.processDelta(deltaKeys);
        }
    }

    private void processDelta(List<String> deltaKeys) throws StorageException {
        List<TeamscaleIssueId> issueIdKeys = this.getIssueIdsFromDeltaKeys(deltaKeys);
        List storedIssues = this.issueIndex.getIssues(issueIdKeys);
        SetMap<TeamscaleIssueId, CommitDescriptor> issueIdToCommit = this.repositoryCommitIssueMappingIndex.getCommitsForIssues(issueIdKeys);
        HashMap<TeamscaleIssueId, TeamscaleIssue> issuesById = new HashMap<TeamscaleIssueId, TeamscaleIssue>();
        PairList timestampAndIssues = new PairList();
        for (int i = 0; i < issueIdKeys.size(); ++i) {
            TeamscaleIssue issue = (TeamscaleIssue)storedIssues.get(i);
            TeamscaleIssueId issueId = issueIdKeys.get(i);
            ArrayList sortedIssueCommits = CollectionUtils.sort((Collection)issueIdToCommit.getCollection((Object)issueId));
            if (issue == null) {
                CommitDescriptor oldestCommit = (CommitDescriptor)sortedIssueCommits.get(0);
                issue = this.createIssue(issueId, oldestCommit);
            } else {
                CommitDescriptor latestCommit = (CommitDescriptor)sortedIssueCommits.get(sortedIssueCommits.size() - 1);
                issue.setUpdated(latestCommit.getTimestamp());
            }
            issuesById.put(issueId, issue);
            timestampAndIssues.add((Object)issue.getUpdated(), (Object)issue);
        }
        this.issueIndex.setIssues(issuesById.values());
        this.issueHistoryIndex.store(timestampAndIssues);
    }

    private TeamscaleIssue createIssue(TeamscaleIssueId issueId, CommitDescriptor oldestCommit) throws StorageException {
        RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(oldestCommit);
        if (repositoryLogEntry != null) {
            return new TeamscaleIssue(issueId, oldestCommit.getTimestamp(), repositoryLogEntry.getAuthor(), this.extractIssueSubject(repositoryLogEntry.getMessage()));
        }
        return new TeamscaleIssue(issueId, oldestCommit.getTimestamp());
    }

    private String extractIssueSubject(String commitMessage) {
        if (commitMessage == null || this.compiledSubjectPattern == null) {
            return "";
        }
        Matcher matcher = this.compiledSubjectPattern.matcher(commitMessage);
        if (matcher.find()) {
            return StringUtils.emptyIfNull((String)matcher.group(1));
        }
        return "";
    }

    private List<TeamscaleIssueId> getIssueIdsFromDeltaKeys(List<String> deltaKeys) {
        String idKeyPrefix = StringUtils.bytesToString((byte[])RepositoryCommitMappingIndexBase.ID_KEY_PREFIX);
        ArrayList<TeamscaleIssueId> result = new ArrayList<TeamscaleIssueId>();
        for (String deltaKey : deltaKeys) {
            String internalId;
            TeamscaleIssueId issueId;
            if (!deltaKey.startsWith(idKeyPrefix) || !this.connectorId.equals((issueId = TeamscaleIssueId.fromInternalId((String)(internalId = StringUtils.stripPrefix((String)deltaKey, (String)idKeyPrefix)))).getConnectorId())) continue;
            result.add(issueId);
        }
        return result;
    }
}

