/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.FirstCodeCommitIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.committree.AdjustAllCommits;
import com.teamscale.index.requirements_tracing.index.SpecItemChangesIndex;
import com.teamscale.wia.TeamscaleIssue;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS, EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class IssueRepositoryUpdater<T extends TeamscaleIssue>
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="single-specitemchanges")
    protected SpecItemChangesIndex changeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected ProjectRepositoryChangeIndex projectRepositoryChangeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="commit-tree")
    protected CommitTreeIndex commitTreeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogFileIndex repositoryLogFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FirstCodeCommitIndex firstCodeCommitIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TimestampAdjustmentIndex timestampAdjustmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    @DeltaSource(value=SpecItemChangesIndex.class, indexName="single-specitemchanges")
    protected KeyDelta changeDelta;
    @StepParameter(value="connector-id")
    protected String connectorId;

    public void execute() throws Exception {
        List<RepositoryChangeEntry> changes = this.changeIndex.getEntriesForCommit(this.getSchedulingCommit());
        CommitTree commitTree = this.updateCommitTree();
        this.updateRepositoryChangeIndex(changes, commitTree);
        this.updateRepositoryLogIndex(changes);
        this.updateRepositoryLogFileIndex(changes);
        this.updateFirstCodeCommitIndex();
    }

    private void updateFirstCodeCommitIndex() throws StorageException {
        this.firstCodeCommitIndex.insertCodeCommit(this.getSchedulingCommit());
    }

    private void updateRepositoryLogFileIndex(List<RepositoryChangeEntry> changes) throws StorageException {
        this.repositoryLogFileIndex.insertEntries(CollectionUtils.map(changes, this::toRepositoryLogFileEntry));
    }

    private @NonNull RepositoryLogFileEntry toRepositoryLogFileEntry(RepositoryChangeEntry change) {
        return new RepositoryLogFileEntry(this.getSchedulingCommit(), change.getRepositoryPath(), ECommitType.CODE_COMMIT, EExternalAnalysisResultType.ISSUES, IssueRepositoryUpdater.isDeletion(change));
    }

    private static boolean isDeletion(RepositoryChangeEntry change) {
        return change.getChangeType() == ERepositoryChangeType.DELETE;
    }

    private void updateRepositoryLogIndex(List<RepositoryChangeEntry> changes) throws StorageException {
        this.repositoryLogIndex.setEntry(this.buildRepositoryLogEntry(changes));
    }

    private void updateRepositoryChangeIndex(List<RepositoryChangeEntry> changes, CommitTree commitTree) throws StorageException {
        this.projectRepositoryChangeIndex.addChangedFiles(changes);
        this.projectRepositoryChangeIndex.mergeCommitTree(commitTree, this.projectMetaIndex.getDefaultBranchName(), this.connectorId);
    }

    private CommitTree updateCommitTree() throws StorageException {
        CommitTree commitTree = this.commitTreeIndex.loadTree();
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        List<CommitTreeRevision> parentCommits = IssueRepositoryUpdater.getParentCommits(commitTree, schedulingCommit.getBranchName());
        commitTree.addNode(this.toCommitTreeRevision(schedulingCommit), schedulingCommit.getTimestamp(), parentCommits);
        commitTree.setLiveBranchNames(Collections.singleton(schedulingCommit.getBranchName()));
        this.updateCommitStatus(commitTree);
        commitTree.persist();
        return commitTree;
    }

    private static @NonNull List<CommitTreeRevision> getParentCommits(CommitTree commitTree, String branchName) {
        return commitTree.getLatestContainedRevisionForBranch(branchName).map(revision -> new CommitTreeRevision(revision, branchName)).map(List::of).orElseGet(Collections::emptyList);
    }

    private @NonNull CommitTreeRevision toCommitTreeRevision(CommitDescriptor schedulingCommit) {
        return new CommitTreeRevision(this.getRevision(schedulingCommit), schedulingCommit.getBranchName());
    }

    private void updateCommitStatus(CommitTree commitTree) throws StorageException {
        AdjustAllCommits commitTreeNodeAdjuster = new AdjustAllCommits(this.timestampAdjustmentIndex);
        commitTreeNodeAdjuster.adjustTimestamps(commitTree.getAllRawNodes());
        for (CommitTreeNode node : commitTree.getAllNodes()) {
            if (node.getOriginalTimestamp() > this.getSchedulingCommit().getTimestamp() || !node.isSchedulable()) continue;
            node.setScheduled();
            node.setProcessed();
        }
    }

    private @NonNull RepositoryLogEntry buildRepositoryLogEntry(List<RepositoryChangeEntry> changes) {
        int added = 0;
        int deleted = 0;
        int changed = 0;
        block5: for (RepositoryChangeEntry change : changes) {
            switch (change.getChangeType()) {
                case ADD: {
                    ++added;
                    continue block5;
                }
                case DELETE: {
                    ++deleted;
                    continue block5;
                }
                case EDIT: {
                    ++changed;
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unsupported change type: %s".formatted(new Object[]{change.getChangeType()}));
        }
        return new RepositoryLogEntry(this.getRevision(this.getSchedulingCommit()), this.getSchedulingCommit(), "Work Item update", "Teamscale", added, changed, deleted, this.connectorId, ECommitType.CODE_COMMIT);
    }

    private @NonNull String getRevision(CommitDescriptor commit) {
        return String.valueOf(commit.getTimestamp());
    }
}

