/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.voting;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.merge_request.voting.VotingRecord;
import java.util.EnumSet;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class VotingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final VotingRecord record;

    private VotingException(VotingRecord record) {
        this(record, null);
    }

    private VotingException(VotingRecord record, Throwable e) {
        super(record.getComment(), e);
        this.record = record;
    }

    public VotingRecord getRecord() {
        return this.record;
    }

    public static class Skipped
    extends VotingException {
        private static final long serialVersionUID = 2L;
        private final Reason reason;

        public Skipped(String comment, Reason reason, @Nullable CommitDescriptor commit) {
            super(VotingRecord.skipped(commit, comment));
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public static Skipped noLongerExists(@NonNull MergeRequestIdentifier mergeRequestIdentifier, @Nullable CommitDescriptor commit) {
            return new Skipped("Merge request '" + String.valueOf(mergeRequestIdentifier) + "' no longer exists.", Reason.NO_LONGER_EXISTS, commit);
        }

        public static Skipped notOpen(@NonNull MergeRequestIdentifier mergeRequestIdentifier, @Nullable CommitDescriptor commit) {
            return new Skipped("Merge request " + String.valueOf(mergeRequestIdentifier) + " is no longer open.", Reason.NOT_OPEN, commit);
        }

        public static Skipped irrelevantCommit(@NonNull CommitDescriptor commit) {
            return new Skipped("Commit '" + String.valueOf(commit) + "' is not relevant or on an ignored branch.", Reason.COMMIT_NOT_RELEVANT, commit);
        }

        public static VotingException targetBranchIsExcludedFromVoting(@NonNull MergeRequestIdentifier mergeRequestIdentifier, @Nullable CommitDescriptor commit) {
            return new Skipped("Target branch for merge request " + String.valueOf(mergeRequestIdentifier) + " is vote excluded.", Reason.TARGET_BRANCH_EXCLUDED_FROM_VOTING, commit);
        }

        public static Skipped moreRecentCommitsOnBranch(@NonNull CommitDescriptor commit) {
            return new Skipped("There are more recent commits on branch '" + commit.getBranchName() + "'.", Reason.MORE_RECENT_COMMITS, commit);
        }

        public static Skipped repositoryLogEntryMissing(@NonNull CommitDescriptor commit) {
            return new Skipped("Repository log entry for commit '" + String.valueOf(commit) + "' was not found, i.e., the commit was not analyzed and no analysis for this commit is currently queued or in progress.", Reason.REPOSITORY_LOG_ENTRY_MISSING, commit);
        }

        public static Skipped noMergeRequestExists(@Nullable CommitDescriptor commit) {
            return new Skipped("Commit '" + String.valueOf(commit) + "' is not the head commit of any existing merge request known to Teamscale.", Reason.NO_MERGE_REQUEST_EXISTS, commit);
        }

        public static Skipped shadowModeEnabled(@Nullable CommitDescriptor commit) {
            return new Skipped("Skipping voting for commit '" + String.valueOf(commit) + "' as shadow mode is active.", Reason.SHADOW_MODE_ENABLED, commit);
        }

        public static Skipped alreadyVoted(@NonNull CommitDescriptor commit) {
            return new Skipped("Skipping voting for commit '" + String.valueOf(commit) + "' as we already voted and a re-vote was not required.", Reason.ALREADY_VOTED, commit);
        }

        public static Skipped waitingForRelevantBuildJobs(@NonNull CommitDescriptor commit) {
            return new Skipped("Skipping voting for commit '" + String.valueOf(commit) + "' as we are still waiting for relevant build jobs.", Reason.WAITING_FOR_RELEVANT_BUILD_JOBS, commit);
        }

        public static Skipped integrationDisabled(@Nullable CommitDescriptor commit, ConnectorConfiguration connector) {
            return new Skipped("Skipping voting for commit " + String.valueOf(commit) + " as no integration (findings, test gap, or commit alerts) is enabled!\nConnector details: " + JsonUtils.serializeToJSON((Object)connector), Reason.INTEGRATION_DISABLED, commit);
        }

        public static Skipped notYetAnalyzed(@NonNull CommitDescriptor commit) {
            return new Skipped("Skipping voting for commit " + String.valueOf(commit) + " as we are not in a voting relevant analysis state.", Reason.NOT_YET_ANALYZED, commit);
        }

        public static Skipped commitIsFromOtherRepository(@NonNull CommitDescriptor commit, ConnectorConfiguration connector) {
            return new Skipped("Skipping voting for commit '" + String.valueOf(commit) + "' as the code commit is from a different repository than '" + connector.getIdentifier() + "'.", Reason.COMMIT_FROM_OTHER_REPOSITORY, commit);
        }

        public static Skipped waitingForExternalUploads(@NonNull CommitDescriptor commit) {
            return new Skipped("Skipping voting for commit '" + String.valueOf(commit) + "' as external uploads are still missing.", Reason.WAITING_FOR_EXTERNAL_UPLOADS, commit);
        }

        public static Skipped excludedViaJvmFlag(long pullRequestId, @NonNull CommitDescriptor commit) {
            return new Skipped("Skipping voting for pull request '" + pullRequestId + "' as this pull request was excluded by an administrator via the Teamscale configuration.", Reason.EXCLUDED_VIA_JVM_FLAG, commit);
        }

        public static enum Reason {
            NO_LONGER_EXISTS,
            NOT_OPEN,
            COMMIT_NOT_RELEVANT,
            TARGET_BRANCH_EXCLUDED_FROM_VOTING,
            MORE_RECENT_COMMITS,
            REPOSITORY_LOG_ENTRY_MISSING,
            NO_MERGE_REQUEST_EXISTS,
            SHADOW_MODE_ENABLED,
            ALREADY_VOTED,
            WAITING_FOR_RELEVANT_BUILD_JOBS,
            INTEGRATION_DISABLED,
            NOT_YET_ANALYZED,
            COMMIT_FROM_OTHER_REPOSITORY,
            WAITING_FOR_EXTERNAL_UPLOADS,
            GERRIT_SPECIFIC_NOT_A_GERRIT_BRANCH,
            GERRIT_SPECIFIC_MERGED_OR_ABANDONED,
            GERRIT_SPECIFIC_EMPTY_COMMIT_AND_NO_COMMENTS,
            GERRIT_SPECIFIC_CHANGE_DOES_NOT_AFFECT_INCLUDED_FILES,
            EXCLUDED_VIA_JVM_FLAG;

            @VisibleForTesting
            static final EnumSet<Reason> REASONS_TO_REPORT;

            public boolean shouldBeRecorded() {
                return REASONS_TO_REPORT.contains((Object)this);
            }

            static {
                REASONS_TO_REPORT = EnumSet.of(NO_LONGER_EXISTS, new Reason[]{NOT_OPEN, COMMIT_NOT_RELEVANT, MORE_RECENT_COMMITS, REPOSITORY_LOG_ENTRY_MISSING, NO_MERGE_REQUEST_EXISTS, GERRIT_SPECIFIC_CHANGE_DOES_NOT_AFFECT_INCLUDED_FILES, GERRIT_SPECIFIC_NOT_A_GERRIT_BRANCH, GERRIT_SPECIFIC_MERGED_OR_ABANDONED, GERRIT_SPECIFIC_EMPTY_COMMIT_AND_NO_COMMENTS, SHADOW_MODE_ENABLED});
            }
        }
    }

    public static class Error
    extends VotingException {
        private static final long serialVersionUID = 1L;

        public Error(CommitDescriptor commit, String comment) {
            super(VotingRecord.error(commit, comment));
        }

        public Error(CommitDescriptor commit, String comment, Throwable e) {
            super(VotingRecord.error(commit, comment), e);
        }

        public Error(CommitDescriptor commit, Throwable e) {
            super(VotingRecord.error(commit, e.getMessage()), e);
        }
    }
}

