/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.finding;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.migration.finding.ConfigurationOptionDeletion;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.core.registry.OptionMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.jetbrains.annotations.VisibleForTesting;

public class DataDrivenFindingMigration
implements IJsonMigration {
    public static final String CHECK_MAPPINGS_MIGRATION_FILE_PREFIX = "check-mappings.v";
    private static final String CHECK_MAPPINGS_RENAME_MIGRATION_FILE_PREFIX = "check-mappings-rename-only.v";
    public static final String OPTION_MAPPING_MIGRATION_FILE_PREFIX = "option-mapping.v";
    public static final String INTERNAL_CHECKS_MIGRATIONS_LOCATION = "/META-INF/migrations/internal-checks/";
    private final List<IJsonMigration> jsonMigrations = new ArrayList<IJsonMigration>();

    private DataDrivenFindingMigration(PairList<CheckMapping, CheckMapping> changedMappings, ListMap<String, OptionMapping> optionMappings, boolean useFindingIds) {
        for (Pair changedMapping : changedMappings) {
            this.addMigrations((Pair<CheckMapping, CheckMapping>)changedMapping, optionMappings, useFindingIds);
        }
    }

    private void addMigrations(Pair<CheckMapping, CheckMapping> changedMapping, ListMap<String, OptionMapping> optionMappings, boolean useFindingIds) {
        CheckMapping oldMapping = (CheckMapping)changedMapping.getFirst();
        CheckMapping newMapping = (CheckMapping)changedMapping.getSecond();
        List checkOptionMappings = (List)optionMappings.getCollectionOrEmpty((Object)oldMapping.checkId);
        String oldCheck = oldMapping.getReadableCheckName();
        String newCheck = newMapping.getReadableCheckName();
        if (useFindingIds) {
            oldCheck = oldMapping.checkId;
            newCheck = newMapping.checkId;
        }
        if (newMapping.defaultEnablement == null) {
            this.jsonMigrations.add(new ConfigurationOptionDeletion(oldCheck, oldMapping.group));
            checkOptionMappings.forEach(mapping -> this.jsonMigrations.add(new ConfigurationOptionDeletion(mapping.optionName, oldMapping.group)));
        } else {
            this.jsonMigrations.add(new ConfigurationOptionReplacement(oldCheck, oldMapping.group, newCheck, newMapping.group));
            checkOptionMappings.forEach(mapping -> this.jsonMigrations.add(new ConfigurationOptionReplacement(mapping.optionName, oldMapping.group, mapping.optionName, newMapping.group)));
        }
    }

    public void migrateJson(ObjectNode json) {
        for (IJsonMigration migration : this.jsonMigrations) {
            migration.migrateJson(json);
        }
    }

    public static DataDrivenFindingMigration migrateQualityIndicatorAndCategory(Class<?> context, String basePath, int oldVersion, boolean useFindingIds) {
        Resource oldMappingsResources = Resource.of(context, (String)(basePath + CHECK_MAPPINGS_MIGRATION_FILE_PREFIX + oldVersion + ".tsv"));
        Resource oldOptionsMappingResource = Resource.asOptional(context, (String)(basePath + OPTION_MAPPING_MIGRATION_FILE_PREFIX + oldVersion + ".tsv")).orElse(null);
        Resource newMappingsResources = Resource.of(context, (String)(basePath + CHECK_MAPPINGS_MIGRATION_FILE_PREFIX + (oldVersion + 1) + ".tsv"));
        return DataDrivenFindingMigration.migrateQualityIndicatorAndCategory(oldMappingsResources, oldOptionsMappingResource, newMappingsResources, useFindingIds);
    }

    public static List<IJsonMigration> migrateFromReadableNameToIds(Class<?> context, String basePath, int version) {
        Resource checkMappingsResources = Resource.of(context, (String)(basePath + CHECK_MAPPINGS_RENAME_MIGRATION_FILE_PREFIX + version + ".tsv"));
        Map checkMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)checkMappingsResources);
        return CollectionUtils.map(checkMappings.values(), mapping -> new ConfigurationOptionReplacement(mapping.getReadableCheckName(), mapping.group, mapping.checkId, mapping.group));
    }

    @VisibleForTesting
    static DataDrivenFindingMigration migrateQualityIndicatorAndCategory(Resource oldMappingsResources, Resource oldOptionsMappingResource, Resource newMappingsResources, boolean useFindingIds) {
        Map oldMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)oldMappingsResources);
        Map newMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)newMappingsResources);
        ListMap oldOptionMappings = new ListMap();
        if (oldOptionsMappingResource != null) {
            oldOptionMappings = OptionMapping.readMappingsFromTsv((Resource)oldOptionsMappingResource);
        }
        return new DataDrivenFindingMigration(DataDrivenFindingMigration.determineChangedMappings(oldMappings, newMappings), (ListMap<String, OptionMapping>)oldOptionMappings, useFindingIds);
    }

    @VisibleForTesting
    static PairList<CheckMapping, CheckMapping> determineChangedMappings(Map<String, CheckMapping> oldMappings, Map<String, CheckMapping> newMappings) {
        PairList changedMappings = new PairList();
        for (Map.Entry<String, CheckMapping> oldMappingEntry : oldMappings.entrySet()) {
            String checkId = oldMappingEntry.getKey();
            CheckMapping oldMapping = oldMappingEntry.getValue();
            CheckMapping newMapping = newMappings.get(checkId);
            Preconditions.checkState((newMapping != null ? 1 : 0) != 0, (Object)("There is an old mapping for check " + checkId + " that is missing in the new version. If the check has been removed also remove the entry from the previous mapping file."));
            if (oldMapping.group.equals(newMapping.group) && !DataDrivenFindingMigration.isCheckIgnoredInNewMapping(oldMapping, newMapping)) continue;
            changedMappings.add((Object)oldMapping, (Object)newMapping);
        }
        return changedMappings;
    }

    private static boolean isCheckIgnoredInNewMapping(CheckMapping oldMapping, CheckMapping newMapping) {
        return oldMapping.defaultEnablement != newMapping.defaultEnablement && newMapping.defaultEnablement == null;
    }

    public List<IJsonMigration> getInnerMigrations() {
        return CollectionUtils.asUnmodifiable(this.jsonMigrations);
    }
}

