/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.finding;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigration;

public class GlobalOptionReplacement
implements IJsonMigration {
    private static final String OPTIONS = "options";
    private final String oldOptionName;
    private final String newOptionName;

    public GlobalOptionReplacement(String oldOptionName, String newOptionName) {
        this.oldOptionName = oldOptionName;
        this.newOptionName = newOptionName;
    }

    public void migrateJson(ObjectNode analysisProfile) {
        ObjectNode options = (ObjectNode)analysisProfile.get(OPTIONS);
        if (!options.has(this.oldOptionName)) {
            return;
        }
        JsonNode optionValue = options.get(this.oldOptionName);
        options.remove(this.oldOptionName);
        options.set(this.newOptionName, optionValue);
    }

    public String getOldOptionName() {
        return this.oldOptionName;
    }

    public String getNewOptionName() {
        return this.newOptionName;
    }
}

