/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v88_project_alias;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.index.migration.v88_project_alias.V89CommitGranularityConfiguration;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationUnmigrated;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class V89ProjectConfigurationMigrated
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String PUBLIC_IDS_PROPERTY = "publicIds";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String PROFILE_PROPERTY = "profile";
    private static final String EMBEDDED_PROFILE_PROPERTY = "embeddedProfile";
    private static final String METRIC_THRESHOLD_CONFIGURATION_PROPERTY = "metricThresholdConfiguration";
    private static final String ANALYSIS_GRANULARITY_PROPERTY = "analysisGranularity";
    private static final String CONNECTORS_PROPERTY = "connectors";
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="internalId")
    InternalProjectId internalId;
    @JsonProperty(value="publicIds")
    List<PublicProjectId> publicIds;
    @JsonProperty(value="parentProjectId")
    @Nullable PublicProjectId parentProjectId;
    @JsonProperty(value="description")
    @Nullable String description;
    @JsonProperty(value="profile")
    String profile;
    @JsonProperty(value="embeddedProfile")
    @Nullable AnalysisProfile embeddedProfile;
    @JsonProperty(value="metricThresholdConfiguration")
    @Nullable MetricThresholdConfiguration metricThresholdConfiguration;
    @JsonProperty(value="analysisGranularity")
    @Nullable V89CommitGranularityConfiguration analysisGranularity;
    @JsonProperty(value="connectors")
    List<ConnectorConfiguration> connectors = new ArrayList<ConnectorConfiguration>();

    @JsonCreator
    public V89ProjectConfigurationMigrated(@JsonProperty(value="name") String name, @JsonProperty(value="internalId") String internalId, @JsonProperty(value="publicIds") List<String> publicIds, @JsonProperty(value="profile") String profile) {
        this.name = name;
        if (StringUtils.isEmpty((String)internalId) || internalId.equals("Not yet assigned")) {
            internalId = UUID.randomUUID().toString();
        }
        this.internalId = new InternalProjectId(internalId);
        this.setPublicIds(PublicProjectId.of(publicIds));
        this.profile = profile;
    }

    public V89ProjectConfigurationMigrated(V89ProjectConfigurationUnmigrated unmigrated) {
        this(unmigrated, InternalProjectId.create());
    }

    public V89ProjectConfigurationMigrated(V89ProjectConfigurationUnmigrated unmigrated, InternalProjectId internalProjectId) {
        this.name = unmigrated.name;
        this.internalId = internalProjectId;
        this.publicIds = new ArrayList<PublicProjectId>();
        if (CollectionUtils.isNullOrEmpty(unmigrated.aliases) && !StringUtils.isEmpty((String)unmigrated.alias)) {
            unmigrated.aliases = List.of(unmigrated.alias);
        }
        if (unmigrated.aliases != null) {
            this.publicIds.addAll(PublicProjectId.of(unmigrated.aliases));
        }
        if (unmigrated.aliases == null || !unmigrated.aliases.contains(unmigrated.id)) {
            this.publicIds.add(new PublicProjectId(unmigrated.id));
        }
        this.parentProjectId = StringUtils.isEmpty((String)unmigrated.parentProjectId) ? null : new PublicProjectId(unmigrated.parentProjectId);
        this.description = unmigrated.description;
        this.profile = unmigrated.profile;
        this.embeddedProfile = unmigrated.embeddedProfile;
        this.metricThresholdConfiguration = unmigrated.metricThresholdConfiguration;
        this.analysisGranularity = unmigrated.analysisGranularity;
        this.connectors.addAll(unmigrated.connectors);
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        Preconditions.checkState((!CollectionUtils.isNullOrEmpty(publicIds) ? 1 : 0) != 0, (Object)"At least one public ID needs to be provided.");
        this.publicIds = publicIds;
    }
}

