/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v88_project_alias;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoUnmigrated;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class V89ProjectInfoMigrated
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String NAME_PROPERTY = "name";
    private static final String PUBLIC_IDS_PROPERTY = "publicIds";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CREATION_TIMESTAMP_PROPERTY = "creationTimestamp";
    @JsonProperty(value="internalId")
    InternalProjectId internalId;
    @JsonProperty(value="publicIds")
    List<PublicProjectId> publicIds;
    @JsonProperty(value="parentProjectId")
    @Nullable InternalProjectId parentProjectId;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="description")
    @Nullable String description;
    @JsonProperty(value="creationTimestamp")
    long creationTimestamp;
    @JsonProperty(value="deleting")
    boolean deleting = false;
    @JsonProperty(value="reanalyzing")
    boolean reanalyzing = false;
    @JsonProperty(value="copyingData")
    boolean copyingData = false;

    @JsonCreator
    public V89ProjectInfoMigrated(@JsonProperty(value="internalId") InternalProjectId internalId, @JsonProperty(value="name") String name, @JsonProperty(value="publicIds") List<PublicProjectId> publicIds, @JsonProperty(value="parentProjectId") InternalProjectId parentProjectId, @JsonProperty(value="description") String description, @JsonProperty(value="creationTimestamp") long creationTimestamp) {
        this.internalId = internalId;
        this.setPublicIds(publicIds);
        this.name = name;
        this.parentProjectId = parentProjectId;
        this.description = description;
        this.creationTimestamp = creationTimestamp;
    }

    public V89ProjectInfoMigrated(V89ProjectInfoUnmigrated unmigrated, ProjectIndex projectIndex) throws StorageException {
        List projectIds;
        this.internalId = InternalProjectId.create();
        if (CollectionUtils.isNullOrEmpty(unmigrated.aliases) && !StringUtils.isEmpty((String)unmigrated.alias)) {
            unmigrated.aliases = List.of(unmigrated.alias);
        }
        if (!(projectIds = (List)Optional.ofNullable(unmigrated.aliases).map(ArrayList::new).orElseGet(ArrayList::new)).contains(unmigrated.id)) {
            projectIds.add(unmigrated.id);
        }
        this.setPublicIds(PublicProjectId.of((List)projectIds));
        this.name = unmigrated.name;
        this.parentProjectId = StringUtils.isEmpty((String)unmigrated.parentProjectId) ? null : projectIndex.resolveToInternalId((IProjectId)this.parentProjectId);
        this.description = unmigrated.description;
        this.creationTimestamp = unmigrated.creationTimestamp;
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        Preconditions.checkState((!CollectionUtils.isNullOrEmpty(publicIds) ? 1 : 0) != 0, (Object)"At least one public ID needs to be provided.");
        this.publicIds = publicIds;
    }
}

