/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring.prometheus;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.index.monitoring.prometheus.PrometheusMetricsOption;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class PrometheusMetricsExportUtils {
    private static final String METRICS_LABEL_INSTANCE_NAME = "instance_name";
    private static final String METRICS_LABEL_SHADOW_MODE = "shadow_mode";

    public static String writePrometheusMetrics(ExpositionFormatWriter writer, String instanceName, ServerOptionIndex serverOptionIndex) throws StorageException {
        MetricSnapshots metrics = PrometheusRegistry.defaultRegistry.scrape();
        PrometheusMetricsOption metricsOption = (PrometheusMetricsOption)ServerOptionRegistry.getInstance().getServerOption("prometheus-metrics", PrometheusMetricsOption.class, serverOptionIndex);
        boolean shadowModeEnabled = ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)serverOptionIndex);
        return PrometheusMetricsExportUtils.writePrometheusMetrics(writer, instanceName, shadowModeEnabled, metricsOption.prefix, metrics);
    }

    private static String writePrometheusMetrics(ExpositionFormatWriter writer, String instanceName, boolean shadowModeEnabled, @Nullable String prefix, MetricSnapshots metrics) throws StorageException {
        String string;
        metrics = PrometheusMetricsExportUtils.patchMetrics(metrics, instanceName, shadowModeEnabled, prefix);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            writer.write((OutputStream)outputStream, metrics);
            string = outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException("Could not write metrics.", (Throwable)e);
            }
        }
        outputStream.close();
        return string;
    }

    private static MetricSnapshots patchMetrics(MetricSnapshots metrics, String instanceName, boolean shadowModeEnabled, @Nullable String prefix) {
        List patchedMetrics = metrics.stream().map(PrometheusMetricsExportUtils.addMissingDefaultLabels(instanceName, shadowModeEnabled)).map(PrometheusMetricsExportUtils.addPrefix(prefix)).toList();
        return new MetricSnapshots(patchedMetrics);
    }

    private static UnaryOperator<MetricSnapshot> addPrefix(@Nullable String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            return UnaryOperator.identity();
        }
        return metricFamilySamples -> PrometheusMetricsExportUtils.rewriteMetricsFamilySamples(metricFamilySamples, UnaryOperator.identity(), family -> PrometheusMetricsExportUtils.metricSnapshotWithNewData(family, PrometheusMetricsExportUtils.addPrefixToMetadata(family.getMetadata(), prefix), family.getDataPoints()));
    }

    private static MetricMetadata addPrefixToMetadata(MetricMetadata metadata, @Nullable String prefix) {
        return new MetricMetadata(StringUtils.ensureStartsWith((String)metadata.getName(), (String)prefix), metadata.getHelp(), metadata.getUnit());
    }

    private static UnaryOperator<MetricSnapshot> addMissingDefaultLabels(String instanceName, boolean shadowModeEnabled) {
        PairList<String, String> defaultLabels = PrometheusMetricsExportUtils.getDefaultLabels(instanceName, shadowModeEnabled);
        return metric -> PrometheusMetricsExportUtils.rewriteMetricsFamilySamples(metric, sample -> PrometheusMetricsExportUtils.rewriteDataPointSnapshot(sample, defaultLabels), UnaryOperator.identity());
    }

    private static MetricSnapshot rewriteMetricsFamilySamples(MetricSnapshot original, UnaryOperator<DataPointSnapshot> sampleRewriter, UnaryOperator<MetricSnapshot> familyRewriter) {
        ArrayList<DataPointSnapshot> samples = new ArrayList<DataPointSnapshot>(original.getDataPoints().size());
        for (DataPointSnapshot sample : original.getDataPoints()) {
            samples.add((DataPointSnapshot)sampleRewriter.apply(sample));
        }
        return (MetricSnapshot)familyRewriter.apply(PrometheusMetricsExportUtils.metricSnapshotWithNewData(original, original.getMetadata(), samples));
    }

    private static MetricSnapshot metricSnapshotWithNewData(MetricSnapshot original, MetricMetadata metadata, List<? extends DataPointSnapshot> samples) {
        if (original instanceof CounterSnapshot) {
            return new CounterSnapshot(metadata, samples);
        }
        if (original instanceof HistogramSnapshot) {
            return new HistogramSnapshot(metadata, samples);
        }
        if (original instanceof SummarySnapshot) {
            return new SummarySnapshot(metadata, samples);
        }
        if (original instanceof GaugeSnapshot) {
            return new GaugeSnapshot(metadata, samples);
        }
        if (original instanceof UnknownSnapshot) {
            return new UnknownSnapshot(metadata, samples);
        }
        if (original instanceof StateSetSnapshot) {
            return new StateSetSnapshot(metadata, samples);
        }
        if (original instanceof InfoSnapshot) {
            return new InfoSnapshot(metadata, samples);
        }
        throw new UnsupportedOperationException("Could not rewrite snapshot of class " + String.valueOf(original.getClass()));
    }

    private static DataPointSnapshot rewriteDataPointSnapshot(DataPointSnapshot original, PairList<String, String> defaultLabels) {
        PairList toAdd = new PairList();
        for (Pair labelPair : defaultLabels) {
            if (original.getLabels().contains((String)labelPair.getFirst())) continue;
            toAdd.add(labelPair);
        }
        Labels newLabels = Labels.of((List)toAdd.extractFirstList(), (List)toAdd.extractSecondList()).merge(original.getLabels());
        return PrometheusMetricsExportUtils.dataPointSnapshotWithNewLabels(original, newLabels);
    }

    private static DataPointSnapshot dataPointSnapshotWithNewLabels(DataPointSnapshot original, Labels newLabels) {
        if (original instanceof GaugeSnapshot.GaugeDataPointSnapshot) {
            GaugeSnapshot.GaugeDataPointSnapshot gaugeDataPointSnapshot = (GaugeSnapshot.GaugeDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getGaugeDataPointSnapshotWithNewLabels(newLabels, gaugeDataPointSnapshot);
        }
        if (original instanceof CounterSnapshot.CounterDataPointSnapshot) {
            CounterSnapshot.CounterDataPointSnapshot counterSnapshot = (CounterSnapshot.CounterDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getCounterDataPointSnapshotWithNewLabels(newLabels, counterSnapshot);
        }
        if (original instanceof InfoSnapshot.InfoDataPointSnapshot) {
            InfoSnapshot.InfoDataPointSnapshot dataPointSnapshot = (InfoSnapshot.InfoDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getInfoDataPointSnapshotWithNewLabels(newLabels, dataPointSnapshot);
        }
        if (original instanceof StateSetSnapshot.StateSetDataPointSnapshot) {
            StateSetSnapshot.StateSetDataPointSnapshot stateSetDataPointSnapshot = (StateSetSnapshot.StateSetDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getStateSetDataPointSnapshotWithNewLabels(newLabels, stateSetDataPointSnapshot);
        }
        if (original instanceof UnknownSnapshot.UnknownDataPointSnapshot) {
            UnknownSnapshot.UnknownDataPointSnapshot unknownDataPointSnapshot = (UnknownSnapshot.UnknownDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getUnknownDataPointSnapshotWithNewLabels(newLabels, unknownDataPointSnapshot);
        }
        if (original instanceof SummarySnapshot.SummaryDataPointSnapshot) {
            SummarySnapshot.SummaryDataPointSnapshot summaryDataPointSnapshot = (SummarySnapshot.SummaryDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getSummaryDataPointSnapshotWithNewLabels(newLabels, summaryDataPointSnapshot);
        }
        if (original instanceof HistogramSnapshot.HistogramDataPointSnapshot) {
            HistogramSnapshot.HistogramDataPointSnapshot histogramDataPointSnapshot = (HistogramSnapshot.HistogramDataPointSnapshot)original;
            return PrometheusMetricsExportUtils.getHistogramDataPointSnapshotWithNewLabels(newLabels, histogramDataPointSnapshot);
        }
        throw new UnsupportedOperationException("Could not rewrite data points of class " + String.valueOf(original.getClass()));
    }

    private static HistogramSnapshot.HistogramDataPointSnapshot getHistogramDataPointSnapshotWithNewLabels(Labels newLabels, HistogramSnapshot.HistogramDataPointSnapshot histogramDataPointSnapshot) {
        return new HistogramSnapshot.HistogramDataPointSnapshot(histogramDataPointSnapshot.getClassicBuckets(), histogramDataPointSnapshot.getNativeSchema(), histogramDataPointSnapshot.getNativeZeroCount(), histogramDataPointSnapshot.getNativeZeroThreshold(), histogramDataPointSnapshot.getNativeBucketsForPositiveValues(), histogramDataPointSnapshot.getNativeBucketsForNegativeValues(), histogramDataPointSnapshot.getSum(), newLabels, histogramDataPointSnapshot.getExemplars(), histogramDataPointSnapshot.getCreatedTimestampMillis(), histogramDataPointSnapshot.getScrapeTimestampMillis());
    }

    private static SummarySnapshot.SummaryDataPointSnapshot getSummaryDataPointSnapshotWithNewLabels(Labels newLabels, SummarySnapshot.SummaryDataPointSnapshot summaryDataPointSnapshot) {
        return new SummarySnapshot.SummaryDataPointSnapshot(summaryDataPointSnapshot.getCount(), summaryDataPointSnapshot.getSum(), summaryDataPointSnapshot.getQuantiles(), newLabels, summaryDataPointSnapshot.getExemplars(), summaryDataPointSnapshot.getCreatedTimestampMillis(), summaryDataPointSnapshot.getScrapeTimestampMillis());
    }

    private static UnknownSnapshot.UnknownDataPointSnapshot getUnknownDataPointSnapshotWithNewLabels(Labels newLabels, UnknownSnapshot.UnknownDataPointSnapshot unknownDataPointSnapshot) {
        return new UnknownSnapshot.UnknownDataPointSnapshot(unknownDataPointSnapshot.getValue(), newLabels, unknownDataPointSnapshot.getExemplar(), unknownDataPointSnapshot.getScrapeTimestampMillis());
    }

    private static StateSetSnapshot.StateSetDataPointSnapshot getStateSetDataPointSnapshotWithNewLabels(Labels newLabels, StateSetSnapshot.StateSetDataPointSnapshot stateSetDataPointSnapshot) {
        int count = stateSetDataPointSnapshot.size();
        String[] names = new String[count];
        boolean[] bools = new boolean[count];
        AtomicInteger curr = new AtomicInteger();
        stateSetDataPointSnapshot.stream().forEach(state -> {
            int i = curr.getAndIncrement();
            names[i] = state.getName();
            bools[i] = state.isTrue();
        });
        return new StateSetSnapshot.StateSetDataPointSnapshot(names, bools, newLabels, stateSetDataPointSnapshot.getScrapeTimestampMillis());
    }

    private static InfoSnapshot.InfoDataPointSnapshot getInfoDataPointSnapshotWithNewLabels(Labels newLabels, InfoSnapshot.InfoDataPointSnapshot dataPointSnapshot) {
        return new InfoSnapshot.InfoDataPointSnapshot(newLabels, dataPointSnapshot.getScrapeTimestampMillis());
    }

    private static CounterSnapshot.CounterDataPointSnapshot getCounterDataPointSnapshotWithNewLabels(Labels newLabels, CounterSnapshot.CounterDataPointSnapshot counterSnapshot) {
        return new CounterSnapshot.CounterDataPointSnapshot(counterSnapshot.getValue(), newLabels, counterSnapshot.getExemplar(), counterSnapshot.getCreatedTimestampMillis(), counterSnapshot.getScrapeTimestampMillis());
    }

    private static GaugeSnapshot.GaugeDataPointSnapshot getGaugeDataPointSnapshotWithNewLabels(Labels newLabels, GaugeSnapshot.GaugeDataPointSnapshot gaugeDataPointSnapshot) {
        return ((GaugeSnapshot.GaugeDataPointSnapshot.Builder)((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().value(gaugeDataPointSnapshot.getValue()).scrapeTimestampMillis(gaugeDataPointSnapshot.getScrapeTimestampMillis())).labels(newLabels)).build();
    }

    private static PairList<String, String> getDefaultLabels(String instanceName, boolean shadowModeEnabled) {
        PairList defaultLabels = new PairList();
        if (!StringUtils.isEmpty((String)instanceName)) {
            defaultLabels.add((Object)METRICS_LABEL_INSTANCE_NAME, (Object)instanceName);
        }
        defaultLabels.add((Object)METRICS_LABEL_SHADOW_MODE, (Object)Boolean.toString(shadowModeEnabled));
        return defaultLabels;
    }

    private PrometheusMetricsExportUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

