/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.testwise_coverage;

import com.teamscale.commons.utils.StringPool;
import com.teamscale.index.report.coverage.testwise_coverage.TestInfoContainerBuilder;
import com.teamscale.index.report.coverage.testwise_coverage.TestWiseCoveragePathMatchingPlausibilityCheck;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.CoverageUnitContainer;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.FileCoverage;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.PathCoverage;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestInfo;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestwiseCoverageReport;
import org.conqat.lib.commons.string.StringUtils;

public class TestInfoContainerBuilderV1
implements TestInfoContainerBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CoverageInfoRetriever coverageInfoRetriever;
    private final IMatchingPathsLookup matchingPathsLookup;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final boolean disablePlausibilityCheckForPathMapping;

    public TestInfoContainerBuilderV1(CoverageInfoRetriever coverageInfoRetriever, IMatchingPathsLookup matchingPathsLookup, TokenElementLineInfoIndex tokenElementLineInfoIndex, boolean disablePlausibilityCheckForPathMapping) {
        this.coverageInfoRetriever = coverageInfoRetriever;
        this.matchingPathsLookup = matchingPathsLookup;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.disablePlausibilityCheckForPathMapping = disablePlausibilityCheckForPathMapping;
    }

    @Override
    public void build(TestwiseCoverageReport testwiseCoverageReport) throws StorageException {
        boolean partial = testwiseCoverageReport.isPartial() || testwiseCoverageReport.tests.stream().anyMatch(TestInfo::isEmpty);
        for (TestInfo test : testwiseCoverageReport.tests) {
            try {
                TestInfoContainer currentTestInfo = this.createTestwiseCoverageInfo(test, this.coverageInfoRetriever, partial, null);
                currentTestInfo.setHash(test.content);
                currentTestInfo.setDurationSeconds(test.duration);
                currentTestInfo.setResult(test.result);
                currentTestInfo.setMessage(test.message);
                if (this.isNotCoverable(test, partial)) continue;
                CoverageUnitContainer coverageUnitContainer = this.coverageInfoRetriever.createCoverageUnitContainer(currentTestInfo.getUniformPath());
                coverageUnitContainer.setPartOfPartialReport(currentTestInfo.isPartOfPartialReport());
                this.collectCoverage(test.paths, coverageUnitContainer.getCoverageInfo());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Dropping coverage for " + test.uniformPath + " due to error: ", (Throwable)ex);
            }
        }
    }

    private boolean isNotCoverable(TestInfo test, boolean partial) {
        return test.paths == null || partial && test.paths.isEmpty();
    }

    private void collectCoverage(List<PathCoverage> paths, MultiFileRangeCoverageInfo coverageInfo) {
        for (PathCoverage path : paths) {
            for (FileCoverage file : path.files) {
                String pathFromReport = StringUtils.addPrefix((String)file.fileName, (String)"/", (String)path.path);
                Optional<String> bestMatchingPath = this.disablePlausibilityCheckForPathMapping ? this.matchingPathsLookup.lookupBestPath(pathFromReport, PathLookupOptions.defaults()) : this.matchingPathsLookup.lookupBestPath(pathFromReport, PathLookupOptions.withPlausibilityCheck(new TestWiseCoveragePathMatchingPlausibilityCheck(this.tokenElementLineInfoIndex, file.coveredLines)));
                bestMatchingPath.ifPresent(uniformPath -> coverageInfo.addLineCoverage(StringPool.intern((String)uniformPath), file.coveredLines));
            }
        }
    }
}

