/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.BranchPointerHistoryIndex;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.committree.NopBranchRenameHandler;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.GitCommitGraphNode;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitPreStartCommitsSupport;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import com.teamscale.index.repository.git.common.SystemPropertyUtils;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumperFactory;
import com.teamscale.index.repository.git.debug_dump.dump.IGitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.replay.GitMainRepositoryMock;
import com.teamscale.index.repository.git.labeling.GitBranchPrioritizer;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.transport.RefSpec;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class GitRepositoryConnection
extends RepositoryConnectionBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FAILED_FETCH_LIMIT_PROPERTY_NAME = "com.teamscale.failed-fetch-limit";
    private static final int FAILED_FETCH_LIMIT_DEFAULT_VALUE = 5;
    protected GitRepositoryConnectorParameterStep gitParameters;
    protected Boolean keepResurrectedBranchHistory = (Boolean)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getValue();
    private static final Duration MAXIMUM_TIME_BETWEEN_COMMIT_TREE_EXPANSIONS = DurationUtils.ONE_HOUR;
    private final TeamscaleGitCredentialsProvider credentials;
    private final Instant analysisStart;
    private final Instant analysisEnd;
    private final Path cloneDirectory;
    protected final GitMainRepository repository;
    private String lastSynchronizedRevision = null;
    private final GitBranchPrioritizer branchPrioritizer;
    private PathBuildingBranchLabeler branchLabeler;
    private final IGitRepositoryDebugDumper repoDumper;
    private final GitPreStartCommitsSupport preStartCommitsSupport;
    protected boolean convertSubmoduleSshToHttpsUrl;

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable) throws RepositoryException {
        this(connectorBaseParameterStep, gitParameterStep, gitCredentials, cancelable, false, false);
    }

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable, boolean convertSubmoduleSshToHttpsUrl) throws RepositoryException {
        this(connectorBaseParameterStep, gitParameterStep, gitCredentials, cancelable, convertSubmoduleSshToHttpsUrl, false);
    }

    public GitRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, GitCredentials gitCredentials, ICancelable cancelable, boolean convertSubmoduleSshToHttpsUrl, boolean mockGitMainRepository) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.repoDumper = GitRepositoryDebugDumperFactory.createDebugDumper(connectorBaseParameterStep, gitParameterStep);
        this.gitParameters = gitParameterStep;
        this.credentials = GitUtils.createCredentialsProvider(gitCredentials.username(), gitCredentials.password(), gitCredentials.privateKeyOption());
        this.convertSubmoduleSshToHttpsUrl = convertSubmoduleSshToHttpsUrl;
        this.cloneDirectory = gitParameterStep.getRepositoryCloneDirectory();
        this.repository = mockGitMainRepository ? new GitMainRepositoryMock(this) : new GitMainRepository(this, gitCredentials.repositoryPath(), cancelable);
        this.branchPrioritizer = new GitBranchPrioritizer(connectorBaseParameterStep.getDefaultBranchName(), gitParameterStep.getImportantBranchPatterns());
        this.analysisStart = this.getInstantForStartDateOrRevision(connectorBaseParameterStep.getStartDateOrRevision(), connectorBaseParameterStep.getMinimalStartTimestamp());
        this.analysisEnd = this.getInstantForEndDateOrRevision(connectorBaseParameterStep.getEndDateOrRevision());
        this.preStartCommitsSupport = new GitPreStartCommitsSupport(this.gitParameters.getGitInfoIndex(), this.getDefaultBranchName());
    }

    public Path getCloneDirectory() {
        return this.cloneDirectory;
    }

    public TeamscaleGitCredentialsProvider getCredentials() {
        return this.credentials;
    }

    Repository getRepository() {
        return this.repository.getRepository();
    }

    public GitMainRepository getMainRepository() {
        return this.repository;
    }

    public Instant getAnalysisStart() {
        return this.analysisStart;
    }

    protected Instant getAnalysisEnd() {
        return this.analysisEnd;
    }

    public GitBranchPrioritizer getBranchPrioritizer() {
        return this.branchPrioritizer;
    }

    @Override
    protected Optional<Long> convertRevisionToTimestamp(String revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision);
        return this.repository.convertRevisionToTimestamp(revision);
    }

    @Override
    public String getLocationDescription() throws RepositoryException {
        return this.repository.getLocationDescription();
    }

    @Override
    public boolean isCommitTreeExpansionNeeded() throws RepositoryException {
        try {
            return this.gitParameters.getGitInfoIndex().isCommitTreeExpansionNeeded();
        }
        catch (StorageException e) {
            throw new RepositoryException("Reading expansion info failed", (Throwable)e);
        }
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree commitTree) throws RepositoryException, RescheduleRequestedException {
        LOGGER.traceEntry("Expanding commit nodes for {}.", new Object[]{commitTree});
        this.doSynchronizeAndRescheduleIfNecessary();
        try {
            this.clearGitInfoIndexIfDefaultBranchChanged();
            if (this.shouldSkipCommitTreeExpansion((ICommitTree)commitTree)) {
                return (CommitTreeExpansionResult)LOGGER.traceExit("Skipped commit tree expansion for {}.", (Object)CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build());
            }
            if (commitTree.getAllNodes().isEmpty()) {
                this.gitParameters.getGitInfoIndex().resetInitialDefaultBranchRootRevision();
            }
            Map<String, CommitGraphNode> nodesByName = this.runPathBuildingAlgorithmAndPersistResults(commitTree);
            this.onPreFilterGitTree(nodesByName);
            this.filterExcludedBranches(nodesByName);
            this.filterNodesAfterAnalysisEnd(nodesByName);
            this.onPostFilterGitTree(nodesByName);
            Set<ICommitTreeNode> addedNodes = this.insertNewNodesIntoCommitTree(commitTree, nodesByName, this.getExistingCommitsOrRaiseRollbackException((ICommitTree)commitTree, nodesByName));
            this.synchronizeSubModules(nodesByName);
            this.updateBranchPointerIndexFromGitRepository(nodesByName);
            this.skipExpansionsUntilNextChange();
            this.storeLastExpansionTimestamp();
            this.performDebugDumpIfRequested();
            return (CommitTreeExpansionResult)LOGGER.traceExit("Expanded commit tree {}.", (Object)CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).withAddedNodes(addedNodes).build());
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void performDebugDumpIfRequested() throws StorageException {
        GitRepositoryInfoIndex gitInfoIndex = this.gitParameters.getGitInfoIndex();
        if (gitInfoIndex.isDebugDumpRequested()) {
            LOGGER.info("Performing a full git debug dump due to user request");
            this.repoDumper.performDump();
            gitInfoIndex.setDebugDumpRequested(false);
        }
    }

    protected void filterExcludedBranches(Map<String, CommitGraphNode> nodesByName) throws StorageException {
        int totalNodesBefore = nodesByName.size();
        LOGGER.trace("Filter {} node(s) to only contain commits on not excluded branches.", (Object)totalNodesBefore);
        CommitGraphNode.topSort(nodesByName.values()).stream().filter(node -> !this.isBranchNameIncludedOrDefaultBranch(node.getBranchName())).forEach(node -> {
            LOGGER.trace("Deleting node on excluded branch: {}", node);
            GitRepositoryConnection.deleteNode(nodesByName, node);
        });
        LOGGER.trace("Filtered out {} nodes on excluded branches.", new Supplier[]{() -> totalNodesBefore - nodesByName.size()});
    }

    private void filterNodesAfterAnalysisEnd(Map<String, CommitGraphNode> nodesByName) {
        int totalNodesBefore = nodesByName.size();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = nodesByName::size;
        supplierArray[1] = this::getAnalysisEnd;
        LOGGER.trace("Filter {} node(s) to only contain commits before the analysis end at {}.", supplierArray);
        HashSet<CommitGraphNode> visitedNodes = new HashSet<CommitGraphNode>();
        ArrayDeque<CommitGraphNode> queuedNodes = new ArrayDeque<CommitGraphNode>();
        nodesByName.values().stream().filter(CommitGraphNode::isHead).forEach(queuedNodes::add);
        long analysisEndTimestamp = this.analysisEnd.toEpochMilli();
        while (!queuedNodes.isEmpty()) {
            CommitGraphNode node = (CommitGraphNode)queuedNodes.pop();
            boolean isNew = visitedNodes.add(node);
            if (!isNew || node.getCommitTimestamp() <= analysisEndTimestamp) continue;
            queuedNodes.addAll((Collection<CommitGraphNode>)node.getParents());
            GitRepositoryConnection.deleteNode(nodesByName, node);
        }
        LOGGER.trace("Filtered out {} nodes after the analysis end.", new Supplier[]{() -> totalNodesBefore - nodesByName.size()});
    }

    private void synchronizeSubModules(Map<String, CommitGraphNode> nodesByName) throws RepositoryException {
        if (this.gitParameters.isIncludeSubModules()) {
            this.repository.initAndSynchronizeSubModules(nodesByName.keySet(), this.gitParameters.getSubModuleRecursionDepth());
        }
    }

    private void skipExpansionsUntilNextChange() throws StorageException {
        if (this.repository.hasRemoteConfiguration()) {
            this.gitParameters.getGitInfoIndex().setCommitTreeExpansionNeeded(false);
        }
    }

    private void clearGitInfoIndexIfDefaultBranchChanged() throws StorageException {
        LOGGER.traceEntry();
        Optional<String> previousDefaultBranchName = this.gitParameters.getGitInfoIndex().getPreviousDefaultBranchName();
        if (previousDefaultBranchName.isPresent()) {
            if (previousDefaultBranchName.get().equals(this.getDefaultBranchName())) {
                LOGGER.traceExit((Object)"Nothing changed");
                return;
            }
            LOGGER.trace("Clearing git info index");
            this.gitParameters.getGitInfoIndex().clearStore();
        }
        LOGGER.trace("Previous default branch name: {}", (Object)this.getDefaultBranchName());
        this.gitParameters.getGitInfoIndex().setPreviousDefaultBranchName(this.getDefaultBranchName());
        LOGGER.traceExit();
    }

    private boolean shouldSkipCommitTreeExpansion(ICommitTree commitTree) throws StorageException, RepositoryException {
        LOGGER.traceEntry();
        if (this.gitParameters.getGitInfoIndex() == null) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        boolean shouldExpandBasedOnTimePassed = this.shouldExpandBasedOnPassedTimeSinceLastExpansion();
        if (shouldExpandBasedOnTimePassed) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        if (this.gitParameters.getGitInfoIndex().isDebugDumpRequested()) {
            return (Boolean)LOGGER.traceExit((Object)false);
        }
        if (!commitTree.isForceExpansionPending() && !this.isCommitTreeExpansionNeeded()) {
            return (Boolean)LOGGER.traceExit((Object)true);
        }
        return (Boolean)LOGGER.traceExit((Object)(!commitTree.getAllNodes().isEmpty() && this.areRepositoryRefsStillTheSame() ? 1 : 0));
    }

    private boolean areRepositoryRefsStillTheSame() throws RepositoryException {
        try {
            List allRefs = this.repository.getRepository().getRefDatabase().getRefs();
            StreamingXXHash64 refHash = XXHashUtils.streamingHash64();
            for (Ref ref : allRefs) {
                if (this.isExcluded(ref)) continue;
                XXHashUtils.updateHash((StreamingXXHash64)refHash, (String)ref.getName());
                XXHashUtils.updateHash((StreamingXXHash64)refHash, (String)ref.getObjectId().getName());
            }
            byte[] newRefHash = ByteArrayUtils.longToByteArray((long)refHash.getValue());
            byte[] previousRefHash = this.gitParameters.getGitInfoIndex().getRefsHash();
            if (previousRefHash == null || !Arrays.equals(newRefHash, previousRefHash)) {
                this.gitParameters.getGitInfoIndex().setRefsHash(newRefHash);
                return false;
            }
            return true;
        }
        catch (IOException | StorageException e) {
            throw new RepositoryException("Problem comparing previous ref md5 against current ref md5.", e);
        }
    }

    public Map<String, CommitGraphNode> runPathBuildingAlgorithmAndPersistResults(IChangeRetrieverCommitTree commitTree) throws StorageException, RepositoryException {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((IChangeRetrieverCommitTree)commitTree).getCommitTreeDump();
        LOGGER.traceEntry("Expanding commit tree {}.", supplierArray);
        Map<String, CommitGraphNode> nodesByName = this.buildCommitGraph(commitTree.getAllNodes());
        this.onCommitGraphCreated(nodesByName);
        Map<String, String> branchNamesByCommitName = this.gitParameters.getGitInfoIndex().getBranchNamesByCommitName();
        GitRepositoryConnection.setBranchNameRecommendations(nodesByName, branchNamesByCommitName);
        if (commitTree.isEmpty()) {
            branchNamesByCommitName = new HashMap<String, String>();
            LOGGER.trace("Running path building algorithm for an empty commit tree.");
        } else {
            LOGGER.trace("Running path building algorithm for a non-empty commit tree.");
        }
        HashMap<String, String> oldFixedNodes = new HashMap<String, String>(branchNamesByCommitName);
        this.onPreLabel(commitTree, branchNamesByCommitName, this.gitParameters.getGitInfoIndex().getInitialDefaultBranchRootRevision().orElse(""));
        LOGGER.trace("Branch labeling for {} new commits.", (Object)nodesByName.size());
        this.branchLabeler = this.createBranchLabeler(branchNamesByCommitName, (ICommitTree)commitTree, nodesByName);
        this.branchLabeler.setBranchLabelsForCommits();
        this.processLabeledNodes(nodesByName, (ICommitTree)commitTree);
        GitRepositoryConnection.removeAllHeadCommitsAndParentsWithoutBranchName(nodesByName, branchNamesByCommitName);
        this.handleResurrectedBranches(nodesByName, oldFixedNodes, branchNamesByCommitName);
        this.gitParameters.getGitInfoIndex().persistBranchNamesByCommitName(branchNamesByCommitName);
        GitRepositoryConnection.labelCommitsWithAnonymousBranchNames(nodesByName, branchNamesByCommitName);
        this.onPostLabel(commitTree, branchNamesByCommitName);
        return (Map)LOGGER.traceExit("Found and labeled " + nodesByName.size() + " nodes.", nodesByName);
    }

    private void handleResurrectedBranches(Map<String, CommitGraphNode> nodesByName, Map<String, String> oldFixedNodes, Map<String, String> currentFixedNodes) throws IllegalStateException {
        for (CommitGraphNode node : CommitGraphNode.topSort(nodesByName.values())) {
            CommitGraphNode closestReachableNodeWithSameBranch;
            if (!node.hasBranchNameSet() || !node.isFork() || (closestReachableNodeWithSameBranch = GitRepositoryConnection.getClosestReachableNodeFromSameBranch(node)) == null || node.getParents().contains((Object)closestReachableNodeWithSameBranch)) continue;
            if (this.keepResurrectedBranchHistory.booleanValue()) {
                GitRepositoryConnection.connectResurrectedBranch(node, closestReachableNodeWithSameBranch);
                continue;
            }
            GitRepositoryConnection.eraseOldBranchFromFixedNodes(node.getBranchName(), nodesByName, oldFixedNodes, currentFixedNodes);
        }
    }

    private static void eraseOldBranchFromFixedNodes(String branchToErase, Map<String, CommitGraphNode> nodesByName, Map<String, String> oldFixedNodes, Map<String, String> currentFixedNodes) {
        HashSet nodesWithErasedBranches = new HashSet();
        oldFixedNodes.forEach((commitName, oldFixedBranchName) -> {
            if (GitRepositoryConnection.eraseBranchFromFixedNode(branchToErase, nodesByName, currentFixedNodes, commitName, oldFixedBranchName)) {
                nodesWithErasedBranches.add(commitName);
            }
        });
        if (!nodesWithErasedBranches.isEmpty()) {
            LOGGER.warn("Erased branch name '{}' from {} previously fixed node(s), because the branch was resurrected, i.e., the old branch was deleted and a new one with the same name was created. These nodes will be on a different (likely anonymous) branch from now on, which will cause a rollback. If you prefer a looser alignment with the actual git repository history, set the system property \"{}=true\". In these cases, an artificial merge will be created to connect the commits from the old deleted branch to the new fork. This avoids a rollback, but may result in Teamscale displaying inaccurate change sets for commits on the affected branch.\nReset node(s): {}", (Object)branchToErase, (Object)nodesWithErasedBranches.size(), (Object)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getName(), (Object)String.join((CharSequence)", ", nodesWithErasedBranches));
        }
    }

    private static boolean eraseBranchFromFixedNode(String branchToErase, Map<String, CommitGraphNode> nodesByName, Map<String, String> currentFixedNodes, String commitName, String oldFixedBranchName) {
        if (!branchToErase.equals(oldFixedBranchName)) {
            return false;
        }
        CommitGraphNode node = nodesByName.get(commitName);
        if (!branchToErase.equals(node.getBranchName())) {
            LOGGER.info("Did not reset node '{}' on branch '{}' because it was labeled to a different branch than '{}'.", (Object)commitName, (Object)node.getBranchName(), (Object)branchToErase);
            return false;
        }
        currentFixedNodes.remove(commitName);
        node.setBranchName(null);
        return true;
    }

    private static void setBranchNameRecommendations(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        branchNamesByCommitName.forEach((commitName, branchName) -> {
            CommitGraphNode node = (CommitGraphNode)nodesByName.get(commitName);
            if (node != null) {
                node.setBranchName((String)branchName);
            }
        });
    }

    public Map<String, CommitGraphNode> buildCommitGraph(List<? extends ICommitTreeNode> oldNodes) throws RepositoryException {
        Set<RevCommit> relevantRevCommits = this.collectRelevantRevCommits(oldNodes);
        HashMap<String, CommitGraphNode> nodesByName = new HashMap<String, CommitGraphNode>();
        relevantRevCommits.forEach(commit -> GitRepositoryConnection.addCommit(nodesByName, commit));
        CollectionUtils.sort(nodesByName.values()).forEach(node -> GitRepositoryConnection.resolveNode(nodesByName, node));
        return nodesByName;
    }

    private Set<RevCommit> collectRelevantRevCommits(List<? extends ICommitTreeNode> oldNodes) throws RepositoryException {
        LOGGER.traceEntry("Collecting RevCommits in analysis scope.", new Supplier[0]);
        Set<RevCommit> commits = this.loadRevCommitsAfterAnalysisStart();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = commits::size;
        LOGGER.debug("Found {} RevCommit(s) in the analysis scope.", supplierArray);
        this.preStartCommitsSupport.addPreStartCommits(commits, this.getRepository(), oldNodes);
        return (Set)LOGGER.traceExit("All RevCommits relevant for the analysis scope (before branch labeling): {}", commits);
    }

    protected PathBuildingBranchLabeler createBranchLabeler(Map<String, String> branchByCommitFromGitInfoIndex, ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) {
        LOGGER.traceEntry();
        Map<String, String> fixedCommitsToBranchName = GitRepositoryConnection.fixScheduledAndProcessedCommits(commitTree, nodesByName);
        LOGGER.trace(fixedCommitsToBranchName);
        if (commitTree instanceof BranchRenamingCommitTreeFacade && !(((BranchRenamingCommitTreeFacade)commitTree).getBranchRenameHandler() instanceof NopBranchRenameHandler)) {
            return new PathBuildingBranchLabeler(branchByCommitFromGitInfoIndex, fixedCommitsToBranchName, nodesByName, this.branchPrioritizer, this::isBranchNameIncludedOrDefaultBranch, this.repository, ((BranchRenamingCommitTreeFacade)commitTree).getBranchRenameHandler());
        }
        return new PathBuildingBranchLabeler(branchByCommitFromGitInfoIndex, fixedCommitsToBranchName, nodesByName, this.branchPrioritizer, this::isBranchNameIncludedOrDefaultBranch, this.repository);
    }

    private static Map<String, String> fixScheduledAndProcessedCommits(ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) {
        LOGGER.traceEntry();
        HashMap<String, String> fixedCommitsToBranchName = new HashMap<String, String>();
        for (ICommitTreeNode node : commitTree.getAllNodes()) {
            if (ECommitTreeNodeState.isUnScheduledState((ECommitTreeNodeState)node.getState())) continue;
            GitRepositoryConnection.fixNodeAndParents(node, fixedCommitsToBranchName, commitTree, nodesByName);
        }
        return (Map)LOGGER.traceExit(fixedCommitsToBranchName);
    }

    private static void fixNodeAndParents(ICommitTreeNode startNode, Map<String, String> fixedCommitsToBranchName, ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) {
        Stack<ICommitTreeNode> nodesToFix = new Stack<ICommitTreeNode>();
        nodesToFix.push(startNode);
        while (!nodesToFix.isEmpty()) {
            ICommitTreeNode node = (ICommitTreeNode)nodesToFix.pop();
            if (fixedCommitsToBranchName.containsKey(node.getRevision().getRevision()) || !nodesByName.containsKey(node.getRevision().getRevision())) continue;
            fixedCommitsToBranchName.put(node.getRevision().getRevision(), node.getRevision().getBranchName());
            for (CommitTreeRevision parentRevision : node.getParentRevisions()) {
                nodesToFix.push(commitTree.getNodeByRevision(parentRevision));
            }
        }
    }

    protected void processLabeledNodes(Map<String, CommitGraphNode> nodesByName, ICommitTree commitTree) throws RepositoryException, StorageException {
    }

    protected UnmodifiableSet<RefSpec> getRefSpecs() throws RepositoryException {
        return CollectionUtils.emptySet();
    }

    public List<Ref> getRefsByPrefix(String prefix) throws RepositoryException {
        try {
            return this.getRepository().getRefDatabase().getRefsByPrefix(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static void addCommit(Map<String, CommitGraphNode> nodesByName, RevCommit commit) {
        GitCommitGraphNode node = new GitCommitGraphNode(commit);
        LOGGER.trace("Adding node to nodesByName: {} -> {}", (Object)commit.getName(), (Object)node);
        nodesByName.put(commit.getName(), node);
    }

    private static void resolveNode(Map<String, CommitGraphNode> nodesByName, CommitGraphNode node) {
        node.resolve(nodesByName);
        LOGGER.trace("Resolved node: {}", (Object)node);
    }

    private Set<RevCommit> loadRevCommitsAfterAnalysisStart() throws RepositoryException {
        LOGGER.traceEntry("Loading all commits after analysis start {}.", new Object[]{this.analysisStart});
        RevWalk revWalk = new RevWalk(this.getRepository());
        revWalk.setRevFilter(CommitTimeRevFilter.after((Date)Date.from(this.analysisStart)));
        this.setStartPoints(revWalk);
        HashSet commits = new HashSet();
        revWalk.forEach(commits::add);
        return (Set)LOGGER.traceExit(commits);
    }

    private void setStartPoints(RevWalk revWalk) throws RepositoryException {
        try {
            HashSet<RevCommit> startPoints = new HashSet<RevCommit>();
            for (Ref ref : this.getRepository().getRefDatabase().getRefs()) {
                Optional<RevCommit> commit;
                if (this.isExcluded(ref) || (commit = this.determineCommitFromRef(ref, revWalk)).isEmpty()) continue;
                startPoints.add(commit.get());
            }
            if (startPoints.isEmpty()) {
                throw new RepositoryException("No head references found. A previous clone may have failed. Please clean the working directory: " + String.valueOf(this.repository.getLocalDirectory()));
            }
            LOGGER.trace("Setting RevWalk start points to [{}].", new Supplier[]{() -> startPoints.stream().map(AnyObjectId::getName).collect(Collectors.joining(", "))});
            revWalk.markStart(startPoints);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Optional<RevCommit> determineCommitFromRef(Ref ref, RevWalk revWalk) throws IOException {
        ObjectId objectId;
        if (!ref.isPeeled()) {
            ref = this.getRepository().getRefDatabase().peel(ref);
        }
        if ((objectId = ref.getPeeledObjectId()) == null) {
            objectId = ref.getObjectId();
        }
        try {
            return Optional.of(revWalk.parseCommit((AnyObjectId)objectId));
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            return Optional.empty();
        }
    }

    protected boolean isExcluded(Ref ref) {
        if (GitUtils.isHeadRef(ref)) {
            return false;
        }
        Optional<String> branchNameFromRef = GitUtils.getBranchNameFromRef(ref);
        if (branchNameFromRef.isEmpty()) {
            return true;
        }
        String branchName = branchNameFromRef.get();
        if (this.getDefaultBranchName().equals(branchName)) {
            return false;
        }
        return !this.isBranchingEnabled() || !this.getBranchPatternSupport().isIncluded(branchName);
    }

    private static void removeAllHeadCommitsAndParentsWithoutBranchName(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        List<CommitGraphNode> headNodes = nodesByName.values().stream().filter(CommitGraphNode::isHead).toList();
        ArrayDeque<CommitGraphNode> nodesToProcess = new ArrayDeque<CommitGraphNode>(headNodes);
        HashSet<CommitGraphNode> processedNodes = new HashSet<CommitGraphNode>();
        while (!nodesToProcess.isEmpty()) {
            CommitGraphNode node = nodesToProcess.pop();
            boolean isNewNode = processedNodes.add(node);
            if (!isNewNode || node.hasBranchNameSet()) continue;
            nodesToProcess.addAll((Collection<CommitGraphNode>)node.getParents());
            branchNamesByCommitName.remove(node.getName());
        }
    }

    @Override
    protected void updateLiveBranches(IChangeRetrieverCommitTree commitTree) throws RepositoryException {
        commitTree.setLiveBranchNames((Collection)CollectionUtils.filter(this.branchLabeler.extractBranchesWithHeadCommit().values(), this::isBranchNameIncludedOrDefaultBranch));
    }

    private static void labelCommitsWithAnonymousBranchNames(Map<String, CommitGraphNode> nodesByName, Map<String, String> branchNamesByCommitName) {
        List nodesWithoutBranch = CollectionUtils.filter(nodesByName.values(), node -> node.getBranchName() == null);
        nodesWithoutBranch.sort(Comparator.comparingLong(CommitGraphNode::getCommitTimestamp).thenComparing(CommitGraphNode::getName));
        for (CommitGraphNode node2 : nodesWithoutBranch) {
            if (node2.getBranchName() != null) continue;
            String branchName = GitRefUtils.createAnonymousBranchName((String)node2.getName());
            for (CommitGraphNode nextNodeToLabel = node2; nextNodeToLabel != null && nextNodeToLabel.getBranchName() == null; nextNodeToLabel = nextNodeToLabel.getFirstParent()) {
                nextNodeToLabel.setBranchName(branchName);
                branchNamesByCommitName.put(nextNodeToLabel.getName(), branchName);
            }
        }
    }

    private static void deleteNode(Map<String, CommitGraphNode> nodesByName, CommitGraphNode node) {
        node.remove();
        nodesByName.remove(node.getName());
    }

    private Set<String> getExistingCommitsOrRaiseRollbackException(ICommitTree commitTree, Map<String, CommitGraphNode> nodesByName) throws RepositoryNeedsRollbackException, StorageException {
        HashMap<String, Long> rollbackTo = new HashMap<String, Long>();
        HashMap<String, String> warningsByBranch = new HashMap<String, String>();
        HashSet<String> existingCommits = new HashSet<String>();
        HashSet<String> noLongerExistingCommits = new HashSet<String>();
        for (ICommitTreeNode commitNode : commitTree.getAllNodes()) {
            String commitName = commitNode.getRevision().getRevision();
            existingCommits.add(commitName);
            CommitNodeConsistencyCheck consistencyCheckResult = this.isConsistent(commitNode, nodesByName.get(commitName));
            if (consistencyCheckResult.isConsistent || !commitNode.getAdjustedTimestamp().isPresent()) continue;
            String branchName = commitNode.getRevision().getBranchName();
            rollbackTo.merge(branchName, commitNode.getAdjustedTimestamp().getAsLong() - 1L, Math::min);
            if ((Long)rollbackTo.get(branchName) == commitNode.getAdjustedTimestamp().getAsLong() - 1L) {
                warningsByBranch.put(branchName, consistencyCheckResult.warning);
            }
            if (consistencyCheckResult.existsInGitRepo) continue;
            noLongerExistingCommits.add(commitName);
        }
        if (!noLongerExistingCommits.isEmpty()) {
            this.gitParameters.getRepositoryRevisionIndex().removeRevisions(noLongerExistingCommits);
        }
        if (!rollbackTo.isEmpty()) {
            this.raiseRollbackException(rollbackTo, warningsByBranch);
        }
        return existingCommits;
    }

    private void raiseRollbackException(Map<String, Long> rollbackTo, Map<String, String> warningsByBranch) throws StorageException, RepositoryNeedsRollbackException {
        StringBuilder builder = new StringBuilder("Performing rollback to compensate for changed git structure. Reasons:");
        for (String warning : warningsByBranch.values()) {
            builder.append("\n").append(warning);
        }
        String rollbackReason = builder.toString();
        if (!this.gitParameters.getPostponedRollbackIndex().hasEntryWithSameReason(rollbackReason)) {
            LOGGER.warn(rollbackReason);
        }
        RepositoryNeedsRollbackException repositoryNeedsRollbackException = new RepositoryNeedsRollbackException(rollbackReason, rollbackTo);
        this.onRepositoryNeedsRollbackException(repositoryNeedsRollbackException);
        throw repositoryNeedsRollbackException;
    }

    private CommitNodeConsistencyCheck isConsistent(ICommitTreeNode commitNode, CommitGraphNode gitNode) {
        if (gitNode == null) {
            return new CommitNodeConsistencyCheck(false, false, "Encountered commit that is not present in the git repository any more: " + String.valueOf(commitNode) + ". This was likely removed by a rebase or force push operation.");
        }
        String commitTreeBranchName = commitNode.getRevision().getBranchName();
        if (!commitTreeBranchName.equals(gitNode.getBranchName())) {
            if (this.branchLabeler.getSuggestions().hasHigherImportance(gitNode.getBranchName(), commitTreeBranchName)) {
                return new CommitNodeConsistencyCheck(false, true, "Overwritten branch " + commitTreeBranchName + " with " + gitNode.getBranchName() + " likely caused by a fast-forward merge.");
            }
            return new CommitNodeConsistencyCheck(false, true, "Branch name inconsistent between commit tree and git:\n\tCommit Tree: " + String.valueOf(commitNode.getRevision()) + "\n\tGit:         " + gitNode.getName() + "@" + gitNode.getBranchName());
        }
        Set commitParents = CollectionUtils.mapToSet((Collection)commitNode.getParentRevisions(), CommitTreeRevision::getRevision);
        List gitParents = CollectionUtils.map(gitNode.getParents(), CommitGraphNode::getName);
        boolean parentListsEqual = commitParents.containsAll(gitParents);
        Object warning = "";
        if (!parentListsEqual) {
            warning = "Parent commits in commit tree do not match parents in git.\n\tCommit Tree: " + String.valueOf(commitNode) + "\n\tGit:         " + String.valueOf(gitParents);
        }
        return new CommitNodeConsistencyCheck(parentListsEqual, true, (String)warning);
    }

    private Set<ICommitTreeNode> insertNewNodesIntoCommitTree(IChangeRetrieverCommitTree commitTree, Map<String, CommitGraphNode> nodesByName, Set<String> existingCommits) throws StorageException {
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        for (CommitGraphNode node : CommitGraphNode.topSort(nodesByName.values())) {
            if (existingCommits.contains(node.getName())) continue;
            List parentRevisions = CollectionUtils.map(node.getParents(), parent -> new CommitTreeRevision(parent.getName(), parent.getBranchName()));
            addedNodes.add(commitTree.addNode(new CommitTreeRevision(node.getName(), node.getBranchName()), node.getCommitTimestamp(), parentRevisions, arg_0 -> ((Logger)LOGGER).warn(arg_0)));
        }
        this.onPostInsertCommitTreeNodes(commitTree);
        return CollectionUtils.asUnmodifiable(addedNodes);
    }

    private static void connectResurrectedBranch(CommitGraphNode currentNode, CommitGraphNode reachableNode) {
        LOGGER.warn("While processing commit {}, a virtual parent reference to commit {} was created, since they belong to the same branch ({}) but do not yet share an ancestor relation.\nThis will affect the change set and findings of this commit, but in cases of resurrected branches, it is necessary in order to keep the history of the previously deleted branch around and to avoid rollbacks.\nIf you prefer a stricter alignment with the actual git repository history, set the system property \"{}=false\". In these cases, a rollback will then occur which will remove the old branch reference.", (Object)currentNode.getName(), (Object)reachableNode.getName(), (Object)currentNode.getBranchName(), (Object)TeamscaleSystemProperties.GIT_KEEP_RESURRECTED_BRANCH_HISTORY.getName());
        currentNode.addAsFirstParent(reachableNode);
    }

    private static @Nullable CommitGraphNode getClosestReachableNodeFromSameBranch(CommitGraphNode node) {
        ArrayDeque<CommitGraphNode> queue = new ArrayDeque<CommitGraphNode>((Collection<CommitGraphNode>)node.getParents());
        HashSet<CommitGraphNode> queuedNodes = new HashSet<CommitGraphNode>();
        while (!queue.isEmpty()) {
            CommitGraphNode reachableNode = (CommitGraphNode)queue.poll();
            if (Objects.equals(reachableNode.getBranchName(), node.getBranchName())) {
                return reachableNode;
            }
            for (CommitGraphNode parent : reachableNode.getParents()) {
                if (!queuedNodes.add(parent)) continue;
                queue.add(parent);
            }
        }
        return null;
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        long commitTimestamp = new GitCommitGraphNode(commit).getCommitTimestamp();
        RepositoryChangeSet changes = new RepositoryChangeSet(revision.getRevision(), new CommitDescriptor(revision.getBranchName(), commitTimestamp), commit.getAuthorIdent().getName(), commit.getFullMessage(), this.getCodePatternSupport(), this.analysisStart.toEpochMilli());
        this.repository.createChangeEntries(commit, this.repository.getCommit(parentRevision.getRevision()), changes, parentRevision.getBranchName(), "", this.gitParameters.getSubModuleRecursionDepth());
        return changes;
    }

    @Override
    public boolean supportsSkipping() {
        return true;
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        return this.crawl(this.repository.getCommit(revision.getRevision()));
    }

    private void synchronizeIfNecessary(@Nullable String revision) throws RepositoryException {
        if (revision == null || revision.equals(this.lastSynchronizedRevision)) {
            return;
        }
        if (this.repository.getOptionalCommit(revision).isEmpty()) {
            this.doSynchronize();
        }
        this.lastSynchronizedRevision = revision;
    }

    public void doSynchronize() throws RepositoryException {
        try {
            this.performSynchronization(false);
        }
        catch (RescheduleRequestedException rescheduleRequestedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    protected void doSynchronizeAndRescheduleIfNecessary() throws RescheduleRequestedException {
        this.performSynchronization(true);
    }

    private void performSynchronization(boolean shouldReschedule) throws RescheduleRequestedException {
        LOGGER.traceEntry("Synchronizing repository '{}'.", new Object[]{this.getRepository().getDirectory()});
        this.onPreSynchronize();
        try {
            this.synchronizeUsingRefSpecs();
            this.synchronizeCrossRepositorySourceBranches();
            this.onSynchronizeSuccessful();
        }
        catch (RepositoryException e) {
            if (shouldReschedule && e.getMessage().contains("429 Too Many Requests")) {
                LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to synchronize repository '{}' due to rate limiting. Rescheduling again.", (Object)this.getRepository().getDirectory());
                throw new RescheduleRequestedException((Throwable)e, Instant.now());
            }
            LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log("Failed to synchronize repository '{}'. Continuing with local changes.", (Object)this.getRepository().getDirectory());
        }
        this.onPostSynchronize();
        LOGGER.traceExit("Finished synchronization of repository '{}'.", (Object)this.getRepository().getDirectory());
    }

    @VisibleForTesting
    protected void synchronizeUsingRefSpecs() throws RepositoryException {
        LOGGER.trace("Synchronizing repository '{}' with ref specs.", (Object)this.getRepository());
        this.repository.synchronize(CollectionUtils.unionSet(this.getRefSpecs(), (Collection[])new Collection[]{this.getUserRequestedRefSpecs(), this.getCrossRepoSourceBranchRefs()}));
    }

    private Collection<RefSpec> getUserRequestedRefSpecs() {
        return CollectionUtils.map(this.gitParameters.getUserRequestedRefSpecs(), RefSpec::new);
    }

    private Collection<RefSpec> getCrossRepoSourceBranchRefs() {
        try {
            List<RefSpec> activeBranches = this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex().readAllActiveBranches().stream().map(sourceBranch -> "+%s:%s".formatted(sourceBranch.remoteRef(), sourceBranch.remoteRef())).map(RefSpec::new).toList();
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = activeBranches::size;
            LOGGER.debug("Found {} active cross-repository source branches.", supplierArray);
            LOGGER.trace("Fetching the following cross-repository source branch ref specs: [{}]", (Object)activeBranches.stream().map(RefSpec::toString).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
            return activeBranches;
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read cross-repository merge request source branches from index; they will not be updated.", (Throwable)e);
            return CollectionUtils.emptyList();
        }
    }

    private void synchronizeCrossRepositorySourceBranches() {
        LOGGER.trace("Synchronizing cross-repository source branches for repository '{}'.", (Object)this.getRepository());
        this.deleteInactiveCrossRepoSourceBranches();
        this.updateActiveCrossRepoSourceBranches();
    }

    private void updateActiveCrossRepoSourceBranches() {
        UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> activeBranches = this.getActiveCrossRepoSourceBranches();
        if (activeBranches.isEmpty()) {
            return;
        }
        try (Git git = this.repository.createGit();){
            activeBranches.forEach(sourceBranch -> GitRepositoryConnection.updateCrossRepoSourceBranch(git, sourceBranch));
        }
    }

    private UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> getActiveCrossRepoSourceBranches() {
        try {
            return this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex().readAllActiveBranches();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read cross-repository merge request source branches from index; they will not be updated.", (Throwable)e);
            return CollectionUtils.emptyList();
        }
    }

    private static void updateCrossRepoSourceBranch(Git git, CrossRepositoryMergeRequestSourceBranch sourceBranch) {
        try {
            GitRepositoryConnection.forceCreateBranch(git, sourceBranch.localBranchName(), sourceBranch.remoteRef());
        }
        catch (GitAPIException | JGitInternalException e) {
            LOGGER.error("Failed to create local branch for merge request source branch '{}'. This merge request will not be analyzed.", (Object)sourceBranch, (Object)e);
        }
    }

    private static void forceCreateBranch(Git git, String branchName, String remoteRef) throws GitAPIException, JGitInternalException {
        try {
            LOGGER.debug("Force creating branch '{}' from remote ref '{}'.", (Object)branchName, (Object)remoteRef);
            git.branchCreate().setName(branchName).setForce(true).setStartPoint(remoteRef).call();
        }
        catch (JGitInternalException e) {
            if (e.getMessage().contains("Create branch returned unexpected result NO_CHANGE")) {
                LOGGER.trace("Ignoring unexpected result NO_CHANGE error from JGit.", (Throwable)e);
                return;
            }
            throw e;
        }
    }

    private void deleteInactiveCrossRepoSourceBranches() {
        UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> branchesToCleanup = this.getCrossRepoSourceBranchesToCleanup();
        if (branchesToCleanup.isEmpty()) {
            return;
        }
        try (Git git = this.repository.createGit();){
            branchesToCleanup.forEach(sourceBranch -> this.deleteCrossRepoSourceBranch(git, (CrossRepositoryMergeRequestSourceBranch)sourceBranch));
        }
    }

    private void deleteCrossRepoSourceBranch(Git git, CrossRepositoryMergeRequestSourceBranch sourceBranch) {
        CrossRepositoryMergeRequestSourceBranchesIndex crossRepoMergeRequestSourceBranchesIndex = this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex();
        try {
            git.branchDelete().setForce(true).setBranchNames(new String[]{sourceBranch.localBranchName()}).call();
            crossRepoMergeRequestSourceBranchesIndex.removeBranch(sourceBranch);
        }
        catch (GitAPIException e) {
            LOGGER.error("Failed to delete cross-repository merge request source branch '{}'.", (Object)sourceBranch, (Object)e);
        }
        catch (StorageException e) {
            LOGGER.warn("Failed to clean up store '{}' after branch deletion.", (Object)crossRepoMergeRequestSourceBranchesIndex.getName(), (Object)e);
        }
    }

    private UnmodifiableList<CrossRepositoryMergeRequestSourceBranch> getCrossRepoSourceBranchesToCleanup() {
        try {
            return this.gitParameters.getCrossRepositoryMergeRequestSourceBranchesIndex().readAllInactiveBranches();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read inactive cross-repository source branches from index.", (Throwable)e);
            return CollectionUtils.emptyList();
        }
    }

    protected void onSynchronizeSuccessful() throws RepositoryException {
    }

    private Set<String> crawl(RevCommit commit) throws RepositoryException {
        return this.repository.crawl(commit, this.gitParameters.getSubModuleRecursionDepth());
    }

    @Override
    public byte[] getContent(String path, CommitTreeRevision revision) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        return this.repository.getContent(path, revision.getRevision(), this.gitParameters.getSubModuleRecursionDepth()).orElse(null);
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        return new Pair((Object)commit.getAuthorIdent().getName(), (Object)commit.getFullMessage());
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        this.synchronizeIfNecessary(revision.getRevision());
        RevCommit commit = this.repository.getCommit(revision.getRevision());
        return commit.getAuthorIdent().getEmailAddress();
    }

    private boolean shouldExpandBasedOnPassedTimeSinceLastExpansion() throws StorageException {
        return this.gitParameters.getGitInfoIndex().getLastCommitTreeExpansion().map(instant -> instant.isBefore(Instant.now().minus(MAXIMUM_TIME_BETWEEN_COMMIT_TREE_EXPANSIONS))).orElse(true);
    }

    private void storeLastExpansionTimestamp() throws StorageException {
        this.gitParameters.getGitInfoIndex().setLastCommitTreeExpansion(Instant.now());
    }

    @Override
    public void close() {
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public boolean isGerritConnection() {
        return false;
    }

    protected void updateBranchPointerIndexFromGitRepository(Map<String, CommitGraphNode> nodesByName) throws RepositoryException {
        HashMap<String, String> branchToShaMap = new HashMap<String, String>();
        GitBranchPointerIndex gitBranchPointerIndex = this.gitParameters.openBranchPointerIndex();
        try (Git git = new Git(this.getRepository());
             RevWalk revWalk = new RevWalk(this.getMainRepository().getRepository());){
            List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref ref : refs) {
                Optional<RevCommit> commit;
                String branchName = ref.getName();
                if (branchName.startsWith("refs/remotes/origin/") || !branchName.startsWith("refs/heads/") || (branchName = StringUtils.stripPrefix((String)branchName, (String)"refs/heads/")).equals("HEAD") || !(commit = this.determineCommitFromRef(ref, revWalk)).isPresent() || !nodesByName.containsKey(commit.get().getName())) continue;
                branchToShaMap.put(branchName, commit.get().getName());
            }
            gitBranchPointerIndex.storeBranchPointerLookup(branchToShaMap);
        }
        catch (IOException | StorageException | GitAPIException e) {
            throw new RepositoryException(e);
        }
    }

    public Long getGerritMinimalCreationTimestamp() {
        return null;
    }

    public void storeFailedFetch(String missingRef) throws StorageException {
        this.gitParameters.getGitInfoIndex().storeFailedFetch(missingRef);
    }

    public Collection<RefSpec> filterIgnoredRefSpecs(Collection<RefSpec> refSpecs) {
        HashSet<RefSpec> crossRepoSourceBranchRefs = new HashSet<RefSpec>(this.getCrossRepoSourceBranchRefs());
        return refSpecs.stream().filter(refSpec -> this.isBelowFailedFetchThreshold((RefSpec)refSpec) || crossRepoSourceBranchRefs.contains(refSpec)).toList();
    }

    private boolean isBelowFailedFetchThreshold(RefSpec refSpec) {
        try {
            return (long)this.gitParameters.getGitInfoIndex().getFailedFetchCount(refSpec.getSource()) <= GitRepositoryConnection.readFailedFetchThreshold();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read failed fetch count for ref spec '{}'. Will attempt to fetch ref.", (Object)refSpec, (Object)e);
            return true;
        }
    }

    @VisibleForTesting
    static long readFailedFetchThreshold() {
        return SystemPropertyUtils.getSystemPropertyAsLong(FAILED_FETCH_LIMIT_PROPERTY_NAME, 5L);
    }

    public void requestGarbageCollection() throws StorageException {
        this.gitParameters.getPendingGarbageCollectionIndex().requestGC(this.getRepository().getDirectory().toString());
    }

    private void onPreSynchronize() {
        this.repoDumper.recordRepositoryState(EGitRepositoryDumpState.PRE_SYNCHRONIZE, this.repository);
    }

    private void onPostSynchronize() {
        this.repoDumper.recordRepositoryState(EGitRepositoryDumpState.POST_SYNCHRONIZE, this.repository);
        this.fillBranchPointerHistoryIndex();
    }

    private void fillBranchPointerHistoryIndex() {
        if (!EFeatureToggle.ENABLE_BRANCH_POINTER_HISTORY_RECORDING.isEnabled()) {
            return;
        }
        try {
            BranchPointerHistoryIndex branchPointerHistoryIndex = this.baseParameters.getBranchPointerHistoryIndex();
            Instant now = DateTimeUtils.now();
            HashSet<String> inactiveBranches = new HashSet<String>(branchPointerHistoryIndex.getActiveBranches());
            for (Ref branchRef : this.repository.getAllBranches(false)) {
                String branchName = GitUtils.getBranchNameFromRef(branchRef).orElseThrow(() -> new IllegalStateException("Expected %s to be a branch head reference".formatted(branchRef)));
                String revision = branchRef.getLeaf().getObjectId().getName();
                branchPointerHistoryIndex.recordBranchRevision(branchName, revision, now);
                inactiveBranches.remove(branchName);
            }
            for (String inactiveBranch : inactiveBranches) {
                branchPointerHistoryIndex.recordBranchDeletion(inactiveBranch, now);
            }
        }
        catch (RuntimeException | RepositoryException | StorageException e) {
            LOGGER.warn("Failed to fill BranchPointerHistoryIndex", e);
        }
    }

    private void onPreLabel(IChangeRetrieverCommitTree commitTree, Map<String, String> branchNamesByCommitName, String initialDefaultBranchRootRevision) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.PRE_LABEL, commitTree);
        this.repoDumper.recordBranchNamesByCommitName(EGitRepositoryDumpState.PRE_LABEL, branchNamesByCommitName);
        this.repoDumper.recordInitialDefaultBranchRootRevision(EGitRepositoryDumpState.PRE_LABEL, initialDefaultBranchRootRevision);
    }

    private void onCommitGraphCreated(Map<String, CommitGraphNode> nodesByName) {
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.PRE_LABEL, nodesByName);
    }

    private void onPostLabel(IChangeRetrieverCommitTree commitTree, Map<String, String> branchNamesByCommitName) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.POST_LABEL, commitTree);
        this.repoDumper.recordBranchNamesByCommitName(EGitRepositoryDumpState.POST_LABEL, branchNamesByCommitName);
    }

    private void onPreFilterGitTree(Map<String, CommitGraphNode> nodesByName) {
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.PRE_FILTER_GIT_TREE, nodesByName);
    }

    private void onPostFilterGitTree(Map<String, CommitGraphNode> nodesByName) {
        this.repoDumper.recordCommitGraph(EGitRepositoryDumpState.POST_FILTER_GIT_TREE, nodesByName);
    }

    private void onPostInsertCommitTreeNodes(IChangeRetrieverCommitTree commitTree) {
        this.repoDumper.recordCommitTree(EGitRepositoryDumpState.POST_INSERT_COMMIT_TREE_NODES, commitTree);
    }

    private void onRepositoryNeedsRollbackException(RepositoryNeedsRollbackException rollbackException) {
        this.repoDumper.recordRollbackException(rollbackException);
        this.repoDumper.performDump();
    }

    private record CommitNodeConsistencyCheck(boolean isConsistent, boolean existsInGitRepo, String warning) {
    }
}

