/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudChangeRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudContentUpdater;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestSynchronizer;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.CachingRepositoryFullNameProvider;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClient;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.common.AppBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;

@ConnectorDescriptor
public class BitbucketCloudRepositoryConnectorDescriptor
extends AppBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MAX_FINDINGS_LINE_COMMENTS_PER_INSIGHTS_REPORT = 1000;
    private final SupplierWithException<ExternalCredentials, ConnectorValidationException> externalCredentialsProvider = SupplierWithException.memoize(this::doResolveExternalCredentials);

    public BitbucketCloudRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.BITBUCKET);
        this.autoExpose();
    }

    private BitbucketResources getBitbucketResources() throws ConnectorValidationException {
        try {
            Pair<String, String> parts = GitRepositoryManagementConnectorDescriptorBase.splitRepositoryName(this.repositoryName, ConnectorValidationException::new);
            String teamOrUser = (String)parts.getFirst();
            BitbucketCloudInstallationIndex.BitbucketInstallation appInstallation = BitbucketCloudRepositoryConnectorDescriptor.findInstallationForOrganizationOrUser(teamOrUser, this.getContext().getGlobalStorageSystem());
            BitbucketCloudClient client = new BitbucketCloudClient(appInstallation, (AccessTokenIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(AccessTokenIndex.class), LOGGER);
            BitbucketCloudRepository repository = client.getInstallationRepository(PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName));
            return new BitbucketResources(teamOrUser, appInstallation, client, repository);
        }
        catch (ServiceCallException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    protected int getFindingsLineCommentsLimitDefault() {
        return 1000;
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        BitbucketResources bitbucketResources = this.getBitbucketResources();
        return BitbucketCloudRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash("https://bitbucket.org", bitbucketResources.teamOrUser(), bitbucketResources.repository().getUuid(), "commits/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return this.getCommitLinkTemplate();
    }

    @Override
    public String getAccountIdentifier() {
        try {
            return this.resolveExternalCredentials().credentialsName;
        }
        catch (ConnectorValidationException e) {
            LOGGER.warn("Failed to resolve external credentials", (Throwable)e);
            return "error";
        }
    }

    @Override
    public ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        return (ExternalCredentials)this.externalCredentialsProvider.get();
    }

    private ExternalCredentials doResolveExternalCredentials() throws ConnectorValidationException {
        try {
            BitbucketResources bitbucketResources = this.getBitbucketResources();
            String url = BitbucketCloudUtils.getHttpCloneUrlFromResponse(bitbucketResources.repository());
            String username = "x-token-auth";
            String password = bitbucketResources.client().getInstallationToken();
            String accountIdentifier = BitbucketCloudUtils.serializeAccountIdentifier(url, bitbucketResources.appInstallation());
            return new ExternalCredentials(accountIdentifier, url, username, password);
        }
        catch (ServiceCallException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    public void validate() throws ConnectorValidationException {
        this.rewriteRepositoryName();
        super.validate();
    }

    private void rewriteRepositoryName() throws ConnectorValidationException {
        try {
            LOGGER.debug("Full name before rewriting to UUIDs: " + this.repositoryName);
            this.repositoryName = CachingRepositoryFullNameProvider.getRepositoryUuidFullName(this.repositoryName, this.getContext().getGlobalStorageSystem());
            LOGGER.debug("Full name after rewriting to UUIDs: " + this.repositoryName);
            this.getOptionByName("Repository name").setValue(this.repositoryName, CodeScopeAware.DEFAULT_CODE_SCOPE);
        }
        catch (ServiceCallException | ProjectConfigurationException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        this.rewriteRepositoryName();
        List bitbucketCloudConnectors = CollectionUtils.filter((Collection)triggerCreator.getNewProjectConfiguration().getConnectors(), connector -> connector.getType().equals(ERepositoryConnector.BITBUCKET.getReadableName()));
        try {
            this.rewriteRepositoryNames(bitbucketCloudConnectors);
        }
        catch (ServiceCallException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
        super.configureTriggers(triggerCreator);
    }

    private void rewriteRepositoryNames(List<ConnectorConfiguration> bitbucketCloudConnectors) throws ServiceCallException, ProjectConfigurationException {
        for (ConnectorConfiguration bitbucketCloudConnector : bitbucketCloudConnectors) {
            String repositoryUuidFullName;
            String fullName = bitbucketCloudConnector.getOptionValue("Repository name");
            if (fullName == null) {
                throw new ProjectConfigurationException("Repository name missing");
            }
            try {
                repositoryUuidFullName = CachingRepositoryFullNameProvider.getRepositoryUuidFullName(fullName, this.getContext().getGlobalStorageSystem());
            }
            catch (StorageException e) {
                throw new ProjectConfigurationException((Throwable)e);
            }
            bitbucketCloudConnector.setOptionValue("Repository name", repositoryUuidFullName);
        }
    }

    public static BitbucketCloudInstallationIndex.BitbucketInstallation findInstallationForOrganizationOrUser(String organizationOrUser, GlobalStorageSystem globalStorageSystem) throws StorageException, ConnectorValidationException {
        BitbucketCloudInstallationIndex installationIndex = (BitbucketCloudInstallationIndex)globalStorageSystem.openGlobalIndex(BitbucketCloudInstallationIndex.class);
        Optional<BitbucketCloudInstallationIndex.BitbucketInstallation> appInstallation = installationIndex.getBitbucketInstallationForTeamOrUsername(organizationOrUser);
        if (appInstallation.isPresent()) {
            return appInstallation.get();
        }
        throw new ConnectorValidationException("No installation found for organization or user " + organizationOrUser + ". Maybe you need to install the Bitbucket App first.");
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return BitbucketCloudContentUpdater.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return BitbucketCloudChangeRetriever.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return BitbucketCloudMergeRequestSynchronizer.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return BitbucketCloudMergeRequestAnnotationTrigger.class;
    }

    private record BitbucketResources(String teamOrUser, BitbucketCloudInstallationIndex.BitbucketInstallation appInstallation, BitbucketCloudClient client, BitbucketCloudRepository repository) {
    }
}

