/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match;

import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.match.IElementHistoryMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CloneBasedElementHistoryMatcher
implements IElementHistoryMatcher {
    private static final double CLONE_THRESHOLD_1 = 0.7;
    private static final double CLONE_THRESHOLD_2 = 0.6;
    private final CloneChunkByPathIndex byPathIndexHead;
    private final CloneChunkByHashIndex byHashIndexParent;
    private final ParentedCommitDescriptor commit;

    public CloneBasedElementHistoryMatcher(CloneChunkByPathIndex byPathIndexHead, CloneChunkByHashIndex byHashIndexParent, ParentedCommitDescriptor commit) {
        this.byPathIndexHead = byPathIndexHead;
        this.byHashIndexParent = byHashIndexParent;
        this.commit = commit;
    }

    @Override
    public Map<UniformPath, ElementHistoryEntry> match(Set<RepositoryChangeEntry> addedPathsEntrySet) throws StorageException {
        HashMap<UniformPath, ElementHistoryEntry> matches = new HashMap<UniformPath, ElementHistoryEntry>();
        ArrayList<RepositoryChangeEntry> addedPathsEntries = new ArrayList<RepositoryChangeEntry>(addedPathsEntrySet);
        List<String> addedPaths = addedPathsEntries.stream().map(RepositoryChangeEntry::getRepositoryPath).map(UniformPath::toStringAsMigrationFrontier).toList();
        List<CloneChunkList> addedPathsChunks = this.byPathIndexHead.getChunksForElements(addedPaths);
        Map<Long, CloneChunkList> allChunksByHash = this.mapAllChunksByHash(addedPathsChunks);
        for (int i = 0; i < addedPathsEntries.size(); ++i) {
            CloneChunkList addedPathChunks = addedPathsChunks.get(i);
            ListMap<String, CloneChunk> chunksByPath = CloneBasedElementHistoryMatcher.getChunksFromCopiesByPath(allChunksByHash, addedPathChunks);
            double bestCoverage = 0.0;
            String bestPath = null;
            for (String oldPath : chunksByPath.getKeys()) {
                double coverage = CloneBasedElementHistoryMatcher.getMatchedCoverage(addedPathChunks, new CloneChunkList((List)chunksByPath.getCollection((Object)oldPath)), this.byPathIndexHead.getChunkLength(), 0.6);
                if (!(coverage > bestCoverage)) continue;
                bestCoverage = coverage;
                bestPath = oldPath;
            }
            if (!(bestCoverage > 0.7)) continue;
            matches.put(((RepositoryChangeEntry)addedPathsEntries.get(i)).getRepositoryPath(), new ElementHistoryEntry(bestPath, this.commit.getFirstParentCommit(), (CommitDescriptor)this.commit, EElementHistoryChangeType.MOVE, ((RepositoryChangeEntry)addedPathsEntries.get(i)).getChangeEntryOrigin()));
        }
        return matches;
    }

    private Map<Long, CloneChunkList> mapAllChunksByHash(List<CloneChunkList> addedPathsChunks) throws StorageException {
        List<Long> allHashes = CloneBasedElementHistoryMatcher.getDistinctChunkHashes(addedPathsChunks);
        List<CloneChunkList> allCloneChunks = this.byHashIndexParent.getChunksForHashes(allHashes);
        HashMap<Long, CloneChunkList> allChunksByHash = new HashMap<Long, CloneChunkList>();
        for (int i = 0; i < allHashes.size(); ++i) {
            allChunksByHash.put(allHashes.get(i), allCloneChunks.get(i));
        }
        return allChunksByHash;
    }

    private static List<Long> getDistinctChunkHashes(List<CloneChunkList> addedPathsChunks) {
        return addedPathsChunks.stream().flatMap(Collection::stream).map(CloneChunk::getChunkHash).distinct().toList();
    }

    private static ListMap<String, CloneChunk> getChunksFromCopiesByPath(Map<Long, CloneChunkList> allChunksByHash, CloneChunkList addedPathChunks) {
        ListMap chunksByPath = new ListMap();
        for (Long hash : addedPathChunks.getIncludedHashes()) {
            for (CloneChunk chunk : allChunksByHash.get(hash)) {
                chunksByPath.add((Object)chunk.getOriginId(), (Object)chunk);
            }
        }
        return chunksByPath;
    }

    public static double getMatchedCoverage(CloneChunkList newElementChunks, CloneChunkList oldElementChunks, int chunkLength, double threshold) {
        if (CollectionUtils.isNullOrEmpty((Collection)newElementChunks) || CollectionUtils.isNullOrEmpty((Collection)oldElementChunks)) {
            return -1.0;
        }
        HashSet commonHashes = CollectionUtils.intersectionSet(newElementChunks.getIncludedHashes(), (Collection[])new Collection[]{oldElementChunks.getIncludedHashes()});
        if (commonHashes.isEmpty()) {
            return -1.0;
        }
        double coverageNew = CloneBasedElementHistoryMatcher.determineCoverage(newElementChunks, commonHashes, chunkLength);
        double coverageOld = CloneBasedElementHistoryMatcher.determineCoverage(oldElementChunks, commonHashes, chunkLength);
        if (coverageNew >= threshold && coverageOld >= threshold) {
            return coverageNew;
        }
        return -1.0;
    }

    private static double determineCoverage(CloneChunkList elementChunks, Set<Long> commonHashes, int chunkLength) {
        RegionSet clonedRegions = new RegionSet();
        clonedRegions.addAll((Collection)CollectionUtils.filterAndMap((Collection)elementChunks, chunk -> commonHashes.contains(chunk.getChunkHash()), chunk -> new Region(chunk.getFirstUnitIndex(), chunk.getFirstUnitIndex() + chunkLength - 1)));
        return (double)clonedRegions.getPositionCount() / (double)((CloneChunk)elementChunks.getFirst()).getElementUnits();
    }
}

