/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.requirements_tracing.merge_request.ArchitectureComponentSpecItemDelta;
import com.teamscale.index.requirements_tracing.merge_request.ArchitectureComponentSpecItemMapper;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculatorIndexes;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculatorUtils;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemReferenceDiff;
import com.teamscale.index.requirements_tracing.merge_request.ambiguity_resolution.EntitySignatureComparingStrategy;
import com.teamscale.index.requirements_tracing.merge_request.ambiguity_resolution.MethodHistoryTraversalStrategy;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.issue_reference.IssueReference;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.jspecify.annotations.NonNull;

public class MergeRequestImpactedSpecItemsCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MergeRequestImpactedSpecItemsCalculatorIndexes indexHelper;
    private Map<String, ArrayList<IssueReference>> issueReferencesAtMergeBase;
    private Map<String, ArrayList<IssueReference>> issueReferencesAtSourceHead;
    private final TwoDimHashMap<String, TeamscaleIssueId, Set<SpecItemCodeReference>> reqCodeRefsByUniformPathAndItemIdAtSourceHead = new TwoDimHashMap();
    private final TwoDimHashMap<String, TeamscaleIssueId, Set<SpecItemCodeReference>> reqCodeRefsByUniformPathAndItemIdAtMergeBase = new TwoDimHashMap();
    private final Map<TeamscaleIssueId, TeamscaleIssueTypeInfo> specItemTypeInfoById = new HashMap<TeamscaleIssueId, TeamscaleIssueTypeInfo>();
    private final Map<String, TokenElementInfo> tokenElementsByUniformPathAtSourceHead = new HashMap<String, TokenElementInfo>();
    private final Map<String, TokenElementInfo> tokenElementsByUniformPathAtMergeBase = new HashMap<String, TokenElementInfo>();
    private final List<String> affectedUniformPaths;

    public MergeRequestImpactedSpecItemsCalculator(MergeRequestImpactedSpecItemsCalculatorIndexes indexHelper, List<String> affectedUniformPaths) throws StorageException {
        this.indexHelper = indexHelper;
        this.affectedUniformPaths = affectedUniformPaths;
        this.init();
    }

    private void init() throws StorageException {
        LOGGER.trace("Affected uniform paths: {}", this.affectedUniformPaths);
        this.initIssueReferences();
        this.initTokenElements();
        this.initSpecItems();
    }

    private void initIssueReferences() throws StorageException {
        this.issueReferencesAtMergeBase = this.indexHelper.getIssueReferenceIndexAtMergeBase().getIssueReferencesByPaths(this.affectedUniformPaths);
        this.issueReferencesAtSourceHead = this.indexHelper.getIssueReferenceIndexAtSourceHead().getIssueReferencesByPaths(this.affectedUniformPaths);
        LOGGER.trace("Spec item references at merge base: {}", this.issueReferencesAtMergeBase);
        LOGGER.trace("Spec item references at source head: {}", this.issueReferencesAtSourceHead);
    }

    private void initTokenElements() throws StorageException {
        List<TokenElementInfo> tokenElementsAtSourceHead = this.indexHelper.getTokenElementIndexAtSourceHead().getTokenElements(this.affectedUniformPaths);
        List<TokenElementInfo> tokenElementsAtMergeBase = this.indexHelper.getTokenElementIndexAtMergeBase().getTokenElements(this.affectedUniformPaths);
        for (int i = 0; i < this.affectedUniformPaths.size(); ++i) {
            this.tokenElementsByUniformPathAtSourceHead.put(this.affectedUniformPaths.get(i), tokenElementsAtSourceHead.get(i));
            this.tokenElementsByUniformPathAtMergeBase.put(this.affectedUniformPaths.get(i), tokenElementsAtMergeBase.get(i));
        }
    }

    private void initSpecItems() throws StorageException {
        List<TeamscaleIssueId> specItemIdsAtMergeBase = MergeRequestImpactedSpecItemsCalculator.getSpecItemIds(this.issueReferencesAtMergeBase, this.reqCodeRefsByUniformPathAndItemIdAtMergeBase, "merge base", this.indexHelper.getSpecItemCodeReferenceIndexAtMergeBase());
        List<TeamscaleIssueId> specItemIdsAtSourceHead = MergeRequestImpactedSpecItemsCalculator.getSpecItemIds(this.issueReferencesAtSourceHead, this.reqCodeRefsByUniformPathAndItemIdAtSourceHead, "source head", this.indexHelper.getSpecItemCodeReferenceIndexAtSourceHead());
        List<@NonNull TeamscaleIssueId> allSpecItemIds = Stream.of(specItemIdsAtSourceHead, specItemIdsAtMergeBase).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.specItemTypeInfoById.putAll(this.indexHelper.getSpecItemHistoryIndex().getByIssueIds(allSpecItemIds).stream().filter(Objects::nonNull).collect(Collectors.toMap(TeamscaleIssue::getId, SpecItem::getTypeInfo)));
        LOGGER.trace("Spec item type info: {}", this.specItemTypeInfoById);
    }

    private static List<TeamscaleIssueId> getSpecItemIds(Map<String, ArrayList<IssueReference>> issueReferences, TwoDimHashMap<String, TeamscaleIssueId, Set<SpecItemCodeReference>> reqCodeRefsByUniformPathAndItemId, String loggingName, SpecItemCodeReferenceIndex specItemCodeReferenceIndex) throws StorageException {
        List<TeamscaleIssueId> specItemIds = MergeRequestImpactedSpecItemsCalculatorUtils.getDistinctSpecItemIds(issueReferences);
        reqCodeRefsByUniformPathAndItemId.putAll(MergeRequestImpactedSpecItemsCalculatorUtils.buildSpecItemCodeReferencesByUniformPathAndSpecItemId(specItemCodeReferenceIndex, specItemIds, issueReferences.keySet()));
        LOGGER.trace("Spec items at {}: {}", (Object)loggingName, specItemIds);
        LOGGER.trace("Spec item references at {}: {}", (Object)loggingName, reqCodeRefsByUniformPathAndItemId);
        return specItemIds;
    }

    public ImpactedSpecItemsDelta calculateDelta() throws StorageException {
        ArrayList<SpecItemReferenceDiff> addedReferences = new ArrayList<SpecItemReferenceDiff>();
        ArrayList<SpecItemReferenceDiff> removedReferences = new ArrayList<SpecItemReferenceDiff>();
        ArrayList<SpecItemReferenceDiff> referencesInChangedCode = new ArrayList<SpecItemReferenceDiff>();
        this.calculateReferencesDelta(addedReferences, removedReferences, referencesInChangedCode);
        List<ArchitectureComponentSpecItemDelta> architectureImpactedItems = this.calculateSpecItemsImpactedThroughArchitectureMapping();
        List<SpecItemReferenceDiff> referenceDiffs = Stream.of(addedReferences, removedReferences, referencesInChangedCode).flatMap(Collection::stream).collect(Collectors.toList());
        return new ImpactedSpecItemsDelta(referenceDiffs, architectureImpactedItems);
    }

    private List<ArchitectureComponentSpecItemDelta> calculateSpecItemsImpactedThroughArchitectureMapping() throws StorageException {
        ArchitectureComponentSpecItemMapper mapper = new ArchitectureComponentSpecItemMapper(this.indexHelper.getHistoryAccessOptionAtSourceHead(), this.indexHelper.getProjectStorageSystem(), this.indexHelper.getGlobalStorageSystem(), this.indexHelper.getMergeBaseInfo(), this.indexHelper.getSourceBranchHead().getBranchName());
        return mapper.computeArchitectureComponentSpecItemDelta();
    }

    private void calculateReferencesDelta(List<SpecItemReferenceDiff> addedReferences, List<SpecItemReferenceDiff> removedReferences, List<SpecItemReferenceDiff> referencesInChangedCode) throws StorageException {
        for (String uniformPath : this.affectedUniformPaths) {
            HashSet<IssueReference> issueReferencesForPathAtMergeBase = new HashSet<IssueReference>(this.issueReferencesAtMergeBase.getOrDefault(uniformPath, new ArrayList()));
            HashSet<IssueReference> issueReferencesForPathAtSourceHead = new HashSet<IssueReference>(this.issueReferencesAtSourceHead.getOrDefault(uniformPath, new ArrayList()));
            Set<TeamscaleIssueId> issueReferenceIdsIntersection = issueReferencesForPathAtSourceHead.stream().map(IssueReference::getId).collect(Collectors.toSet());
            issueReferenceIdsIntersection.retainAll(issueReferencesForPathAtMergeBase.stream().map(IssueReference::getId).collect(Collectors.toSet()));
            this.splitAddedAndRemovedRefsFromRefsInModifiedCode(uniformPath, issueReferenceIdsIntersection, addedReferences, removedReferences, referencesInChangedCode);
            issueReferencesForPathAtMergeBase.removeIf(issueReference -> issueReferenceIdsIntersection.contains(issueReference.getId()));
            issueReferencesForPathAtSourceHead.removeIf(issueReference -> issueReferenceIdsIntersection.contains(issueReference.getId()));
            this.fillAddedReferencesForUniqueSpecItemIds(uniformPath, issueReferencesForPathAtSourceHead, addedReferences);
            this.fillRemovedReferencesForUniqueSpecItemIds(uniformPath, issueReferencesForPathAtMergeBase, removedReferences);
        }
    }

    private void splitAddedAndRemovedRefsFromRefsInModifiedCode(String uniformPath, Set<TeamscaleIssueId> issueReferenceIds, List<SpecItemReferenceDiff> addedReferences, List<SpecItemReferenceDiff> removedReferences, List<SpecItemReferenceDiff> referencesInChangedCode) throws StorageException {
        for (TeamscaleIssueId issueReferenceId : issueReferenceIds) {
            Set referencesAtSourceHead = (Set)this.reqCodeRefsByUniformPathAndItemIdAtSourceHead.getValueOrDefault((Object)uniformPath, (Object)issueReferenceId, Collections.emptySet());
            Set referencesAtMergeBase = (Set)this.reqCodeRefsByUniformPathAndItemIdAtMergeBase.getValueOrDefault((Object)uniformPath, (Object)issueReferenceId, Collections.emptySet());
            Set<SpecItemCodeReference> referencesIntersection = MergeRequestImpactedSpecItemsCalculator.determineSpecItemCodeReferenceIntersection(new EntitySignatureComparingStrategy(this.tokenElementsByUniformPathAtMergeBase, this.tokenElementsByUniformPathAtSourceHead, this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), this.specItemTypeInfoById), new MethodHistoryTraversalStrategy(this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), this.indexHelper.getAncestorsOfSource(), this.indexHelper.getProjectStorageSystem(), this.specItemTypeInfoById), uniformPath, issueReferenceId, referencesAtSourceHead, referencesAtMergeBase, referencesInChangedCode);
            referencesAtSourceHead.removeIf(referencesIntersection::contains);
            referencesAtMergeBase.removeIf(referencesIntersection::contains);
            TeamscaleIssueTypeInfo typeInfo = this.specItemTypeInfoById.get(issueReferenceId);
            addedReferences.addAll(referencesAtSourceHead.stream().map(ref -> new SpecItemReferenceDiff(uniformPath, issueReferenceId, ref.getCommentLineNumber(), null, this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), ref.getReferencedShallowEntity(), null, ref.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.ADDED, typeInfo)).toList());
            removedReferences.addAll(referencesAtMergeBase.stream().map(ref -> new SpecItemReferenceDiff(uniformPath, issueReferenceId, null, ref.getCommentLineNumber(), this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), null, ref.getReferencedShallowEntity(), ref.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.REMOVED, typeInfo)).toList());
        }
    }

    private static Set<SpecItemCodeReference> determineSpecItemCodeReferenceIntersection(EntitySignatureComparingStrategy entitySignatureComparingStrategy, MethodHistoryTraversalStrategy methodHistoryTraversalStrategy, String uniformPath, TeamscaleIssueId specItemId, Set<SpecItemCodeReference> referencesAtSourceHead, Set<SpecItemCodeReference> referencesAtMergeBase, List<SpecItemReferenceDiff> referencesInChangedCode) throws StorageException {
        HashSet<SpecItemCodeReference> specItemCodeReferenceIntersection = new HashSet<SpecItemCodeReference>(entitySignatureComparingStrategy.getSpecItemReferenceIntersection(uniformPath, specItemId, referencesAtSourceHead, referencesAtMergeBase, referencesInChangedCode));
        referencesAtSourceHead.removeAll(specItemCodeReferenceIntersection);
        referencesAtMergeBase.removeAll(specItemCodeReferenceIntersection);
        specItemCodeReferenceIntersection.addAll(methodHistoryTraversalStrategy.getSpecItemReferenceIntersection(uniformPath, specItemId, referencesAtSourceHead, referencesAtMergeBase, referencesInChangedCode));
        return specItemCodeReferenceIntersection;
    }

    private void fillAddedReferencesForUniqueSpecItemIds(String uniformPath, Set<IssueReference> issueReferencesForPathAtSourceHead, List<SpecItemReferenceDiff> addedReferences) {
        for (IssueReference issueReference : issueReferencesForPathAtSourceHead) {
            Set specItemCodeReferences = (Set)this.reqCodeRefsByUniformPathAndItemIdAtSourceHead.getValue((Object)uniformPath, (Object)issueReference.getId());
            if (specItemCodeReferences == null) {
                LOGGER.warn("Missing expected code references in '{}' for issue reference '{}'", (Object)uniformPath, (Object)issueReference);
                continue;
            }
            addedReferences.addAll(specItemCodeReferences.stream().map(ref -> new SpecItemReferenceDiff(uniformPath, issueReference.getId(), ref.getCommentLineNumber(), null, this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), ref.getReferencedShallowEntity(), null, ref.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.ADDED, this.specItemTypeInfoById.get(issueReference.getId()))).collect(Collectors.toList()));
        }
    }

    private void fillRemovedReferencesForUniqueSpecItemIds(String uniformPath, Set<IssueReference> issueReferencesForPathAtMergeBase, List<SpecItemReferenceDiff> removedReferences) {
        for (IssueReference issueReference : issueReferencesForPathAtMergeBase) {
            Set specItemCodeReferences = (Set)this.reqCodeRefsByUniformPathAndItemIdAtMergeBase.getValueOrDefault((Object)uniformPath, (Object)issueReference.getId(), Collections.emptySet());
            removedReferences.addAll(specItemCodeReferences.stream().map(ref -> new SpecItemReferenceDiff(uniformPath, issueReference.getId(), null, ref.getCommentLineNumber(), this.indexHelper.getSourceBranchHead(), this.indexHelper.getMergeBase(), null, ref.getReferencedShallowEntity(), ref.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.REMOVED, this.specItemTypeInfoById.get(issueReference.getId()))).collect(Collectors.toList()));
        }
    }
}

