/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.metric;

import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import com.teamscale.index.simulink.analysis.finding.MaximumBlocksInSubsystemFinding;
import java.util.Collection;
import java.util.Collections;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkMetricAnalysis(name="Maximum Blocks in Subsystem", description="Counts the maximum number of blocks in a subsystem for a model.", internalName="#max-blocks-in-subsystem", metricProperties={}, qualityIndicator="Structure", aggregation=MetricDirectorySchemaEntry.EAggregation.MAX)
public class MaximumBlocksInSubsystemMetric
extends SimulinkMetricAnalysisBase {
    @Override
    public Double calculateMetricValue(SimulinkModel model) {
        long maxBlocksInSubsytem = MaximumBlocksInSubsystemFinding.countIgnoringCommentedBlocks((Collection<SimulinkBlock>)model.getSubBlocks());
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)true, (boolean)false)) {
            maxBlocksInSubsytem = Math.max(maxBlocksInSubsytem, MaximumBlocksInSubsystemFinding.countIgnoringCommentedBlocks((Collection<SimulinkBlock>)block.getSubBlocks()));
        }
        return maxBlocksInSubsytem;
    }
}

