/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.openai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.openai.OpenAiClient;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="ai-engine.openai", name="OpenAI Provider", visibilityFeatureToggle=EFeatureToggle.AI_SUPPORT, type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AI, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class OpenAiEngineProviderOption
extends AiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="model")
    @OptionFieldDescription(name="The name of the OpenAI model to use, such as 'gpt-3.5-turbo'")
    public String model;
    @JsonProperty(value="apiKey")
    @PasswordOption
    @OptionFieldDescription(name="The API key to use for OpenAI.")
    public String apiKey;

    @Override
    public String getInternalName() {
        return "openai." + this.model;
    }

    @Override
    public String getDisplayName() {
        return "OpenAI (" + this.model + ")";
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            Optional<String> modelOwner = new OpenAiClient(this.model, this.apiKey, 0.0, null).getModelOwner();
            if (modelOwner.isEmpty()) {
                return "Could not ensure model existence. Likely the model name is not valid.";
            }
        }
        catch (ServiceCallException e) {
            return e.getMessage();
        }
        return super.validate(storageInfo, instanceConfiguration);
    }

    @Override
    public Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> usageReporter) {
        return Optional.of(new OpenAiClient(this.model, this.apiKey, this.temperature, usageReporter));
    }
}

