/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.crowd.client.CrowdGroup;
import com.teamscale.core.authenticate.crowd.client.CrowdUser;
import com.teamscale.core.authenticate.crowd.client.ICrowdNamedEntity;
import com.teamscale.core.authenticate.crowd.client.ICrowdSearchRestriction;
import com.teamscale.core.rest.client.IRetrofitApi;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface ICrowdClient
extends IRetrofitApi {
    public static final String BASE_PATH = "rest/usermanagement/1/";

    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    @POST(value="rest/usermanagement/1/authentication")
    public CrowdUser authenticateUser(@Query(value="username") String var1, @Body PasswordBody var2) throws ServiceCallException;

    @Headers(value={"Accept: application/json"})
    @GET(value="rest/usermanagement/1/user")
    public @Nullable CrowdUser getUser(@Query(value="username") String var1) throws ServiceCallException;

    @GET(value="rest/usermanagement/1/group")
    @Headers(value={"Accept: application/json"})
    public Call<CrowdGroup> getGroup(@Query(value="groupname") String var1);

    @Headers(value={"Accept: application/json"})
    @GET(value="rest/usermanagement/1/group/user/nested?expand=user")
    public @Nullable GetNestedUsersResponse getNestedUsersOfGroup(@Query(value="groupname") String var1, @Query(value="start-index") int var2, @Query(value="max-results") int var3) throws ServiceCallException;

    @Headers(value={"Accept: application/json"})
    @GET(value="rest/usermanagement/1/user/group/nested?expand=group")
    public @Nullable GetNestedGroupsResponse getNestedGroupsOfUser(@Query(value="username") String var1, @Query(value="start-index") int var2, @Query(value="max-results") int var3) throws ServiceCallException;

    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    @POST(value="rest/usermanagement/1/search")
    public ISearchResult search(@Query(value="entity-type") EEntityType var1, @Body ICrowdSearchRestriction var2, @Query(value="start-index") int var3, @Query(value="max-results") int var4) throws ServiceCallException;

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="expand")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=GroupSearchResult.class), @JsonSubTypes.Type(value=UserSearchResult.class)})
    public static sealed interface ISearchResult {
        public List<? extends ICrowdNamedEntity> getResults();

        @JsonTypeName(value="user")
        public record UserSearchResult(@JsonProperty(value="users") List<CrowdUser> users) implements ISearchResult
        {
            public List<CrowdUser> getResults() {
                return CollectionUtils.asUnmodifiable(this.users);
            }
        }

        @JsonTypeName(value="group")
        public record GroupSearchResult(@JsonProperty(value="groups") List<CrowdGroup> groups) implements ISearchResult
        {
            public List<CrowdGroup> getResults() {
                return CollectionUtils.asUnmodifiable(this.groups);
            }
        }
    }

    public record GetNestedUsersResponse(@JsonProperty(value="users") List<CrowdUser> nestedUsers) {
    }

    public record PasswordBody(@JsonProperty(value="value") String password) {
        public PasswordBody {
            CCSMAssert.isNotNull((Object)password, () -> String.format("Expected \"%s\" to be not null", "password"));
        }
    }

    public static enum EEntityType {
        USER,
        GROUP;

    }

    public record GetNestedGroupsResponse(@JsonProperty(value="groups") List<CrowdGroup> nestedGroups) {
    }
}

