/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.ShortLogEntryBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ShortWorkerLog
extends ShortLogEntryBase {
    private static final long serialVersionUID = 1L;
    private static final String NO_COMMIT_FILTER_STRING = "none";
    private static final String WORKER_ID_PROPERTY_NAME = "workerId";
    private static final String TRIGGER_NAME_PROPERTY_NAME = "triggerName";
    private static final String FINISH_TIME_PROPERTY_NAME = "finishTime";
    private static final String FAILED_PROCESSORS_PROPERTY_NAME = "hasFailed";
    private static final String ANALYZED_COMMIT_PROPERTY_NAME = "analyzedCommit";
    private static final String INPUT_DELTA_SIZE_PROPERTY_NAME = "inputDeltaSize";
    private static final String HAS_DETAILED_LOG_PROPERTY_NAME = "hasDetailedLog";
    private static final String OCCURRENCES_PROPERTY_NAME = "occurrences";
    @JsonProperty(value="workerId")
    private final String workerId;
    @JsonProperty(value="triggerName")
    private final String triggerName;
    @JsonProperty(value="finishTime")
    private final long finishTime;
    @JsonProperty(value="hasFailed")
    private final boolean hasFailed;
    @JsonProperty(value="analyzedCommit")
    private final @Nullable CommitDescriptor analyzedCommit;
    @JsonProperty(value="inputDeltaSize")
    private final int inputDeltaSize;
    @JsonProperty(value="hasDetailedLog")
    public final boolean hasDetailedLog;
    @JsonProperty(value="occurrences")
    private @Nullable ArrayList<Long> occurrences;

    public ShortWorkerLog(String workerId, InternalProjectId projectId, String triggerName, LogEntryIdentifier logEntryIdentifier, long finishTime, boolean hasFailed, LogCount logCount, @Nullable CommitDescriptor analyzedCommit, int inputDeltaSize, boolean hasDetailedLog) {
        super(logEntryIdentifier, logCount, (IProjectId)projectId);
        this.workerId = workerId;
        this.triggerName = triggerName;
        this.finishTime = finishTime;
        this.hasFailed = hasFailed;
        this.analyzedCommit = analyzedCommit;
        this.inputDeltaSize = inputDeltaSize;
        this.hasDetailedLog = hasDetailedLog;
    }

    @JsonCreator
    @TestOnly
    protected ShortWorkerLog(@JsonProperty(value="workerId") String workerId, @JsonProperty(value="projectName") PublicProjectId projectId, @JsonProperty(value="triggerName") String triggerName, @JsonProperty(value="id") LogEntryIdentifier entryIdentifier, @JsonProperty(value="finishTime") long finishTime, @JsonProperty(value="hasFailed") boolean hasFailed, @JsonProperty(value="logCount") LogCount logCount, @JsonProperty(value="analyzedCommit") @Nullable CommitDescriptor analyzedCommit, @JsonProperty(value="inputDeltaSize") int inputDeltaSize, @JsonProperty(value="hasDetailedLog") boolean hasDetailedLog) {
        super(entryIdentifier, logCount, (IProjectId)projectId);
        this.workerId = workerId;
        this.triggerName = triggerName;
        this.finishTime = finishTime;
        this.hasFailed = hasFailed;
        this.analyzedCommit = analyzedCommit;
        this.inputDeltaSize = inputDeltaSize;
        this.hasDetailedLog = hasDetailedLog;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public long getStartTime() {
        return this.getTimestamp();
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public @Nullable CommitDescriptor getAnalyzedCommit() {
        return this.analyzedCommit;
    }

    public int getInputDeltaSize() {
        return this.inputDeltaSize;
    }

    public @Nullable ArrayList<Long> getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(List<Long> occurrences) {
        this.occurrences = new ArrayList(CollectionUtils.sort(occurrences));
    }

    public String toString() {
        return "ShortWorkerLog [workerId=" + this.workerId + ", projectName=" + String.valueOf(this.getProjectId()) + ", triggerName=" + this.triggerName + ", finishTime=" + this.finishTime + ", analyzedCommit=" + String.valueOf(this.analyzedCommit) + "]";
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.workerId, this.triggerName, Optional.ofNullable(this.getAnalyzedCommit()).map(commit -> commit.getTimestamp() + "@" + commit.getBranchName()).orElse(NO_COMMIT_FILTER_STRING), Long.toString(this.finishTime - this.getStartTime())));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append(this.triggerName).append(" ");
        if (this.analyzedCommit == null) {
            builder.append(NO_COMMIT_FILTER_STRING);
        } else {
            builder.append(this.analyzedCommit);
        }
        builder.append(" ");
        builder.append(this.workerId).append(" ");
        builder.append("took ").append(this.finishTime - this.getStartTime()).append("ms ");
    }

    @Override
    public LogIndexBase.EIndexLogLevel getIndexLogLevel() {
        if (this.hasFailed()) {
            return LogIndexBase.EIndexLogLevel.FATAL;
        }
        return super.getIndexLogLevel();
    }
}

