/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.cache.IndexWithCache;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Index(name="user-groups", options={EStorageOption.BACKUP})
@IndexWithCache(value={PermissionCache.class})
public class UserGroupIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "user-groups";
    private final SynchronizedCacheAccess<PermissionCache> synchronizedCacheAccess;
    private final ValueIndex<UserGroup> delegate;
    private final IStore store;

    public UserGroupIndex(IStore store, SynchronizedCacheAccess<PermissionCache> synchronizedCacheAccess) {
        this.store = store;
        this.delegate = ValueIndex.forSerializable((IStore)store);
        this.synchronizedCacheAccess = synchronizedCacheAccess;
    }

    public List<UserGroup> getGroupsForUser(User user) throws StorageException {
        return CollectionUtils.filter((Collection)this.delegate.getValues(new ArrayList<String>(user.getGroupIds())), Objects::nonNull);
    }

    public @Nullable UserGroup getUserGroup(String groupName) throws StorageException {
        return (UserGroup)this.delegate.getValue(groupName);
    }

    public PairList<String, UserGroup> getAllUserGroups() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public Collection<String> getAllGroupNames() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public List<@Nullable UserGroup> getUserGroups(List<String> groupNames) throws StorageException {
        return this.delegate.getValues(groupNames);
    }

    private void invalidateCaches(String reason) {
        this.synchronizedCacheAccess.invalidate(reason);
    }

    public void setGroup(UserGroup group) throws StorageException {
        this.setGroups(Collections.singletonList(group));
    }

    public void setGroups(List<UserGroup> groups) throws StorageException {
        PairList keysAndValues = new PairList();
        groups.forEach(group -> keysAndValues.add((Object)group.getName(), group));
        this.delegate.setValues(keysAndValues);
        this.invalidateCaches("Groups updated: " + String.valueOf(keysAndValues.extractFirstList()));
    }

    public void removeGroup(String groupName) throws StorageException {
        this.delegate.removeValue(groupName);
        this.invalidateCaches("Group removed: " + groupName);
    }

    public Lock getUpdateLock() {
        return this.store.obtainLock("update");
    }
}

