/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.util.List;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class XXHashUtils {
    private static final XXHashFactory FACTORY = XXHashFactory.fastestInstance();

    public static long xxhash64(byte[] data) {
        return FACTORY.hash64().hash(data, 0, data.length, 0L);
    }

    public static long xxhash64(String string) {
        return XXHashUtils.xxhash64(StringUtils.stringToBytes((String)string));
    }

    public static String xxhash64(List<String> strings) {
        try (StreamingXXHash64 hash = XXHashUtils.streamingHash64();){
            strings.forEach(path -> XXHashUtils.updateHash(hash, path));
            String string = XXHashUtils.asReadableString(hash);
            return string;
        }
    }

    public static StreamingXXHash64 streamingHash64() {
        return FACTORY.newStreamingHash64(0L);
    }

    public static int hash32(byte[] bytes) {
        return FACTORY.hash32().hash(bytes, 0, bytes.length, 0);
    }

    public static void updateHash(StreamingXXHash64 hash, byte[] data) {
        hash.update(data, 0, data.length);
    }

    public static void updateHash(StreamingXXHash64 hash, String s) {
        XXHashUtils.updateHash(hash, StringUtils.stringToBytes((String)s));
    }

    public static String asReadableString(StreamingXXHash64 hash) {
        return Long.toHexString(hash.getValue());
    }

    private XXHashUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

