/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.CppLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-cpp-forbidden-types", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class CppForbiddenTypesCheck
extends CheckImplementationBase {
    @CheckOption(name="Forbidden types", description="The list of types that are forbidden to use.")
    private List<String> forbiddenTypes = new ArrayList<String>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ITypeInfoExtractor cppTypeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)ELanguage.CPP, null);
    private final ITypeInfoExtractor msCliCppTypeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)ELanguage.CPP_MS_CLI, null);

    public void execute() throws CheckException {
        if (this.forbiddenTypes.isEmpty()) {
            this.logger.info("An option needs to be configured for {} to produce findings", (Object)((Object)((Object)this)).getClass().getSimpleName());
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        switch (entity.getType()) {
            case METHOD: {
                this.handleMethod(entity);
                break;
            }
            case ATTRIBUTE: 
            case STATEMENT: {
                this.handleDeclaringEntity(entity, new String[0]);
            }
        }
    }

    private void handleMethod(ShallowEntity entity) throws CheckException {
        String returnTypeName = LanguageFeatureParser.CPP.getReturnType(entity);
        this.handleDeclaringEntity(entity, returnTypeName);
    }

    private void handleDeclaringEntity(ShallowEntity entity, String ... additionalTypeNames) throws CheckException {
        Set importedNamespaces = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity).getImportedNamespaces();
        List typedVariables = Collections.emptyList();
        if (this.context.getLanguage() == ELanguage.CPP) {
            typedVariables = this.cppTypeInfoExtractor.extract(entity);
        } else if (this.context.getLanguage() == ELanguage.CPP_MS_CLI) {
            typedVariables = this.msCliCppTypeInfoExtractor.extract(entity);
        }
        List otherNames = LanguageFeatureParser.CPP.getGenericTypeNames((List)entity.ownStartTokens());
        otherNames.addAll(Arrays.asList(additionalTypeNames));
        for (String name : CppForbiddenTypesCheck.reduceToPlainTypeSet(typedVariables, otherNames)) {
            this.checkTypeName(entity, importedNamespaces, name);
        }
    }

    private void checkTypeName(ShallowEntity entity, Set<String> importedNamespaces, String typeName) throws CheckException {
        for (String forbiddenTypeName : this.forbiddenTypes) {
            if (!LanguageFeatureParser.CPP.matchesFullQualifiedTypeName(typeName, importedNamespaces, forbiddenTypeName)) continue;
            this.buildFinding("Type `" + forbiddenTypeName + "` should not be used", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private static Set<String> reduceToPlainTypeSet(List<TypedVariable> typedVariables, List<String> additionalTypeNames) {
        List names = CollectionUtils.map(typedVariables, TypedVariable::getTypeNameWithoutGenericTypeParameter);
        names.addAll(additionalTypeNames);
        return names.stream().filter(Objects::nonNull).map(arg_0 -> ((CppLanguageFeatureParser)LanguageFeatureParser.CPP).getPlainTypeName(arg_0)).collect(Collectors.toSet());
    }
}

