/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.binary_size;

import eu.cqse.check.cpp.binary_size.MacroExpansionsOriginPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-macro-expansions-frequent-size", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={MacroExpansionsOriginPhase.class})
public class MacroExpansionsFrequencyCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_SHOWN_MACRO_USAGE_FILES = 5;
    @CheckOption(name="Minimum number of expansions", description="The number of times a macro definition must at least be used/expanded to be considered by the check")
    private int minNumberOfExpansions = 5;
    @CheckOption(name="Minimum expansion size", description="The minimum average size of the expansion (counted in tokens) to be considered by the check")
    private int minAverageExpansionSize = 20;

    public void execute() throws CheckException {
        List expansionsUsingDefinitionsInCurrentFile = (List)this.context.accessPhaseInvertedResult(MacroExpansionsOriginPhase.class).apply(this.context.getUniformPath());
        Map<Integer, List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable>> expansionsByDefinitionLine = MacroExpansionsFrequencyCheck.groupExpansionsByDefinitionLine(expansionsUsingDefinitionsInCurrentFile);
        for (Map.Entry<Integer, List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable>> expansionsFromDefinition : expansionsByDefinitionLine.entrySet()) {
            List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable> expansions = expansionsFromDefinition.getValue();
            int definitionLineNumber = expansionsFromDefinition.getKey() + 1;
            this.checkExpansionsFromDefinitionInLineNumber(expansions, definitionLineNumber);
        }
    }

    private void checkExpansionsFromDefinitionInLineNumber(List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable> expansions, int definitionLineNumber) throws CheckException {
        int numberOfExpansions = expansions.size();
        int averageExpansionsSize = expansions.stream().map(m -> m.getAdditionalInformation().expansionTokenSize()).reduce(0, Integer::sum) / numberOfExpansions;
        if (numberOfExpansions < this.minNumberOfExpansions || averageExpansionsSize < this.minAverageExpansionSize) {
            return;
        }
        String macroName = expansions.get(0).getAdditionalInformation().macroName();
        Optional<IToken> macroDefinitionToken = MacroExpansionsFrequencyCheck.findMacroDefinitionTokenInLine((List<IToken>)this.context.getTokens(ECodeViewOption.FILTERED), definitionLineNumber);
        if (macroDefinitionToken.isEmpty() || macroDefinitionToken.get().getType() != ETokenType.PREPROCESSOR_DIRECTIVE) {
            LOGGER.error("Could not find macro definition of `{}` at line {}, ignoring this finding.", (Object)macroName, (Object)definitionLineNumber);
            return;
        }
        if (MacroExpansionsFrequencyCheck.macroDefinitionCantBeConvertedToFunction(macroDefinitionToken.get())) {
            return;
        }
        String findingMessage = "Macro " + MarkupUtils.formatAsSourceCode((String)macroName) + " is expanded " + numberOfExpansions + " times with " + averageExpansionsSize + " tokens (average expansion size)";
        FindingPropertyList findingProperties = new FindingPropertyList();
        List<String> filesWithExpansions = MacroExpansionsFrequencyCheck.collectExpansionPathSamples(expansions);
        findingProperties.addProperty("Macro usage paths", (Object)String.join((CharSequence)"\n", filesWithExpansions));
        findingProperties.addProperty("Number of invocations", (Object)numberOfExpansions);
        findingProperties.addProperty("Average expansion size", (Object)averageExpansionsSize);
        int averageOperationsCount = expansions.stream().map(m -> m.getAdditionalInformation().operationsCount()).reduce(0, Integer::sum) / numberOfExpansions;
        findingProperties.addProperty("Average operations count", (Object)averageOperationsCount);
        List secondaryLocations = CollectionUtils.map(filesWithExpansions, ElementLocation::new);
        this.buildFinding(findingMessage, this.buildLocation().forLine(definitionLineNumber, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).addFindingProperties(findingProperties).addSecondaryLocations(secondaryLocations).createAndStore();
    }

    private static boolean macroDefinitionCantBeConvertedToFunction(IToken macroDefinitionToken) {
        String tokenText = macroDefinitionToken.getText();
        tokenText = tokenText.replaceAll("\\s", " ").replaceAll("\".*\"", "");
        if ((tokenText = StringUtils.stripPrefix((String)tokenText.stripLeading(), (String)"#")).contains(" struct ") || tokenText.contains(" enum ") || tokenText.contains(" class ")) {
            return true;
        }
        return tokenText.contains("#");
    }

    private static Optional<IToken> findMacroDefinitionTokenInLine(List<IToken> tokens, int macroDefinitionLineNumber) {
        int zeroBasedMacroDefinitionLineNumber = macroDefinitionLineNumber - 1;
        int leftSearchBoundary = 0;
        int rightSearchBoundary = tokens.size() - 1;
        int matchingIndex = -1;
        while (leftSearchBoundary <= rightSearchBoundary) {
            int currentIndex = (leftSearchBoundary + rightSearchBoundary) / 2;
            if (tokens.get(currentIndex).getLineNumber() < zeroBasedMacroDefinitionLineNumber) {
                leftSearchBoundary = currentIndex + 1;
                continue;
            }
            if (tokens.get(currentIndex).getLineNumber() > zeroBasedMacroDefinitionLineNumber) {
                rightSearchBoundary = currentIndex - 1;
                continue;
            }
            matchingIndex = currentIndex;
            break;
        }
        if (matchingIndex == -1) {
            return Optional.empty();
        }
        while (matchingIndex > 0 && tokens.get(matchingIndex - 1).getLineNumber() == zeroBasedMacroDefinitionLineNumber) {
            --matchingIndex;
        }
        return Optional.of(tokens.get(matchingIndex));
    }

    private static @NonNull List<String> collectExpansionPathSamples(List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable> expansions) {
        HashSet<String> filesWithExpansions = new HashSet<String>();
        for (MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable expansion : expansions) {
            if (filesWithExpansions.size() >= 5) break;
            filesWithExpansions.add(expansion.getAdditionalInformation().expansionLocationUniformPath());
        }
        return CollectionUtils.sort(filesWithExpansions);
    }

    private static @NonNull Map<Integer, List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable>> groupExpansionsByDefinitionLine(List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable> expansionsUsingDefinitionsInCurrentFile) {
        HashMap<Integer, List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable>> expansionsByDefinitionLine = new HashMap<Integer, List<MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable>>();
        for (MacroExpansionsOriginPhase.MacroExpansionOriginAndSizeExtractable expansion : expansionsUsingDefinitionsInCurrentFile) {
            int definitionLineNumber = expansion.getAdditionalInformation().macroDefinitionLineNumber();
            if (!expansionsByDefinitionLine.containsKey(definitionLineNumber)) {
                expansionsByDefinitionLine.put(definitionLineNumber, new ArrayList());
            }
            ((List)expansionsByDefinitionLine.get(definitionLineNumber)).add(expansion);
        }
        return expansionsByDefinitionLine;
    }
}

