/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Check(id="cqse-unreachable-code-after-exit-statement", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.ESQL, ELanguage.GROOVY, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.PHP, ELanguage.XTEND, ELanguage.PYTHON, ELanguage.GO}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnreachableCodeAfterExitStatementCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> EXIT_STATEMENT_TOKENS = EnumSet.of(ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.RAISE, ETokenType.RETURN, ETokenType.THROW);
    private static final Set<String> ALLOWED_META_SUBTYPES = Set.of("case", "default", "label");
    private final Set<Integer> seenLocations = new HashSet<Integer>();

    private static boolean isAllowedStatement(@NonNull ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && ALLOWED_META_SUBTYPES.contains(entity.getSubtype());
    }

    private static @NonNull IToken getFirstToken(@NonNull List<ShallowEntity> entities) {
        return (IToken)entities.getFirst().ownStartTokens().getFirst();
    }

    private static @Nullable IToken getLastToken(@NonNull List<ShallowEntity> entities) {
        ShallowEntity lastEntity = entities.getLast();
        int lastIndex = lastEntity.getEndTokenIndex() - 1;
        if (CollectionUtils.isValidIndex((int)lastIndex, (List)lastEntity.getAllTokensOfFile())) {
            return (IToken)lastEntity.getAllTokensOfFile().get(lastIndex);
        }
        return null;
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        this.seenLocations.clear();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if ((!"simple statement".equals(statement.getSubtype()) || !TokenStreamUtils.containsAny((List)statement.ownStartTokens(), EXIT_STATEMENT_TOKENS)) && !"return".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (this.exitTokenIsFromMacro(entity) || this.isCsYieldStatement(entity) || this.isElvisFollowedByThrowOrReturnKotlin(entity) || this.isThrowAfterNullCoalescingOperator(entity)) {
            return;
        }
        if (this.seenLocations.contains(entity.getStartLine())) {
            return;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return;
        }
        UnmodifiableList siblings = parent.getChildren();
        List<Object> unreachableEntities = siblings.stream().dropWhile(child -> child != entity).takeWhile(child -> !UnreachableCodeAfterExitStatementCheck.isAllowedStatement(child)).toList();
        if ((unreachableEntities = unreachableEntities.stream().filter(unreachableEntity -> !UnreachableCodeAfterExitStatementCheck.isEmptyStatement(unreachableEntity) && !UnreachableCodeAfterExitStatementCheck.isPragmaDirectiveStatement(unreachableEntity)).toList()).size() <= 1 || this.isAffectedByPreprocessing(unreachableEntities)) {
            return;
        }
        IToken endToken = UnreachableCodeAfterExitStatementCheck.getLastToken(unreachableEntities = unreachableEntities.stream().skip(1L).toList());
        if (endToken == null) {
            return;
        }
        IToken startToken = UnreachableCodeAfterExitStatementCheck.getFirstToken(unreachableEntities);
        this.buildFinding("Unreachable code after exit statement", this.buildLocation().betweenTokens(startToken, endToken)).createAndStore();
        this.seenLocations.addAll(IntStream.rangeClosed(((ShallowEntity)unreachableEntities.getFirst()).getStartLine(), ((ShallowEntity)unreachableEntities.getLast()).getEndLine()).boxed().collect(Collectors.toSet()));
    }

    private static boolean isPragmaDirectiveStatement(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("pragma directive");
    }

    private static boolean isEmptyStatement(ShallowEntity entity) {
        return entity.getSubtype().equals("empty statement");
    }

    private boolean isCsYieldStatement(ShallowEntity entity) {
        return this.context.getLanguage() == ELanguage.CS && "yield".equals(entity.getName());
    }

    private boolean isAffectedByPreprocessing(@NonNull List<ShallowEntity> entities) throws CheckException {
        if (!PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage())) {
            return false;
        }
        ShallowEntity firstEntity = entities.getFirst();
        ShallowEntity lastEntity = entities.getLast();
        List allTokensOfFile = firstEntity.getAllTokensOfFile();
        List<IToken> allRawTokensOfFile = this.context.getTokens(ECodeViewOption.FILTERED).stream().filter(token -> !TokenUtils.isCommentToken((IToken)token)).toList();
        return PreprocessedTokenStreamUtils.areTokensAffectedByPreprocessing((int)firstEntity.getStartTokenIndex(), (int)lastEntity.getEndTokenIndex(), (List)allTokensOfFile, allRawTokensOfFile);
    }

    private boolean exitTokenIsFromMacro(ShallowEntity entity) {
        return PreprocessorUtils.hasPreprocessor((ELanguage)this.context.getLanguage()) && PreprocessedTokenStreamUtils.firstTokenOfTypeIsFromMacro((List)entity.ownStartTokens(), EXIT_STATEMENT_TOKENS);
    }

    private boolean isElvisFollowedByThrowOrReturnKotlin(ShallowEntity entity) {
        if (this.context.getLanguage() != ELanguage.KOTLIN) {
            return false;
        }
        UnmodifiableList includedTokens = entity.includedTokens();
        return TokenStreamUtils.containsSequence((List)includedTokens, (ITokenMatcher[])new ITokenMatcher[]{ETokenType.ELVIS, ETokenType.THROW.or(new ITokenMatcher[]{ETokenType.RETURN})});
    }

    private boolean isThrowAfterNullCoalescingOperator(ShallowEntity entity) {
        EnumSet<ELanguage> languagesWithNullCoalescingOperator = EnumSet.of(ELanguage.CS, ELanguage.PHP);
        return languagesWithNullCoalescingOperator.contains(this.context.getLanguage()) && TokenStreamUtils.containsSequence((List)entity.includedTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.DOUBLE_QUESTION, ETokenType.THROW});
    }
}

