/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="java:S6806", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class ModelAttributeNamingConventionForSpELCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher ADD_ATTRIBUTE_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.ui.Model"}).withTargetMethodNames(new String[]{"addAttribute"}).withParameterCount(2, 2);
    private static final JavaMethodCallMatcher ADD_ALL_ATTRIBUTES_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"org.springframework.ui.Model"}).withTargetMethodNames(new String[]{"addAllAttributes"}).withParameterCount(1, 1);
    private static final Pattern NAMING_CONVENTION_PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
    private static final JavaMethodCallMatcher MAP_OF_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.util.Map"}).withTargetMethodNames(new String[]{"of"});
    private static final JavaMethodCallMatcher MAP_ENTRY_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.util.Map"}).withTargetMethodNames(new String[]{"entry"}).withParameterCount(2);
    private static final TokenPattern INIT_WITH_STRING_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.EQ, ETokenType.STRING_LITERAL, ETokenType.SEMICOLON}).group(0);
    private static final String FINDING_MESSAGE = " does not match naming convention";
    private JavaImportSensitiveTypeResolver typeResolver;
    private ITypeResolution typeResolution;
    private Map<String, String> attributeNamesToStringLiteral;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        this.typeResolution = this.context.getTypeResolution(this.getCodeViewOption());
        this.resolveAttributes();
        for (JavaMethodCallMatcher.MethodCall addAttributeCall : ADD_ATTRIBUTE_MATCHER.find(this.context, this.typeResolver)) {
            List key = (List)addAttributeCall.parameters().getFirst();
            this.checkNamingConvention(key);
        }
        for (JavaMethodCallMatcher.MethodCall addAllAttributesCall : ADD_ALL_ATTRIBUTES_MATCHER.find(this.context, this.typeResolver)) {
            this.checkAddAllAttributesMapOf(addAllAttributesCall);
            this.checkAddAllAttributesMapEntry(addAllAttributesCall);
        }
    }

    private void resolveAttributes() throws CheckException {
        this.attributeNamesToStringLiteral = new HashMap<String, String>();
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.ATTRIBUTE), Set.of("attribute"));
        for (ShallowEntity attribute : attributes) {
            String text;
            TokenPatternMatch firstMatch = INIT_WITH_STRING_PATTERN.findFirstMatch((List)attribute.ownStartTokens());
            if (firstMatch == null || NAMING_CONVENTION_PATTERN.matcher((text = ((IToken)firstMatch.groupTokens(0).get(1)).getText()).substring(1, text.length() - 1)).matches()) continue;
            this.attributeNamesToStringLiteral.put(attribute.getName(), text);
        }
    }

    private void checkAddAllAttributesMapOf(JavaMethodCallMatcher.MethodCall addAllAttributesCall) throws CheckException {
        List matches = MAP_OF_MATCHER.find(addAllAttributesCall.entity(), this.typeResolution, this.typeResolver);
        if (matches.size() != 1) {
            return;
        }
        for (int i = 0; i < ((JavaMethodCallMatcher.MethodCall)matches.getFirst()).parameters().size(); i += 2) {
            this.checkNamingConvention((List)((JavaMethodCallMatcher.MethodCall)matches.getFirst()).parameters().get(i));
        }
    }

    private void checkAddAllAttributesMapEntry(JavaMethodCallMatcher.MethodCall addAllAttributesCall) throws CheckException {
        List matches = MAP_ENTRY_MATCHER.find(addAllAttributesCall.entity(), this.typeResolution, this.typeResolver);
        for (JavaMethodCallMatcher.MethodCall entryMatch : matches) {
            if (entryMatch.parameters().size() != 2) continue;
            this.checkNamingConvention((List)entryMatch.parameters().getFirst());
        }
    }

    private void checkNamingConvention(List<IToken> tokens) throws CheckException {
        String text;
        if (tokens.size() != 1) {
            return;
        }
        IToken token = tokens.getFirst();
        if (token.getType() == ETokenType.IDENTIFIER) {
            this.checkIdentifier(token);
        } else if (token.getType() == ETokenType.STRING_LITERAL && !NAMING_CONVENTION_PATTERN.matcher((text = token.getText()).substring(1, text.length() - 1)).matches()) {
            this.buildFinding(MarkupUtils.formatAsSourceCode((String)text) + FINDING_MESSAGE, this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private void checkIdentifier(IToken token) throws CheckException {
        String attributeValue = this.attributeNamesToStringLiteral.get(token.getText());
        if (attributeValue != null) {
            this.buildFinding(MarkupUtils.formatAsSourceCode((String)attributeValue) + FINDING_MESSAGE, this.buildLocation().forToken(token)).createAndStore();
        }
    }
}

