/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-private-methods-must-not-be-final", languages={ELanguage.JAVA, ELanguage.XTEND}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PrivateMethodsMustNotBeFinalCheck
extends CheckImplementationBase {
    private static final String SAFE_VARARGS = "SafeVarargs";

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("method") || !TokenStreamUtils.containsAny((List)method.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PRIVATE})) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        ShallowEntity siblingEntity;
        UnmodifiableList siblings = entity.getParent().getChildren();
        for (int i = siblings.indexOf(entity) - 1; i >= 0 && (siblingEntity = (ShallowEntity)siblings.get(i)).getType() == EShallowEntityType.META; --i) {
            if (!TokenStreamTextUtils.contains((List)siblingEntity.includedTokens(), (String)SAFE_VARARGS)) continue;
            return;
        }
        int methodStartIndex = TokenStreamUtils.firstTokenMatching((List)entity.includedTokens(), (ITokenMatcher)ETokenType.LPAREN);
        int finalTokenIndex = TokenStreamUtils.firstTokenMatching((List)entity.includedTokens(), (ITokenMatcher)ETokenType.FINAL);
        if (methodStartIndex == -1 || finalTokenIndex == -1) {
            return;
        }
        if (finalTokenIndex < methodStartIndex) {
            this.buildFinding(this.getFindingMessage(entity), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private String getFindingMessage(ShallowEntity entity) {
        return "Private method `" + entity.getName() + "` should not be `final`";
    }
}

