/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.comment;

import eu.cqse.check.java.comment.EJavaDocParameter;
import eu.cqse.check.java.comment.IJavaDocTag;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum EJavaDocInlineTag implements IJavaDocTag
{
    CODE("code", EJavaDocParameter.CODE_PARAMETER),
    DOCROOT("docRoot", new EJavaDocParameter[0]),
    INHERIT_DOC("inheritDoc", new EJavaDocParameter[0]),
    LINK("link", EJavaDocParameter.REFERENCE_PARAMETER, EJavaDocParameter.OPTIONAL_TEXT_PARAMETER),
    LINKPLAIN("linkplain", EJavaDocParameter.REFERENCE_PARAMETER, EJavaDocParameter.OPTIONAL_TEXT_PARAMETER),
    LITERAL("literal", EJavaDocParameter.CODE_PARAMETER),
    VALUE("value", EJavaDocParameter.OPTIONAL_REFERENCE_PARAMETER);

    private final String tagName;
    private final EJavaDocParameter[] parameters;

    private EJavaDocInlineTag(String tagName, EJavaDocParameter ... parameters) {
        this.tagName = tagName;
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return "@" + this.tagName;
    }

    @Override
    public List<EJavaDocParameter> getParameters() {
        return Arrays.asList(this.parameters);
    }

    public String toString() {
        if (this.parameters.length == 0) {
            return String.format("`{%s}`", this.getName());
        }
        return String.format("`{%s %s}`", this.getName(), Arrays.stream(this.parameters).map(EJavaDocParameter::toString).collect(Collectors.joining(" ")));
    }
}

