/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.test.IndexValueClass;

public class TypesWithSpringScopeExtractorPhase
implements IGlobalExtractionPhase<TypeWithSpringScope, SpringScope> {
    public List<TypeWithSpringScope> extract(ITokenElementContext fileContext) throws CheckException {
        ShallowEntity rootEntity = fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED);
        if (SpringChecksUtils.containsNoSpringImport(rootEntity)) {
            return Collections.emptyList();
        }
        List ast = fileContext.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED);
        return ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).stream().map(type -> new TypeWithSpringScope(fileContext.getUniformPath(), LanguageFeatureParser.JAVA.resolveFullyQualifiedTypeName(type), SpringChecksUtils.getScopeOfBean(type))).collect(Collectors.toList());
    }

    public TypeWithSpringScope createValue(String uniformPath, String value, SpringScope additionalInformation) {
        return new TypeWithSpringScope(uniformPath, value, additionalInformation);
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public record TypeWithSpringScope(String uniformPath, String fullyQualifiedClassName, SpringScope springScope) implements IExtractedValue<SpringScope>
    {
        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.fullyQualifiedClassName;
        }

        public SpringScope getAdditionalInformation() {
            return this.springScope;
        }
    }

    @IndexValueClass
    public static enum SpringScope {
        SINGLETON,
        PROTOTYPE,
        REQUEST,
        SESSION,
        APPLICATION,
        WEBSOCKET,
        CUSTOM;

    }
}

