/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.SimulinkNumberPerLevelCheckBase;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.simulink.subsystems-per-level", languages={ELanguage.SIMULINK})
public class SimulinkSubsystemsPerLevelCheck
extends SimulinkNumberPerLevelCheckBase {
    @CheckOption(name="Maximum number of subsystems per level", description="The maximum number of subsystems that are allowed on each level of the model")
    private int subsystemsPerLevelThreshold = 16;
    @CheckOption(name="Maximum number of subsystems on root level", description="The maximum number of subsystems that are allowed on root level of the model")
    private int subsystemsAtRootLevelThreshold = 8;

    @Override
    public String getCountObjectName() {
        return "subsystems";
    }

    @Override
    public int getObjectsPerLevelThreshold() {
        return this.subsystemsPerLevelThreshold;
    }

    @Override
    public int getRootLevelThreshold() {
        return this.subsystemsAtRootLevelThreshold;
    }

    @Override
    public int determineNumberOfObjects(SimulinkBlock block) {
        return (int)block.getSubBlocks().stream().filter(SimulinkUtils::isSubsystem).filter(subBlock -> !SimulinkUtils.isCommentedBlock((SimulinkBlock)subBlock) && SimulinkUtils.isUserVisible((SimulinkBlock)subBlock)).count();
    }
}

