/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.db_0127", languages={ELanguage.SIMULINK})
public class SimulinkMatlabCommandsInStateflowCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "MATLAB command inside stateflow object: {0}";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Replace the MATLAB command or remodel the Stateflow object by moving the MATLAB command into a MATLAB function block.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            StateflowBlock stateflowBlock;
            StateflowChart chart;
            if (!(block instanceof StateflowBlock) || !StateflowUtils.hasActionLanguageC((StateflowChart)(chart = (stateflowBlock = (StateflowBlock)block).getChart()))) continue;
            this.checkStatesInChart(chart);
            this.checkTransitionsInChart(chart);
        }
    }

    private void checkStatesInChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            String script;
            if (node instanceof StateflowState && ((StateflowState)node).isNoteBox() || (script = node.getParameter("labelString")) == null) continue;
            List<String> matlabCommandExpressions = this.extractMatlabCommandExpressionsFromScript(script);
            for (String matlabCommandExpression : matlabCommandExpressions) {
                this.buildFinding(MessageFormat.format(FINDING_MESSAGE, matlabCommandExpression), (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private void checkTransitionsInChart(StateflowChart chart) {
        for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
            String label = transition.getLabel();
            if (label == null) continue;
            List<String> matlabCommandExpressions = this.extractMatlabCommandExpressionsFromScript(label);
            for (String matlabCommandExpression : matlabCommandExpressions) {
                this.buildFinding(MessageFormat.format(FINDING_MESSAGE, matlabCommandExpression), (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    private List<String> extractMatlabCommandExpressionsFromScript(String script) {
        String unescapedScript = StringUtils.unescapeChars((String)script, (Map)StringUtils.ESCAPE_NEWLINE);
        List tokens = ScannerUtils.getTokens((String)unescapedScript, (ELanguage)ELanguage.CPP, (String)this.context.getUniformPath());
        if (tokens.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<String> matlabCommandExpressions = new ArrayList<String>();
        for (int tokenIndex = 1; tokenIndex < tokens.size(); ++tokenIndex) {
            if (!SimulinkMatlabCommandsInStateflowCheck.tokenIsMlNamespaceOrMlFunction((IToken)tokens.get(tokenIndex - 1), (IToken)tokens.get(tokenIndex))) continue;
            matlabCommandExpressions.add(SimulinkMatlabCommandsInStateflowCheck.extractMatlabCommandExpression(tokens, tokenIndex - 1));
        }
        return matlabCommandExpressions;
    }

    private static String extractMatlabCommandExpression(List<IToken> tokens, int matlabCommandStartIndex) {
        StringBuilder matlabCommandExpressionBuilder = new StringBuilder();
        int openingParenCount = 0;
        for (int i = matlabCommandStartIndex; i < tokens.size() && tokens.get(i).getType() != ETokenType.ILLEGAL_CHARACTER; ++i) {
            matlabCommandExpressionBuilder.append(tokens.get(i).getText());
            if (tokens.get(i).getType() == ETokenType.LPAREN) {
                ++openingParenCount;
                continue;
            }
            if (tokens.get(i).getType() == ETokenType.RPAREN && --openingParenCount <= 0) break;
        }
        return matlabCommandExpressionBuilder.toString();
    }

    private static boolean tokenIsMlNamespaceOrMlFunction(IToken token, IToken nextToken) {
        boolean nextTokenIsDotOrLparen = nextToken.getType() == ETokenType.LPAREN || nextToken.getType() == ETokenType.DOT;
        return token.getType() == ETokenType.IDENTIFIER && token.getText().equals("ml") && nextTokenIsDotOrLparen;
    }
}

