/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.stream;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public interface ICollectorWithException<T, A, R, E extends Exception> {
    public SupplierWithException<A, ? extends E> supplier() throws E;

    public BiConsumerWithException<A, T, ? extends E> accumulator() throws E;

    public BiFunctionWithException<A, A, A, ? extends E> combiner() throws E;

    public FunctionWithException<A, R, ? extends E> finisher() throws E;

    default public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    public static <T, A, R, E extends Exception> ICollectorWithException<T, A, R, E> of(final Collector<T, A, R> collector) {
        return new ICollectorWithException<T, A, R, E>(){

            @Override
            public SupplierWithException<A, ? extends E> supplier() {
                return ((Supplier)collector.supplier())::get;
            }

            @Override
            public BiConsumerWithException<A, T, ? extends E> accumulator() {
                return collector.accumulator()::accept;
            }

            @Override
            public BiFunctionWithException<A, A, A, ? extends E> combiner() {
                return collector.combiner()::apply;
            }

            @Override
            public FunctionWithException<A, R, ? extends E> finisher() {
                return collector.finisher()::apply;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return collector.characteristics();
            }
        };
    }
}

