/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

public class OptionMapping {
    private static final String TSV_FILE_HEADER = "Check ID in Tool\tOption Name";
    public final String checkId;
    public final String optionName;

    public OptionMapping(String checkId, String optionName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)checkId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isEmpty((String)optionName) ? 1 : 0) != 0);
        this.checkId = checkId;
        this.optionName = optionName;
    }

    public static ListMap<String, OptionMapping> readMappingsFromTsv(Resource resource) {
        ListMap optionMappings = new ListMap();
        List lines = resource.getLines();
        CCSMAssert.isTrue((lines.isEmpty() || ((String)lines.getFirst()).equals(TSV_FILE_HEADER) ? 1 : 0) != 0, (String)"TSV file header of check-options mappings file is not as expected");
        lines.removeFirst();
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            String[] parts = line.split("\t");
            CCSMAssert.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Line " + line + " is missing a tab!"));
            String checkId = parts[0].trim();
            String optionName = parts[1].trim();
            optionMappings.add((Object)checkId, (Object)new OptionMapping(checkId, optionName));
        }
        return optionMappings;
    }

    public String toTsvFileRow() {
        return String.join((CharSequence)"\t", this.checkId, this.optionName);
    }

    public static CharSequence toTsvFileContent(List<OptionMapping> optionMappings) {
        return Stream.concat(Stream.of(TSV_FILE_HEADER), optionMappings.stream().map(OptionMapping::toTsvFileRow)).collect(Collectors.joining("\n"));
    }
}

