/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;

class SwiftCompilerControlStatements {
    private static final Set<String> CONDITIONAL_DIRECTIVES = Set.of("#if", "#elseif", "#else", "#endif");
    private static final Set<String> LINECONTROL_DIRECTIVES = Set.of("#sourceLocation");
    private static final Set<String> AVAILABILITY_CONDITION_DIRECTIVES = Set.of("#available", "#unavailable");

    SwiftCompilerControlStatements() {
    }

    private static boolean hasTokenText(@NonNull IToken token, @NonNull String text) {
        return text.equals(token.getText());
    }

    public static boolean isDirective(@NonNull IToken token) {
        return token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE;
    }

    public static boolean isConditional(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && CONDITIONAL_DIRECTIVES.contains(token.getText());
    }

    public static boolean isLineControl(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && LINECONTROL_DIRECTIVES.contains(token.getText());
    }

    public static boolean isAvailability(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && AVAILABILITY_CONDITION_DIRECTIVES.contains(token.getText());
    }

    public static boolean isIf(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && SwiftCompilerControlStatements.hasTokenText(token, "#if");
    }

    public static boolean isEndif(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && SwiftCompilerControlStatements.hasTokenText(token, "#endif");
    }

    public static boolean isElseif(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && SwiftCompilerControlStatements.hasTokenText(token, "#elseif");
    }

    public static boolean isElse(@NonNull IToken token) {
        return SwiftCompilerControlStatements.isDirective(token) && SwiftCompilerControlStatements.hasTokenText(token, "#else");
    }

    public static int findFirstIfDirective(@NonNull List<IToken> tokens, int startIndex, int endIndex) {
        return TokenStreamUtils.firstTokenOfTypeWithText(tokens, startIndex, endIndex, Collections.singleton(ETokenType.PREPROCESSOR_DIRECTIVE), "#if");
    }
}

