/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class PlatformConditionBase {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final TokenPattern GENERIC_PARSE_PATTERN = new TokenPattern().sequence(new TokenPattern().sequence(ETokenType.IDENTIFIER).group(1).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false).group(2)).group(0);
    public final @NonNull String name;

    protected PlatformConditionBase(@NonNull String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
    }

    public abstract @NonNull PlatformConditionBase copyWithName(@NonNull String var1);

    public abstract @NonNull PlatformConditionParseResult parse(@NonNull TokenStream var1) throws ParseException;

    public abstract @NonNull Object parseConfig(@NonNull String var1) throws ParseException;

    protected @NonNull GenericParseResult parseGeneric(@NonNull TokenStream tokenStream) throws ParseException {
        TokenPatternMatch match = GENERIC_PARSE_PATTERN.matchAtCurrentPosition(tokenStream);
        PlatformConditionBase.verifyMatch(tokenStream, match, 0, 1, 2);
        IToken nameToken = match.groupTokens(1).get(0);
        if (!this.name.equals(nameToken.getText())) {
            throw new ParseException("Generic parse failed due to unequal names '%s' != '%s' at: %s".formatted(this.name, nameToken.getText(), tokenStream.peekCurrent()));
        }
        int tokenCount = match.groupTokenCount(0).orElseThrow(() -> new ParseException("Generic parse failed due to missing match 0 at: " + String.valueOf(tokenStream.peekCurrent())));
        List<IToken> valueTokens = match.groupTokens(2);
        return new GenericParseResult(tokenCount, nameToken, valueTokens);
    }

    static Optional<String> looksLikePlatformCondition(@NonNull TokenStream tokenStream) {
        TokenPatternMatch match = GENERIC_PARSE_PATTERN.matchAtCurrentPosition(tokenStream);
        try {
            PlatformConditionBase.verifyMatch(tokenStream, match, 0, 1, 2);
        }
        catch (ParseException e) {
            return Optional.empty();
        }
        List<IToken> nameTokens = match.groupTokens(1);
        return Optional.of(nameTokens.get(0).getText());
    }

    @Contract(value="_, null, _ -> fail")
    protected static void verifyMatch(@NonNull TokenStream tokenStream, @Nullable TokenPatternMatch match, int ... expectedGroups) throws ParseException {
        if (match == null) {
            throw new ParseException("Parse pattern did not match at: " + String.valueOf(tokenStream.peekCurrent()));
        }
        for (int groupIndex : expectedGroups) {
            if (match.hasGroup(groupIndex)) continue;
            throw new ParseException("Parse pattern match misses at least group %d at: %s".formatted(groupIndex, tokenStream.peekCurrent()));
        }
    }

    public abstract String toString();

    protected record GenericParseResult(int tokenCount, IToken nameToken, List<IToken> valueTokens) {
    }
}

