/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.dart;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.base.MatcherUtils;
import java.util.List;

class DartSubExpressionRecognizer
extends RecognizerBase<EGenericParserStates> {
    private static final List<List<ETokenType>> LAMBDA_START_SEQUENCES = List.of(List.of(ETokenType.RPAREN, ETokenType.LBRACE), List.of(ETokenType.RPAREN, ETokenType.ASYNC, ETokenType.LBRACE));

    DartSubExpressionRecognizer() {
    }

    @Override
    protected int matchesLocally(ParserState<EGenericParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (TokenStreamUtils.hasTokenTypeSequence(tokens, startOffset, ETokenType.SWITCH)) {
            return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
        }
        if (TokenStreamUtils.hasTokenTypeSequence(tokens, startOffset, ETokenType.LPAREN)) {
            for (List<ETokenType> lambdaStartSequence : LAMBDA_START_SEQUENCES) {
                int nestedOffset = TokenStreamUtils.skipTo(tokens, startOffset + 1, DartSubExpressionRecognizer::isParameterListPart, lambdaStartSequence);
                if (nestedOffset < 0) continue;
                int jumpToOffset = nestedOffset + lambdaStartSequence.size() - 1;
                return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, jumpToOffset);
            }
        }
        return MatcherUtils.matchesLambdaWithArrow(parserState, tokens, startOffset, ETokenType.DOUBLE_ARROW);
    }

    private static boolean isParameterListPart(IToken token) {
        return token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.COMMA || token.getType().getTokenClass() == ETokenType.ETokenClass.KEYWORD;
    }
}

