/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.languages.cs.CsShallowParser;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptShallowParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class VariableNameFragmentParser {
    private static final EnumSet<ELanguage> LANGUAGES_TYPE_INFO_AFTER_COLON = EnumSet.of(ELanguage.JAVASCRIPT, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.SWIFT);
    private static final Set<ETokenType> CONTEXTUAL_KEYWORDS = ImmutableSet.of((Object)ETokenType.ADD, (Object)ETokenType.ALIAS, (Object)ETokenType.ASCENDING, (Object)ETokenType.ASYNC, (Object)ETokenType.AWAIT, (Object)ETokenType.DESCENDING, (Object[])new ETokenType[]{ETokenType.DYNAMIC, ETokenType.FROM, ETokenType.GET, ETokenType.GLOBAL, ETokenType.GROUP, ETokenType.INTO, ETokenType.JOIN, ETokenType.LET, ETokenType.ORDERBY, ETokenType.PARTIAL, ETokenType.REMOVE, ETokenType.SELECT, ETokenType.SET, ETokenType.VALUE, ETokenType.VAR, ETokenType.WHEN, ETokenType.WHERE, ETokenType.YIELD});
    private static final EnumSet<ETokenType> OPENING_TOKENS = EnumSet.of(ETokenType.LBRACK, ETokenType.LT, ETokenType.LPAREN, ETokenType.LBRACE);
    private static final EnumSet<ETokenType> CLOSING_TOKENS = EnumSet.of(ETokenType.RBRACK, ETokenType.GT, ETokenType.RPAREN, ETokenType.RBRACE);
    private static final EnumSet<ETokenType> VARIABLE_NAME_SUCCESSOR_TYPES = EnumSet.of(ETokenType.COMMA, new ETokenType[]{ETokenType.ARRAY_SEPARATOR, ETokenType.EQ, ETokenType.EOL, ETokenType.EQUAL, ETokenType.SEMICOLON});
    private final List<IToken> tokens;
    private final boolean ignoreParameterTypes;
    private int parenthesisNesting = 0;
    private IToken previousToken = null;
    private ETokenType beforePreviousType = null;

    private VariableNameFragmentParser(List<IToken> declarationFragment, boolean ignoreParameterTypes) {
        this.tokens = declarationFragment;
        this.ignoreParameterTypes = ignoreParameterTypes;
    }

    public static Optional<IToken> extract(List<IToken> declarationFragment, boolean ignoreParameterTypes) {
        return new VariableNameFragmentParser(declarationFragment, ignoreParameterTypes).extractVariable();
    }

    private Optional<IToken> extractVariable() {
        for (IToken token : this.tokens) {
            boolean startOfTypeInfo;
            if (this.handleParenthesis(token)) continue;
            if (token.getType() == ETokenType.QUESTION) {
                this.updatePreviousToken(this.previousToken);
                continue;
            }
            boolean bl = startOfTypeInfo = token.getType() == ETokenType.COLON && LANGUAGES_TYPE_INFO_AFTER_COLON.contains(token.getLanguage());
            if ((startOfTypeInfo || VARIABLE_NAME_SUCCESSOR_TYPES.contains(token.getType())) && this.isNonNestedVariable()) {
                return Optional.of(this.previousToken);
            }
            if (token.getLanguage() == ELanguage.CS && token.getType() == ETokenType.DOUBLE_ARROW) break;
            this.updatePreviousToken(token);
        }
        if (this.isNonNestedVariable()) {
            return Optional.of(this.previousToken);
        }
        return Optional.empty();
    }

    private boolean handleParenthesis(IToken token) {
        if (OPENING_TOKENS.contains(token.getType())) {
            ++this.parenthesisNesting;
            this.updatePreviousToken(token);
            return true;
        }
        if (CLOSING_TOKENS.contains(token.getType())) {
            --this.parenthesisNesting;
            return true;
        }
        return false;
    }

    private void updatePreviousToken(IToken token) {
        if (this.parenthesisNesting == 0) {
            if (this.previousToken != null) {
                if (this.ignoreParameterTypes && this.previousToken.getType() == ETokenType.COLON && LANGUAGES_TYPE_INFO_AFTER_COLON.contains(token.getLanguage())) {
                    this.previousToken = null;
                    this.beforePreviousType = null;
                    return;
                }
                this.beforePreviousType = this.previousToken.getType();
            }
            this.previousToken = token;
        }
    }

    private boolean isNonNestedVariable() {
        return this.parenthesisNesting == 0 && this.isVariableName(this.previousToken, this.beforePreviousType);
    }

    private boolean isVariableName(IToken token, ETokenType beforeTokenType) {
        if (token == null || this.isCppParameterType(token, beforeTokenType)) {
            return false;
        }
        if (this.isValidIdentifier(token)) {
            return true;
        }
        if (token.getLanguage() == ELanguage.JAVASCRIPT) {
            return JavaScriptShallowParser.ALL_IDENTIFIERS.matches(token);
        }
        if (token.getLanguage() == ELanguage.CS) {
            return CONTEXTUAL_KEYWORDS.contains(token.getType());
        }
        return false;
    }

    private boolean isValidIdentifier(IToken token) {
        switch (token.getLanguage()) {
            case CPP: 
            case CPP_MS_CLI: {
                if (!LanguageFeatureParser.CPP.isValidIdentifier(token)) break;
                return true;
            }
            case C: {
                if (!LanguageFeatureParser.C.isValidIdentifier(token)) break;
                return true;
            }
            case CS: {
                if (!CsShallowParser.VALID_IDENTIFIERS.matches(token)) break;
                return true;
            }
            case JAVA: {
                if (!LanguageFeatureParser.JAVA.getValidIdentifierTokenTypes().matches(token)) break;
                return true;
            }
        }
        return token.getType() == ETokenType.IDENTIFIER;
    }

    private boolean isCppParameterType(IToken token, ETokenType beforeTokenType) {
        return token.getLanguage().isCppOrC() && this.ignoreParameterTypes && (beforeTokenType == ETokenType.COMMA || beforeTokenType == null || beforeTokenType == ETokenType.SCOPE || beforeTokenType == ETokenType.CONST);
    }
}

